/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki;

import jakarta.servlet.ServletContext;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.lib.Version;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.system.streammgr.LocatorFTP;
import org.apache.jena.riot.system.streammgr.LocatorHTTP;
import org.apache.jena.riot.system.streammgr.StreamManager;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fuseki {
    public static final String PATH = "org.apache.jena.fuseki";
    public static final String FusekiIRI = "http://jena.apache.org/Fuseki";
    public static final String FusekiSymbolIRI = "http://jena.apache.org/fuseki#";
    public static final String BaseParserSPARQL = "http://server/unset-base/";
    public static final String BaseUpload = "http://server/unset-base/";
    public static final String NAME = "Apache Jena Fuseki";
    public static final String VERSION = Version.versionForClass(Fuseki.class).orElse("<development>");
    public static final boolean GSP_DIRECT_NAMING = false;
    public static boolean developmentMode;
    public static boolean outputJettyServerHeader;
    public static boolean outputFusekiServerHeader;
    public static final String serverHttpName;
    public static final String actionLogName = "org.apache.jena.fuseki.Fuseki";
    public static final Logger actionLog;
    public static final Logger fusekiLog;
    public static final String requestLogName = "org.apache.jena.fuseki.Request";
    public static final Logger requestLog;
    public static final String adminLogName = "org.apache.jena.fuseki.Admin";
    public static final Logger adminLog;
    public static final Logger validationLog;
    public static final String serverLogName = "org.apache.jena.fuseki.Server";
    public static final Logger serverLog;
    public static final String servletRequestLogName = "org.apache.jena.fuseki.Servlet";
    public static final String configLogName = "org.apache.jena.fuseki.Config";
    public static final Logger configLog;
    public static final String backupLogName = "org.apache.jena.fuseki.Backup";
    public static final Logger backupLog;
    public static final String compactLogName = "org.apache.jena.fuseki.Compact";
    public static final Logger compactLog;
    public static int SC_QueryCancelled;
    public static final String attrVerbose = "org.apache.jena.fuseki:verbose";
    public static final String attrNameRegistry = "org.apache.jena.fuseki:DataAccessPointRegistry";
    public static final String attrOperationRegistry = "org.apache.jena.fuseki:OperationRegistry";
    public static final String attrMetricsProvider = "org.apache.jena.fuseki:MetricsProvider";
    public static final String attrShiroResource = "org.apache.jena.fuseki:ShiroResource";
    public static final String attrAuthorizationService = "org.apache.jena.fuseki:AuthorizationService";
    public static final String attrFusekiServer = "org.apache.jena.fuseki:Server";
    public static final String attrFusekiServerCtl = "org.apache.jena.fuseki:ServerCtl";
    public static final StreamManager webStreamManager;
    public static String FusekiRequestIdHeader;
    private static final long startMillis;
    private static final String startDateTime;

    public static void initConsts() {
    }

    public static void setVerbose(ServletContext cxt, boolean verbose) {
        cxt.setAttribute(attrVerbose, verbose);
    }

    public static boolean getVerbose(ServletContext cxt) {
        Object x = cxt.getAttribute(attrVerbose);
        if (x == null) {
            return false;
        }
        if (x instanceof Boolean) {
            Boolean bool = (Boolean)x;
            return bool;
        }
        throw new FusekiException("attrVerbose: unknown object class: " + x.getClass().getName());
    }

    private static String calculateServerStartTime(long milliseconds) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("00:00"));
        cal.setTimeInMillis(milliseconds);
        String x = DateTimeUtils.calendarToXSDDateTimeString(cal);
        return x;
    }

    public static long serverUptimeMillis() {
        return System.currentTimeMillis() - startMillis;
    }

    public static long serverUptimeSeconds() {
        long x = System.currentTimeMillis() - startMillis;
        return TimeUnit.MILLISECONDS.toSeconds(x);
    }

    public static String serverStartedAt() {
        return startDateTime;
    }

    public static Context getContext() {
        return ARQ.getContext();
    }

    static {
        outputJettyServerHeader = developmentMode = VERSION == null || VERSION.equals("development") || VERSION.contains("SNAPSHOT");
        outputFusekiServerHeader = developmentMode;
        serverHttpName = "Apache Jena Fuseki (" + VERSION + ")";
        actionLog = LoggerFactory.getLogger(actionLogName);
        fusekiLog = LoggerFactory.getLogger(actionLogName);
        requestLog = LoggerFactory.getLogger(requestLogName);
        adminLog = LoggerFactory.getLogger(adminLogName);
        validationLog = actionLog;
        serverLog = LoggerFactory.getLogger(serverLogName);
        configLog = LoggerFactory.getLogger(configLogName);
        backupLog = LoggerFactory.getLogger(backupLogName);
        compactLog = LoggerFactory.getLogger(compactLogName);
        SC_QueryCancelled = 503;
        webStreamManager = new StreamManager();
        webStreamManager.addLocator(new LocatorHTTP());
        webStreamManager.addLocator(new LocatorFTP());
        FusekiRequestIdHeader = "Fuseki-Request-Id";
        startMillis = System.currentTimeMillis();
        startDateTime = Fuseki.calculateServerStartTime(startMillis);
    }
}

