/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.cdt;

import java.util.List;
import java.util.Map;
import org.apache.jena.cdt.CDTKey;
import org.apache.jena.cdt.CDTValue;
import org.apache.jena.cdt.CompositeDatatypeList;
import org.apache.jena.cdt.CompositeDatatypeMap;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;

public class CDTFactory {
    private static CDTValue nullValue = null;

    public static CDTKey createKey(final Node n) {
        return new CDTKey(){

            @Override
            public Node asNode() {
                return n;
            }
        };
    }

    public static CDTValue createValue(final Node n) {
        return new CDTValue(){

            @Override
            public boolean isNode() {
                return true;
            }

            @Override
            public Node asNode() {
                return n;
            }
        };
    }

    public static CDTValue createValue(List<CDTValue> l) {
        Node n = NodeFactory.createLiteralByValue(l, CompositeDatatypeList.datatype());
        return CDTFactory.createValue(n);
    }

    public static CDTValue createValue(Map<CDTKey, CDTValue> m) {
        Node n = NodeFactory.createLiteralByValue(m, CompositeDatatypeMap.datatype());
        return CDTFactory.createValue(n);
    }

    public static CDTValue getNullValue() {
        if (nullValue == null) {
            return new CDTValue(){

                @Override
                public boolean isNull() {
                    return true;
                }
            };
        }
        return nullValue;
    }
}

