/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.loader;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.StringUtils;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.http.media.MediaType;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import com.apicatalog.jsonld.loader.DocumentReader;
import com.apicatalog.jsonld.loader.DocumentResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FileLoader
implements DocumentLoader {
    private static final Logger LOGGER = Logger.getLogger(FileLoader.class.getName());
    private final DocumentResolver resolver = new DocumentResolver();

    public FileLoader() {
        this.resolver.setFallbackContentType(MediaType.JSON);
    }

    @Override
    public Document loadDocument(URI url, DocumentLoaderOptions options) throws JsonLdError {
        Document document;
        if (!"file".equalsIgnoreCase(url.getScheme())) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Unsupported URL scheme [" + url.getScheme() + "]. FileLoader accepts only file scheme.");
        }
        File file = new File(url);
        if (!file.canRead()) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "File [" + String.valueOf(url) + "] is not accessible to read.");
        }
        MediaType contentType = FileLoader.detectedContentType(url.getPath().toLowerCase()).orElseGet(() -> {
            LOGGER.log(Level.WARNING, "Cannot detect file [{0}] content type. Trying application/json.", url);
            return MediaType.JSON;
        });
        DocumentReader<InputStream> reader = this.resolver.getReader(contentType);
        FileInputStream is = new FileInputStream(file);
        try {
            Document document2 = reader.read(is);
            document2.setDocumentUrl(url);
            document = document2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "File not found [" + String.valueOf(url) + "].");
            }
            catch (IOException e) {
                throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, (Throwable)e);
            }
        }
        ((InputStream)is).close();
        return document;
    }

    private static final Optional<MediaType> detectedContentType(String name) {
        if (name == null || StringUtils.isBlank(name)) {
            return Optional.empty();
        }
        if (name.endsWith(".nq")) {
            return Optional.of(MediaType.N_QUADS);
        }
        if (name.endsWith(".json")) {
            return Optional.of(MediaType.JSON);
        }
        if (name.endsWith(".jsonld")) {
            return Optional.of(MediaType.JSON_LD);
        }
        if (name.endsWith(".html")) {
            return Optional.of(MediaType.HTML);
        }
        return Optional.empty();
    }
}

