/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection;

import com.github.andrewoma.dexx.collection.ArrayList;
import com.github.andrewoma.dexx.collection.Builder;
import com.github.andrewoma.dexx.collection.BuilderFactory;
import com.github.andrewoma.dexx.collection.Function;
import com.github.andrewoma.dexx.collection.IndexedList;
import com.github.andrewoma.dexx.collection.Traversable;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class ArrayLists {
    private ArrayLists() {
    }

    @NotNull
    public static <E> IndexedList<E> of(E ... elements) {
        return ArrayLists.copyOf(elements);
    }

    @NotNull
    public static <E> IndexedList<E> copyOf(Iterable<E> iterable) {
        Builder<E, ArrayList<E>> builder = ArrayList.factory().newBuilder();
        for (E e : iterable) {
            builder.add(e);
        }
        return builder.build();
    }

    @NotNull
    public static <E> IndexedList<E> copyOf(Iterator<E> iterator) {
        Builder<E, ArrayList<E>> builder = ArrayList.factory().newBuilder();
        while (iterator.hasNext()) {
            builder.add(iterator.next());
        }
        return builder.build();
    }

    @NotNull
    public static <E> IndexedList<E> copyOf(E[] es) {
        Object[] copy = new Object[es.length];
        System.arraycopy(es, 0, copy, 0, es.length);
        return new ArrayList(copy);
    }

    @NotNull
    public static <E> IndexedList<E> copyOfTraversable(Traversable<E> traversable) {
        final Builder builder = ArrayList.factory().newBuilder();
        traversable.forEach(new Function<E, Object>(){

            @Override
            public Object invoke(E e) {
                builder.add(e);
                return null;
            }
        });
        return builder.build();
    }

    @NotNull
    public static <E> BuilderFactory<E, IndexedList<E>> factory() {
        return ArrayList.factory();
    }

    @NotNull
    public static <E> Builder<E, IndexedList<E>> builder() {
        return ArrayLists.factory().newBuilder();
    }
}

