/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.op;

import java.util.List;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.op.OpN;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class OpDisjunction
extends OpN {
    public static OpDisjunction create() {
        return new OpDisjunction();
    }

    public static Op create(Op left, Op right) {
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        if (left instanceof OpDisjunction) {
            OpDisjunction opDisjunction = (OpDisjunction)left;
            opDisjunction.add(right);
            return opDisjunction;
        }
        OpDisjunction stage = new OpDisjunction();
        stage.add(left);
        stage.add(right);
        return stage;
    }

    private OpDisjunction(List<Op> elts) {
        super(elts);
    }

    private OpDisjunction() {
    }

    @Override
    public String getName() {
        return "disjunction";
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    @Override
    public boolean equalTo(Op op, NodeIsomorphismMap labelMap) {
        if (!(op instanceof OpDisjunction)) {
            return false;
        }
        OpDisjunction other = (OpDisjunction)op;
        return super.equalsSubOps(other, labelMap);
    }

    @Override
    public Op apply(Transform transform, List<Op> elts) {
        return transform.transform(this, elts);
    }

    @Override
    public OpN copy(List<Op> elts) {
        return new OpDisjunction(elts);
    }
}

