/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.UrlUtils;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.encoding.encoder.Encoder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.DateUtils;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionUtils.class);
    private static final byte TYPE_NULL = -2;
    private static final int EMPTY_DATE_INT = 10000101;

    public static ByteBuffer getTimeBuffer(Tablet tablet) {
        ByteBuffer timeBuffer = ByteBuffer.allocate(SessionUtils.getTimeBytesSize(tablet));
        for (int i = 0; i < tablet.getRowSize(); ++i) {
            timeBuffer.putLong(tablet.getTimestamp(i));
        }
        timeBuffer.flip();
        return timeBuffer;
    }

    public static ByteBuffer getValueBuffer(Tablet tablet) {
        ByteBuffer valueBuffer = ByteBuffer.allocate(SessionUtils.getTotalValueOccupation(tablet));
        for (int i = 0; i < tablet.getSchemas().size(); ++i) {
            IMeasurementSchema schema = (IMeasurementSchema)tablet.getSchemas().get(i);
            SessionUtils.getValueBufferOfDataType(schema.getType(), tablet, i, valueBuffer);
        }
        BitMap[] bitMaps = tablet.getBitMaps();
        if (bitMaps != null) {
            for (BitMap bitMap : bitMaps) {
                boolean columnHasNull = bitMap != null && !bitMap.isAllUnmarked(tablet.getRowSize());
                valueBuffer.put(BytesUtils.boolToByte((boolean)columnHasNull));
                if (!columnHasNull) continue;
                valueBuffer.put(bitMap.getTruncatedByteArray(tablet.getRowSize()));
            }
        }
        valueBuffer.flip();
        return valueBuffer;
    }

    private static int getTimeBytesSize(Tablet tablet) {
        return tablet.getRowSize() * 8;
    }

    private static int getTotalValueOccupation(Tablet tablet) {
        int valueOccupation = 0;
        int columnIndex = 0;
        List schemas = tablet.getSchemas();
        int rowSize = tablet.getRowSize();
        for (IMeasurementSchema schema : schemas) {
            valueOccupation += SessionUtils.calOccupationOfOneColumn(schema.getType(), tablet.getValues(), columnIndex, rowSize);
            ++columnIndex;
        }
        BitMap[] bitMaps = tablet.getBitMaps();
        if (bitMaps != null) {
            for (BitMap bitMap : bitMaps) {
                ++valueOccupation;
                if (bitMap == null || bitMap.isAllUnmarked()) continue;
                valueOccupation += rowSize / 8 + 1;
            }
        }
        return valueOccupation;
    }

    private static int calOccupationOfOneColumn(TSDataType dataType, Object[] values, int columnIndex, int rowSize) {
        int valueOccupation = 0;
        switch (dataType) {
            case BOOLEAN: {
                valueOccupation += rowSize;
                break;
            }
            case INT32: 
            case FLOAT: 
            case DATE: {
                valueOccupation += rowSize * 4;
                break;
            }
            case INT64: 
            case DOUBLE: 
            case TIMESTAMP: {
                valueOccupation += rowSize * 8;
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                valueOccupation += rowSize * 4;
                Binary[] binaries = (Binary[])values[columnIndex];
                for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
                    valueOccupation += binaries[rowIndex] != null ? binaries[rowIndex].getLength() : Binary.EMPTY_VALUE.getLength();
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", dataType));
            }
        }
        return valueOccupation;
    }

    public static ByteBuffer getValueBuffer(List<TSDataType> types, List<Object> values, List<String> measurements) throws IoTDBConnectionException {
        ByteBuffer buffer = ByteBuffer.allocate(SessionUtils.calculateLength(types, values));
        SessionUtils.putValues(types, values, buffer, measurements);
        return buffer;
    }

    public static int calculateLength(List<TSDataType> types, List<? extends Object> values) throws IoTDBConnectionException {
        int res = 0;
        block9: for (int i = 0; i < types.size(); ++i) {
            ++res;
            switch (types.get(i)) {
                case BOOLEAN: {
                    ++res;
                    continue block9;
                }
                case INT32: 
                case DATE: {
                    res += 4;
                    continue block9;
                }
                case INT64: 
                case TIMESTAMP: {
                    res += 8;
                    continue block9;
                }
                case FLOAT: {
                    res += 4;
                    continue block9;
                }
                case DOUBLE: {
                    res += 8;
                    continue block9;
                }
                case TEXT: 
                case STRING: {
                    res += 4;
                    if (values.get(i) instanceof Binary) {
                        res += ((Binary)values.get(i)).getValues().length;
                        continue block9;
                    }
                    res += ((String)values.get(i)).getBytes(TSFileConfig.STRING_CHARSET).length;
                    continue block9;
                }
                case BLOB: {
                    res += 4;
                    res += ((Binary)values.get(i)).getValues().length;
                    continue block9;
                }
                default: {
                    throw new IoTDBConnectionException("Unsupported data type:" + types.get(i));
                }
            }
        }
        return res;
    }

    public static void putValues(List<TSDataType> types, List<? extends Object> values, ByteBuffer buffer, List<String> measurements) throws IoTDBConnectionException {
        for (int i = 0; i < values.size(); ++i) {
            try {
                if (values.get(i) == null) {
                    ReadWriteIOUtils.write((byte)-2, (ByteBuffer)buffer);
                    continue;
                }
                ReadWriteIOUtils.write((TSDataType)types.get(i), (ByteBuffer)buffer);
                switch (types.get(i)) {
                    case BOOLEAN: {
                        ReadWriteIOUtils.write((Boolean)((Boolean)values.get(i)), (ByteBuffer)buffer);
                        break;
                    }
                    case INT32: {
                        ReadWriteIOUtils.write((int)((Integer)values.get(i)), (ByteBuffer)buffer);
                        break;
                    }
                    case DATE: {
                        ReadWriteIOUtils.write((int)DateUtils.parseDateExpressionToInt((LocalDate)((LocalDate)values.get(i))), (ByteBuffer)buffer);
                        break;
                    }
                    case INT64: 
                    case TIMESTAMP: {
                        ReadWriteIOUtils.write((long)((Long)values.get(i)), (ByteBuffer)buffer);
                        break;
                    }
                    case FLOAT: {
                        ReadWriteIOUtils.write((float)((Float)values.get(i)).floatValue(), (ByteBuffer)buffer);
                        break;
                    }
                    case DOUBLE: {
                        ReadWriteIOUtils.write((double)((Double)values.get(i)), (ByteBuffer)buffer);
                        break;
                    }
                    case TEXT: 
                    case STRING: {
                        byte[] bytes = values.get(i) instanceof Binary ? ((Binary)values.get(i)).getValues() : ((String)values.get(i)).getBytes(TSFileConfig.STRING_CHARSET);
                        ReadWriteIOUtils.write((int)bytes.length, (ByteBuffer)buffer);
                        buffer.put(bytes);
                        break;
                    }
                    case BLOB: {
                        byte[] bytes = ((Binary)values.get(i)).getValues();
                        ReadWriteIOUtils.write((int)bytes.length, (ByteBuffer)buffer);
                        buffer.put(bytes);
                        break;
                    }
                    default: {
                        throw new IoTDBConnectionException("Unsupported data type:" + types.get(i));
                    }
                }
                continue;
            }
            catch (Throwable e) {
                LOGGER.error("Cannot put values for measurement {}, type={}", new Object[]{measurements.get(i), types.get(i), e});
                throw e;
            }
        }
        buffer.flip();
    }

    private static void getValueBufferOfDataType(TSDataType dataType, Tablet tablet, int i, ByteBuffer valueBuffer) {
        switch (dataType) {
            case INT32: {
                int[] intValues = (int[])tablet.getValues()[i];
                for (int index = 0; index < tablet.getRowSize(); ++index) {
                    if (!tablet.isNull(index, i)) {
                        valueBuffer.putInt(intValues[index]);
                        continue;
                    }
                    valueBuffer.putInt(Integer.MIN_VALUE);
                }
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                long[] longValues = (long[])tablet.getValues()[i];
                for (int index = 0; index < tablet.getRowSize(); ++index) {
                    if (!tablet.isNull(index, i)) {
                        valueBuffer.putLong(longValues[index]);
                        continue;
                    }
                    valueBuffer.putLong(Long.MIN_VALUE);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])tablet.getValues()[i];
                for (int index = 0; index < tablet.getRowSize(); ++index) {
                    if (!tablet.isNull(index, i)) {
                        valueBuffer.putFloat(floatValues[index]);
                        continue;
                    }
                    valueBuffer.putFloat(Float.MIN_VALUE);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])tablet.getValues()[i];
                for (int index = 0; index < tablet.getRowSize(); ++index) {
                    if (!tablet.isNull(index, i)) {
                        valueBuffer.putDouble(doubleValues[index]);
                        continue;
                    }
                    valueBuffer.putDouble(Double.MIN_VALUE);
                }
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])tablet.getValues()[i];
                for (int index = 0; index < tablet.getRowSize(); ++index) {
                    if (!tablet.isNull(index, i)) {
                        valueBuffer.put(BytesUtils.boolToByte((boolean)boolValues[index]));
                        continue;
                    }
                    valueBuffer.put(BytesUtils.boolToByte((boolean)false));
                }
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                Binary[] binaryValues = (Binary[])tablet.getValues()[i];
                for (int index = 0; index < tablet.getRowSize(); ++index) {
                    if (!tablet.isNull(index, i) && binaryValues[index] != null) {
                        valueBuffer.putInt(binaryValues[index].getLength());
                        valueBuffer.put(binaryValues[index].getValues());
                        continue;
                    }
                    valueBuffer.putInt(Binary.EMPTY_VALUE.getLength());
                    valueBuffer.put(Binary.EMPTY_VALUE.getValues());
                }
                break;
            }
            case DATE: {
                LocalDate[] dateValues = (LocalDate[])tablet.getValues()[i];
                for (int index = 0; index < tablet.getRowSize(); ++index) {
                    if (!tablet.isNull(index, i) && dateValues[index] != null) {
                        valueBuffer.putInt(DateUtils.parseDateExpressionToInt((LocalDate)dateValues[index]));
                        continue;
                    }
                    valueBuffer.putInt(10000101);
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", dataType));
            }
        }
    }

    public static void encodeValue(TSDataType dataType, Tablet tablet, int i, Encoder encoder, ByteArrayOutputStream outputStream) {
        switch (dataType) {
            case INT32: {
                int[] intValues = (int[])tablet.getValues()[i];
                for (int index = 0; index < tablet.getRowSize(); ++index) {
                    if (!tablet.isNull(index, i)) {
                        encoder.encode(intValues[index], outputStream);
                        continue;
                    }
                    if (index == 0) {
                        encoder.encode(intValues[index], outputStream);
                        continue;
                    }
                    encoder.encode(intValues[index - 1], outputStream);
                }
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                long[] longValues = (long[])tablet.getValues()[i];
                for (int index = 0; index < tablet.getRowSize(); ++index) {
                    if (!tablet.isNull(index, i)) {
                        encoder.encode(longValues[index], outputStream);
                        continue;
                    }
                    if (index == 0) {
                        encoder.encode(longValues[index], outputStream);
                        continue;
                    }
                    encoder.encode(longValues[index - 1], outputStream);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])tablet.getValues()[i];
                for (int index = 0; index < tablet.getRowSize(); ++index) {
                    if (!tablet.isNull(index, i)) {
                        encoder.encode(floatValues[index], outputStream);
                        continue;
                    }
                    if (index == 0) {
                        encoder.encode(floatValues[index], outputStream);
                        continue;
                    }
                    encoder.encode(floatValues[index - 1], outputStream);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])tablet.getValues()[i];
                for (int index = 0; index < tablet.getRowSize(); ++index) {
                    if (!tablet.isNull(index, i)) {
                        encoder.encode(doubleValues[index], outputStream);
                        continue;
                    }
                    if (index == 0) {
                        encoder.encode(doubleValues[index], outputStream);
                        continue;
                    }
                    encoder.encode(doubleValues[index - 1], outputStream);
                }
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])tablet.getValues()[i];
                for (int index = 0; index < tablet.getRowSize(); ++index) {
                    if (!tablet.isNull(index, i)) {
                        encoder.encode(boolValues[index], outputStream);
                        continue;
                    }
                    if (index == 0) {
                        encoder.encode(boolValues[index], outputStream);
                        continue;
                    }
                    encoder.encode(boolValues[index - 1], outputStream);
                }
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                Binary[] binaryValues = (Binary[])tablet.getValues()[i];
                for (int index = 0; index < tablet.getRowSize(); ++index) {
                    if (!tablet.isNull(index, i)) {
                        encoder.encode(binaryValues[index], outputStream);
                        continue;
                    }
                    if (index == 0) {
                        encoder.encode(Binary.EMPTY_VALUE, outputStream);
                        continue;
                    }
                    encoder.encode(binaryValues[index - 1], outputStream);
                }
                break;
            }
            case DATE: {
                LocalDate[] dateValues = (LocalDate[])tablet.getValues()[i];
                for (int index = 0; index < tablet.getRowSize(); ++index) {
                    if (!tablet.isNull(index, i)) {
                        encoder.encode(DateUtils.parseDateExpressionToInt((LocalDate)dateValues[index]).intValue(), outputStream);
                        continue;
                    }
                    if (index == 0) {
                        encoder.encode(10000101, outputStream);
                        continue;
                    }
                    encoder.encode(DateUtils.parseDateExpressionToInt((LocalDate)dateValues[index - 1]).intValue(), outputStream);
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", dataType));
            }
        }
        try {
            encoder.flush(outputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean isTabletContainsSingleDevice(Tablet tablet) {
        if (tablet.getRowSize() == 1) {
            return true;
        }
        IDeviceID firstDeviceId = tablet.getDeviceID(0);
        for (int i = 1; i < tablet.getRowSize(); ++i) {
            if (firstDeviceId.equals(tablet.getDeviceID(i))) continue;
            return false;
        }
        return true;
    }

    public static List<TEndPoint> parseSeedNodeUrls(List<String> nodeUrls) {
        if (nodeUrls == null) {
            throw new NumberFormatException("nodeUrls is null");
        }
        ArrayList<TEndPoint> endPointsList = new ArrayList<TEndPoint>();
        for (String nodeUrl : nodeUrls) {
            TEndPoint endPoint = UrlUtils.parseTEndPointIpv4AndIpv6Url((String)nodeUrl);
            endPointsList.add(endPoint);
        }
        return endPointsList;
    }

    private SessionUtils() {
    }
}

