/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class Lazy<T> {
    private static final Object LAZY_NULL = new Object();
    private volatile Object value;

    public T getOrCompute(@NotNull Supplier<T> supplier) {
        Object v1 = this.value;
        if (v1 == LAZY_NULL) {
            return null;
        }
        if (v1 == null) {
            Object v2 = this.maybeCompute(supplier);
            return (T)(v2 == LAZY_NULL ? null : v2);
        }
        return (T)v1;
    }

    public synchronized void reset() {
        this.value = null;
    }

    private synchronized Object maybeCompute(Supplier<T> supplier) {
        if (this.value == null) {
            T supplied = supplier.get();
            this.value = supplied != null ? supplied : LAZY_NULL;
        }
        return this.value;
    }
}

