/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.builder;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.TableScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.GroupedAggregator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.UpdateMemory;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.builder.HashAggregationBuilder;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.hash.GroupByHash;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.relational.type.InternalTypeManager;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.read.common.type.Type;

public class InMemoryHashAggregationBuilder
implements HashAggregationBuilder {
    private final int[] groupByChannels;
    private GroupByHash groupByHash;
    private final List<Type> groupByOutputTypes;
    private final List<GroupedAggregator> groupedAggregators;
    private final boolean partial;
    private final OptionalLong maxPartialMemory;
    private final UpdateMemory updateMemory;
    private boolean full;
    private Iterator<Integer> groupIds;
    private final TsBlockBuilder pageBuilder;
    private final int expectedGroups;
    private final Optional<Integer> hashChannel;
    private final OperatorContext operatorContext;
    private static final String CURRENT_GROUP_NUMBER = "CurrentGroupNumber";
    private static final String MAX_GROUP_NUMBER = "MaxGroupNumber";
    private long maxGroupNumber;

    public InMemoryHashAggregationBuilder(List<GroupedAggregator> groupedAggregators, AggregationNode.Step step, int expectedGroups, List<Type> groupByTypes, List<Integer> groupByChannels, Optional<Integer> hashChannel, OperatorContext operatorContext, long maxPartialMemory, UpdateMemory updateMemory) {
        this(groupedAggregators, step, expectedGroups, groupByTypes, groupByChannels, hashChannel, operatorContext, maxPartialMemory, Optional.empty(), updateMemory);
    }

    public InMemoryHashAggregationBuilder(List<GroupedAggregator> groupedAggregators, AggregationNode.Step step, int expectedGroups, List<Type> groupByTypes, List<Integer> groupByChannels, Optional<Integer> hashChannel, OperatorContext operatorContext, long maxPartialMemory, Optional<Integer> unspillIntermediateChannelOffset, UpdateMemory updateMemory) {
        this.groupedAggregators = groupedAggregators;
        this.groupByOutputTypes = ImmutableList.copyOf(groupByTypes);
        this.groupByChannels = Ints.toArray(groupByChannels);
        this.groupByHash = GroupByHash.createGroupByHash(groupByTypes, hashChannel.isPresent(), expectedGroups, updateMemory);
        this.partial = step.isOutputPartial();
        this.maxPartialMemory = OptionalLong.of(maxPartialMemory);
        this.updateMemory = updateMemory;
        this.pageBuilder = new TsBlockBuilder(this.buildTypes());
        this.expectedGroups = expectedGroups;
        this.hashChannel = hashChannel;
        this.operatorContext = operatorContext;
    }

    @Override
    public void close() {
    }

    @Override
    public void processBlock(TsBlock block) {
        if (this.groupedAggregators.isEmpty()) {
            this.groupByHash.addPage(block.getColumns(this.groupByChannels));
        }
        int[] groupByIdBlock = this.groupByHash.getGroupIds(block.getColumns(this.groupByChannels));
        int groupCount = this.groupByHash.getGroupCount();
        this.operatorContext.recordSpecifiedInfo(CURRENT_GROUP_NUMBER, Long.toString(groupCount));
        if ((long)groupCount > this.maxGroupNumber) {
            this.operatorContext.recordSpecifiedInfo(MAX_GROUP_NUMBER, Long.toString(groupCount));
            this.maxGroupNumber = groupCount;
        }
        for (GroupedAggregator groupedAggregator : this.groupedAggregators) {
            groupedAggregator.processBlock(groupCount, groupByIdBlock, block);
        }
    }

    @Override
    public void updateMemory() {
    }

    @Override
    public void reset() {
        this.groupByHash = GroupByHash.createGroupByHash(this.groupByOutputTypes, this.hashChannel.isPresent(), this.expectedGroups, this.updateMemory);
        this.groupedAggregators.forEach(GroupedAggregator::reset);
        this.full = false;
        this.groupIds = null;
        this.pageBuilder.reset();
    }

    @Override
    public boolean isFull() {
        return this.full;
    }

    @Override
    public long getEstimatedSize() {
        long sizeInMemory = this.groupByHash.getEstimatedSize();
        for (GroupedAggregator groupedAggregator : this.groupedAggregators) {
            sizeInMemory += groupedAggregator.getEstimatedSize();
        }
        this.updateIsFull(sizeInMemory);
        return sizeInMemory;
    }

    private void updateIsFull(long sizeInMemory) {
        if (!this.partial || !this.maxPartialMemory.isPresent()) {
            return;
        }
        this.full = sizeInMemory > this.maxPartialMemory.getAsLong();
    }

    public long getGroupIdsSortingSize() {
        return this.getGroupCount() * 4L;
    }

    public void setSpillOutput() {
        for (GroupedAggregator groupedAggregator : this.groupedAggregators) {
        }
    }

    public int getKeyChannels() {
        return this.groupByChannels.length;
    }

    public long getGroupCount() {
        return this.groupByHash.getGroupCount();
    }

    @Override
    public TsBlock buildResult() {
        return this.buildResult(this.consecutiveGroupIds());
    }

    @Override
    public boolean finished() {
        return !this.groupIds.hasNext();
    }

    public List<Type> buildSpillTypes() {
        ArrayList<Type> types = new ArrayList<Type>(this.groupByOutputTypes);
        for (GroupedAggregator groupedAggregator : this.groupedAggregators) {
        }
        return types;
    }

    public int getCapacity() {
        return this.groupByHash.getCapacity();
    }

    private TsBlock buildResult(Iterator<Integer> groupIds) {
        this.pageBuilder.reset();
        while (!this.pageBuilder.isFull() && groupIds.hasNext()) {
            int groupId = groupIds.next();
            this.groupByHash.appendValuesTo(groupId, this.pageBuilder);
            this.pageBuilder.declarePosition();
            for (int i = 0; i < this.groupedAggregators.size(); ++i) {
                GroupedAggregator groupedAggregator = this.groupedAggregators.get(i);
                ColumnBuilder output = this.pageBuilder.getColumnBuilder(this.groupByChannels.length + i);
                groupedAggregator.evaluate(groupId, output);
            }
        }
        return TsBlock.wrapBlocksWithoutCopy((int)this.pageBuilder.getPositionCount(), (Column)new RunLengthEncodedColumn((Column)TableScanOperator.TIME_COLUMN_TEMPLATE, this.pageBuilder.getPositionCount()), (Column[])((Column[])Arrays.stream(this.pageBuilder.getValueColumnBuilders()).map(ColumnBuilder::build).toArray(Column[]::new)));
    }

    public List<TSDataType> buildTypes() {
        return Stream.concat(this.groupByOutputTypes.stream().map(InternalTypeManager::getTSDataType), this.groupedAggregators.stream().map(GroupedAggregator::getType)).collect(Collectors.toList());
    }

    private Iterator<Integer> consecutiveGroupIds() {
        if (this.groupIds == null) {
            this.groupIds = IntStream.range(0, this.groupByHash.getGroupCount()).iterator();
        }
        return this.groupIds;
    }
}

