/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tablet;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.exception.auth.AccessDeniedException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.resource.ref.PipePhantomReferenceManager;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.event.ReferenceTrackableEvent;
import org.apache.iotdb.db.pipe.event.common.PipeInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.parser.TabletInsertionEventParser;
import org.apache.iotdb.db.pipe.event.common.tablet.parser.TabletInsertionEventTablePatternParser;
import org.apache.iotdb.db.pipe.event.common.tablet.parser.TabletInsertionEventTreePatternParser;
import org.apache.iotdb.db.pipe.metric.overview.PipeDataNodeSinglePipeMetrics;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.InsertNodeMemoryEstimator;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryWeightUtil;
import org.apache.iotdb.db.pipe.resource.memory.PipeTabletMemoryBlock;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalInsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalInsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalInsertTabletNode;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.storageengine.dataregion.memtable.DeviceIDFactory;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.WALPipeException;
import org.apache.iotdb.pipe.api.access.Row;
import org.apache.iotdb.pipe.api.collector.RowCollector;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.tsfile.utils.Accountable;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeInsertNodeTabletInsertionEvent
extends PipeInsertionEvent
implements TabletInsertionEvent,
ReferenceTrackableEvent,
Accountable,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeInsertNodeTabletInsertionEvent.class);
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(PipeInsertNodeTabletInsertionEvent.class) + RamUsageEstimator.shallowSizeOfInstance(AtomicInteger.class) + RamUsageEstimator.shallowSizeOfInstance(AtomicBoolean.class) + RamUsageEstimator.shallowSizeOf(Boolean.class);
    private final AtomicReference<PipeTabletMemoryBlock> allocatedMemoryBlock;
    private volatile List<Tablet> tablets;
    private List<TabletInsertionEventParser> eventParsers;
    private InsertNode insertNode;
    private ProgressIndex progressIndex;
    private long bytes = Long.MIN_VALUE;
    private long extractTime = 0L;

    public PipeInsertNodeTabletInsertionEvent(Boolean isTableModel, String databaseNameFromDataRegion, InsertNode insertNode) {
        this(isTableModel, databaseNameFromDataRegion, insertNode, null, 0L, null, null, null, null, true, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    private PipeInsertNodeTabletInsertionEvent(Boolean isTableModelEvent, String databaseNameFromDataRegion, InsertNode insertNode, String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, TreePattern treePattern, TablePattern tablePattern, String userName, boolean skipIfNoPrivileges, long startTime, long endTime) {
        super(pipeName, creationTime, pipeTaskMeta, treePattern, tablePattern, userName, skipIfNoPrivileges, startTime, endTime, isTableModelEvent, databaseNameFromDataRegion);
        this.insertNode = insertNode;
        this.progressIndex = insertNode.getProgressIndex();
        this.allocatedMemoryBlock = new AtomicReference();
    }

    public InsertNode getInsertNode() {
        return this.insertNode;
    }

    public ByteBuffer getByteBuffer() throws WALPipeException {
        return this.insertNode.serializeToByteBuffer();
    }

    public String getDeviceId() {
        if (Objects.isNull(this.insertNode)) {
            return null;
        }
        return Objects.nonNull(this.insertNode.getTargetPath()) ? this.insertNode.getTargetPath().getFullPath() : null;
    }

    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        this.extractTime = System.nanoTime();
        try {
            if (Objects.nonNull(this.pipeName)) {
                PipeDataNodeSinglePipeMetrics.getInstance().increaseInsertNodeEventCount(this.pipeName, this.creationTime);
                PipeDataNodeAgent.task().addFloatingMemoryUsageInByte(this.pipeName, this.creationTime, this.ramBytesUsed());
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Increase reference count error. Holder Message: %s", holderMessage), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        boolean bl;
        try {
            if (this.eventParsers != null) {
                this.eventParsers.clear();
                this.eventParsers = null;
            }
            this.close();
            bl = true;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                LOGGER.warn(String.format("Decrease reference count error. Holder Message: %s", holderMessage), (Throwable)e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                if (Objects.nonNull(this.pipeName)) {
                    PipeDataNodeAgent.task().decreaseFloatingMemoryUsageInByte(this.pipeName, this.creationTime, this.ramBytesUsed());
                    PipeDataNodeSinglePipeMetrics.getInstance().decreaseInsertNodeEventCount(this.pipeName, this.creationTime, this.shouldReportOnCommit ? System.nanoTime() - this.extractTime : -1L);
                }
                this.insertNode = null;
                throw throwable;
            }
            if (Objects.nonNull(this.pipeName)) {
                PipeDataNodeAgent.task().decreaseFloatingMemoryUsageInByte(this.pipeName, this.creationTime, this.ramBytesUsed());
                PipeDataNodeSinglePipeMetrics.getInstance().decreaseInsertNodeEventCount(this.pipeName, this.creationTime, this.shouldReportOnCommit ? System.nanoTime() - this.extractTime : -1L);
            }
            this.insertNode = null;
            return bl2;
        }
        if (Objects.nonNull(this.pipeName)) {
            PipeDataNodeAgent.task().decreaseFloatingMemoryUsageInByte(this.pipeName, this.creationTime, this.ramBytesUsed());
            PipeDataNodeSinglePipeMetrics.getInstance().decreaseInsertNodeEventCount(this.pipeName, this.creationTime, this.shouldReportOnCommit ? System.nanoTime() - this.extractTime : -1L);
        }
        this.insertNode = null;
        return bl;
    }

    public void bindProgressIndex(ProgressIndex progressIndex) {
        this.progressIndex = progressIndex;
    }

    public ProgressIndex getProgressIndex() {
        return this.progressIndex == null ? MinimumProgressIndex.INSTANCE : this.progressIndex;
    }

    public PipeInsertNodeTabletInsertionEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, TreePattern treePattern, TablePattern tablePattern, String userName, boolean skipIfNoPrivileges, long startTime, long endTime) {
        return new PipeInsertNodeTabletInsertionEvent(this.getRawIsTableModelEvent(), this.getSourceDatabaseNameFromDataRegion(), this.insertNode, pipeName, creationTime, pipeTaskMeta, treePattern, tablePattern, userName, skipIfNoPrivileges, startTime, endTime);
    }

    public boolean isGeneratedByPipe() {
        return this.insertNode.isGeneratedByPipe();
    }

    public void throwIfNoPrivilege() {
        if (this.skipIfNoPrivileges || !this.isTableModelEvent()) {
            return;
        }
        if (Objects.nonNull(this.insertNode.getTargetPath())) {
            this.checkTableName(DeviceIDFactory.getInstance().getDeviceID(this.insertNode.getTargetPath()).getTableName());
        } else if (this.insertNode instanceof InsertRowsNode) {
            for (String tableName : ((InsertRowsNode)this.insertNode).getInsertRowNodeList().stream().map(node -> DeviceIDFactory.getInstance().getDeviceID(node.getTargetPath()).getTableName()).collect(Collectors.toSet())) {
                this.checkTableName(tableName);
            }
        }
    }

    private void checkTableName(String tableName) {
        if (!Coordinator.getInstance().getAccessControl().checkCanSelectFromTable4Pipe(this.userName, new QualifiedObjectName(this.getTableModelDatabaseName(), tableName))) {
            throw new AccessDeniedException(String.format("No privilege for SELECT for user %s at table %s.%s", this.userName, this.tableModelDatabaseName, tableName));
        }
    }

    public boolean mayEventTimeOverlappedWithTimeRange() {
        try {
            InsertNode insertNode = this.getInsertNode();
            if (Objects.isNull(insertNode)) {
                return true;
            }
            if (insertNode instanceof InsertRowNode) {
                long timestamp = ((InsertRowNode)insertNode).getTime();
                return this.startTime <= timestamp && timestamp <= this.endTime;
            }
            if (insertNode instanceof InsertTabletNode) {
                long[] timestamps = ((InsertTabletNode)insertNode).getTimes();
                if (Objects.isNull(timestamps) || timestamps.length == 0) {
                    return false;
                }
                return this.startTime <= timestamps[timestamps.length - 1] && timestamps[0] <= this.endTime;
            }
            if (insertNode instanceof InsertRowsNode) {
                return ((InsertRowsNode)insertNode).getInsertRowNodeList().stream().anyMatch(insertRowNode -> {
                    long timestamp = insertRowNode.getTime();
                    return this.startTime <= timestamp && timestamp <= this.endTime;
                });
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("Exception occurred when determining the event time of PipeInsertNodeTabletInsertionEvent({}) overlaps with the time range: [{}, {}]. Returning true to ensure data integrity.", new Object[]{this, this.startTime, this.endTime, e});
            return true;
        }
    }

    public boolean mayEventPathsOverlappedWithPattern() {
        try {
            InsertNode insertNode = this.getInsertNode();
            if (Objects.isNull(insertNode)) {
                return true;
            }
            if (insertNode instanceof RelationalInsertRowNode || insertNode instanceof RelationalInsertTabletNode || insertNode instanceof RelationalInsertRowsNode) {
                return true;
            }
            if (insertNode instanceof InsertRowNode || insertNode instanceof InsertTabletNode) {
                PartialPath devicePartialPath = insertNode.getTargetPath();
                return Objects.isNull(devicePartialPath) || this.treePattern.mayOverlapWithDevice(devicePartialPath.getIDeviceIDAsFullDevice());
            }
            if (insertNode instanceof InsertRowsNode) {
                return ((InsertRowsNode)insertNode).getInsertRowNodeList().stream().anyMatch(insertRowNode -> Objects.isNull(insertRowNode.getTargetPath()) || this.treePattern.mayOverlapWithDevice(insertRowNode.getTargetPath().getIDeviceIDAsFullDevice()));
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("Exception occurred when determining the event time of PipeInsertNodeTabletInsertionEvent({}) overlaps with the time range: [{}, {}]. Returning true to ensure data integrity.", new Object[]{this, this.startTime, this.endTime, e});
            return true;
        }
    }

    public Iterable<TabletInsertionEvent> processRowByRow(BiConsumer<Row, RowCollector> consumer) {
        return this.initEventParsers().stream().map(tabletInsertionEventParser -> tabletInsertionEventParser.processRowByRow(consumer)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Iterable<TabletInsertionEvent> processTablet(BiConsumer<Tablet, RowCollector> consumer) {
        return this.initEventParsers().stream().map(tabletInsertionEventParser -> tabletInsertionEventParser.processTablet(consumer)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public boolean isAligned(int i) {
        return this.initEventParsers().get(i).isAligned();
    }

    public synchronized List<Tablet> convertToTablets() {
        if (Objects.isNull(this.tablets)) {
            this.tablets = this.initEventParsers().stream().map(TabletInsertionEventParser::convertToTablet).collect(Collectors.toList());
            this.allocatedMemoryBlock.compareAndSet(null, PipeDataNodeResourceManager.memory().forceAllocateForTabletWithRetry(this.tablets.stream().map(PipeMemoryWeightUtil::calculateTabletSizeInBytes).reduce(Long::sum).orElse(0L)));
        }
        return this.tablets;
    }

    private List<TabletInsertionEventParser> initEventParsers() {
        try {
            if (this.eventParsers != null) {
                return this.eventParsers;
            }
            this.eventParsers = new ArrayList<TabletInsertionEventParser>();
            InsertNode node = this.getInsertNode();
            switch (node.getType()) {
                case INSERT_ROW: 
                case INSERT_TABLET: {
                    this.eventParsers.add(new TabletInsertionEventTreePatternParser(this.pipeTaskMeta, this, node, this.treePattern));
                    break;
                }
                case INSERT_ROWS: {
                    for (InsertRowNode insertRowNode : ((InsertRowsNode)node).getInsertRowNodeList()) {
                        this.eventParsers.add(new TabletInsertionEventTreePatternParser(this.pipeTaskMeta, this, insertRowNode, this.treePattern));
                    }
                    break;
                }
                case RELATIONAL_INSERT_ROW: 
                case RELATIONAL_INSERT_TABLET: {
                    this.eventParsers.add(new TabletInsertionEventTablePatternParser(this.pipeTaskMeta, this, node, this.tablePattern));
                    break;
                }
                case RELATIONAL_INSERT_ROWS: {
                    for (InsertRowNode insertRowNode : ((RelationalInsertRowsNode)node).getInsertRowNodeList()) {
                        this.eventParsers.add(new TabletInsertionEventTablePatternParser(this.pipeTaskMeta, this, insertRowNode, this.tablePattern));
                    }
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException("Unsupported node type " + (Object)((Object)node.getType()));
                }
            }
            int size = this.eventParsers.size();
            if (size > 0) {
                this.eventParsers.get(size - 1).markAsNeedToReport();
            }
            return this.eventParsers;
        }
        catch (Exception e) {
            throw new PipeException("Initialize data container error.", (Throwable)e);
        }
    }

    public long count() {
        long count = 0L;
        for (Tablet covertedTablet : this.convertToTablets()) {
            count += (long)covertedTablet.getRowSize() * (long)covertedTablet.getSchemas().size();
        }
        return count;
    }

    public List<PipeRawTabletInsertionEvent> toRawTabletInsertionEvents() {
        List<PipeRawTabletInsertionEvent> events = this.initEventParsers().stream().map(container -> new PipeRawTabletInsertionEvent(this.getRawIsTableModelEvent(), this.getSourceDatabaseNameFromDataRegion(), this.getRawTableModelDataBase(), this.getRawTreeModelDataBase(), container.convertToTablet(), container.isAligned(), this.pipeName, this.creationTime, this.pipeTaskMeta, this, false)).filter(event -> !event.hasNoNeedParsingAndIsEmpty()).collect(Collectors.toList());
        int size = events.size();
        if (size > 0) {
            events.get(size - 1).markAsNeedToReport();
        }
        return events;
    }

    public String toString() {
        return String.format("PipeInsertNodeTabletInsertionEvent{progressIndex=%s, isAligned=%s, isGeneratedByPipe=%s, eventParsers=%s}", this.progressIndex, Objects.nonNull(this.insertNode) ? Boolean.valueOf(this.insertNode.isAligned()) : null, Objects.nonNull(this.insertNode) ? Boolean.valueOf(this.insertNode.isGeneratedByPipe()) : null, this.eventParsers) + " - " + super.toString();
    }

    public String coreReportMessage() {
        return String.format("PipeInsertNodeTabletInsertionEvent{progressIndex=%s, isAligned=%s, isGeneratedByPipe=%s}", this.progressIndex, Objects.nonNull(this.insertNode) ? Boolean.valueOf(this.insertNode.isAligned()) : null, Objects.nonNull(this.insertNode) ? Boolean.valueOf(this.insertNode.isGeneratedByPipe()) : null) + " - " + super.coreReportMessage();
    }

    protected void trackResource() {
        PipeDataNodeResourceManager.ref().trackPipeEventResource((EnrichedEvent)this, this.eventResourceBuilder());
    }

    @Override
    public PipePhantomReferenceManager.PipeEventResource eventResourceBuilder() {
        return new PipeInsertNodeTabletInsertionEventResource(this.isReleased, this.referenceCount, this.allocatedMemoryBlock);
    }

    public long ramBytesUsed() {
        return this.bytes > 0L ? this.bytes : (this.bytes = INSTANCE_SIZE + (Objects.nonNull(this.insertNode) ? InsertNodeMemoryEstimator.sizeOf(this.insertNode) : 0L) + (Objects.nonNull(this.progressIndex) ? this.progressIndex.ramBytesUsed() : 0L));
    }

    @Override
    public synchronized void close() {
        this.allocatedMemoryBlock.getAndUpdate(memoryBlock -> {
            if (Objects.nonNull(memoryBlock)) {
                memoryBlock.close();
            }
            return null;
        });
        this.tablets = null;
    }

    private static class PipeInsertNodeTabletInsertionEventResource
    extends PipePhantomReferenceManager.PipeEventResource {
        private final AtomicReference<PipeTabletMemoryBlock> allocatedMemoryBlock;

        private PipeInsertNodeTabletInsertionEventResource(AtomicBoolean isReleased, AtomicInteger referenceCount, AtomicReference<PipeTabletMemoryBlock> allocatedMemoryBlock) {
            super(isReleased, referenceCount);
            this.allocatedMemoryBlock = allocatedMemoryBlock;
        }

        protected void finalizeResource() {
            try {
                this.allocatedMemoryBlock.getAndUpdate(memoryBlock -> {
                    if (Objects.nonNull(memoryBlock)) {
                        memoryBlock.close();
                    }
                    return null;
                });
            }
            catch (Exception e) {
                LOGGER.warn("Decrease reference count error.", (Throwable)e);
            }
        }
    }
}

