/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.input;

import java.io.IOException;
import java.util.Optional;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.api.YieldableState;
import org.apache.iotdb.db.utils.CommonUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.BinaryColumn;
import org.apache.tsfile.read.common.block.column.BooleanColumn;
import org.apache.tsfile.read.common.block.column.DoubleColumn;
import org.apache.tsfile.read.common.block.column.FloatColumn;
import org.apache.tsfile.read.common.block.column.IntColumn;
import org.apache.tsfile.read.common.block.column.LongColumn;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.Binary;

public class ConstantInputReader
implements LayerReader {
    private final TSDataType dataType;
    private final Column[] cachedColumns;

    public ConstantInputReader(ConstantOperand expression) throws QueryProcessException {
        if (expression == null) {
            throw new QueryProcessException("The expression cannot be null");
        }
        Object value = CommonUtils.parseValue(expression.getDataType(), expression.getValueString());
        if (value == null) {
            throw new QueryProcessException("Invalid constant operand: " + expression.getExpressionString());
        }
        this.dataType = expression.getDataType();
        this.cachedColumns = new Column[1];
        int count = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockLineNumber();
        switch (this.dataType) {
            case INT32: {
                int[] intArray = new int[]{(Integer)value};
                IntColumn intColumn = new IntColumn(1, Optional.empty(), intArray);
                this.cachedColumns[0] = new RunLengthEncodedColumn((Column)intColumn, count);
                break;
            }
            case INT64: {
                long[] longArray = new long[]{(Long)value};
                LongColumn longColumn = new LongColumn(1, Optional.empty(), longArray);
                this.cachedColumns[0] = new RunLengthEncodedColumn((Column)longColumn, count);
                break;
            }
            case FLOAT: {
                float[] floatArray = new float[]{((Float)value).floatValue()};
                FloatColumn floatColumn = new FloatColumn(1, Optional.empty(), floatArray);
                this.cachedColumns[0] = new RunLengthEncodedColumn((Column)floatColumn, count);
                break;
            }
            case DOUBLE: {
                double[] doubleArray = new double[]{(Double)value};
                DoubleColumn doubleColumn = new DoubleColumn(1, Optional.empty(), doubleArray);
                this.cachedColumns[0] = new RunLengthEncodedColumn((Column)doubleColumn, count);
                break;
            }
            case TEXT: {
                Binary[] binaryArray = new Binary[]{(Binary)value};
                BinaryColumn binaryColumn = new BinaryColumn(1, Optional.empty(), binaryArray);
                this.cachedColumns[0] = new RunLengthEncodedColumn((Column)binaryColumn, count);
                break;
            }
            case BOOLEAN: {
                boolean[] booleanArray = new boolean[]{(Boolean)value};
                BooleanColumn booleanColumn = new BooleanColumn(1, Optional.empty(), booleanArray);
                this.cachedColumns[0] = new RunLengthEncodedColumn((Column)booleanColumn, count);
                break;
            }
            default: {
                throw new QueryProcessException("Unsupported type: " + expression.getDataType());
            }
        }
    }

    @Override
    public boolean isConstantPointReader() {
        return true;
    }

    @Override
    public void consumedAll() {
    }

    @Override
    public Column[] current() throws IOException {
        return this.cachedColumns;
    }

    @Override
    public YieldableState yield() {
        return YieldableState.YIELDABLE;
    }

    @Override
    public TSDataType[] getDataTypes() {
        return new TSDataType[]{this.dataType};
    }
}

