/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot;

import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.consensus.iot.IoTConsensusServerImpl;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class IoTConsensusServerMetrics
implements IMetricSet {
    private final IoTConsensusServerImpl impl;
    private Timer getStateMachineLockTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer checkingBeforeWriteTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer writeStateMachineTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer offerRequestToQueueTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer consensusWriteTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String IOT_RECEIVE_LOG = Metric.IOT_RECEIVE_LOG.toString();
    private Timer deserializeTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer sortTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer applyTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String DESERIALIZE = "deserialize";
    private static final String SORT = "sort";
    private static final String APPLY = "apply";
    private static final String IMPL = "ioTConsensusServerImpl";

    public IoTConsensusServerMetrics(IoTConsensusServerImpl impl) {
        this.impl = impl;
    }

    public void recordDeserializeCost(long costTimeInNanos) {
        this.deserializeTimer.updateNanos(costTimeInNanos);
    }

    public void recordSortCost(long costTimeInNanos) {
        this.sortTimer.updateNanos(costTimeInNanos);
    }

    public void recordApplyCost(long costTimeInNanos) {
        this.applyTimer.updateNanos(costTimeInNanos);
    }

    public void bindTo(AbstractMetricService metricService) {
        this.bindAutoGauge(metricService);
        this.bindStageTimer(metricService);
        this.bindSyncLogTimer(metricService);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.unbindAutoGauge(metricService);
        this.unbindStageTimer(metricService);
        this.unbindSyncLogTimer(metricService);
    }

    private void bindAutoGauge(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.IOT_CONSENSUS.toString(), MetricLevel.IMPORTANT, (Object)this.impl, IoTConsensusServerImpl::getSearchIndex, new String[]{Tag.NAME.toString(), IMPL, Tag.REGION.toString(), this.impl.getThisNode().getGroupId().toString(), Tag.TYPE.toString(), "searchIndex"});
        metricService.createAutoGauge(Metric.IOT_CONSENSUS.toString(), MetricLevel.IMPORTANT, (Object)this.impl, IoTConsensusServerImpl::getMinSyncIndex, new String[]{Tag.NAME.toString(), IMPL, Tag.REGION.toString(), this.impl.getThisNode().getGroupId().toString(), Tag.TYPE.toString(), "safeIndex"});
        metricService.createAutoGauge(Metric.IOT_CONSENSUS.toString(), MetricLevel.IMPORTANT, (Object)this.impl, IoTConsensusServerImpl::getSyncLag, new String[]{Tag.NAME.toString(), IMPL, Tag.REGION.toString(), this.impl.getThisNode().getGroupId().toString(), Tag.TYPE.toString(), "syncLag"});
        metricService.createAutoGauge(Metric.IOT_CONSENSUS.toString(), MetricLevel.IMPORTANT, (Object)this.impl, IoTConsensusServerImpl::getLogEntriesFromWAL, new String[]{Tag.NAME.toString(), IMPL, Tag.REGION.toString(), this.impl.getThisNode().getGroupId().toString(), Tag.TYPE.toString(), "LogEntriesFromWAL"});
        metricService.createAutoGauge(Metric.IOT_CONSENSUS.toString(), MetricLevel.IMPORTANT, (Object)this.impl, IoTConsensusServerImpl::getLogEntriesFromQueue, new String[]{Tag.NAME.toString(), IMPL, Tag.REGION.toString(), this.impl.getThisNode().getGroupId().toString(), Tag.TYPE.toString(), "LogEntriesFromQueue"});
    }

    private void bindStageTimer(AbstractMetricService metricService) {
        this.getStateMachineLockTimer = metricService.getOrCreateTimer(Metric.STAGE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "getStateMachineLock", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
        this.checkingBeforeWriteTimer = metricService.getOrCreateTimer(Metric.STAGE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "checkingBeforeWrite", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
        this.writeStateMachineTimer = metricService.getOrCreateTimer(Metric.STAGE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "writeStateMachine", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
        this.offerRequestToQueueTimer = metricService.getOrCreateTimer(Metric.STAGE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "offerRequestToQueue", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
        this.consensusWriteTimer = metricService.getOrCreateTimer(Metric.STAGE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "consensusWrite", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
    }

    private void bindSyncLogTimer(AbstractMetricService metricService) {
        this.deserializeTimer = metricService.getOrCreateTimer(IOT_RECEIVE_LOG, MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), DESERIALIZE, Tag.REGION.toString(), this.impl.getConsensusGroupId()});
        this.sortTimer = metricService.getOrCreateTimer(IOT_RECEIVE_LOG, MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), SORT, Tag.REGION.toString(), this.impl.getConsensusGroupId()});
        this.applyTimer = metricService.getOrCreateTimer(IOT_RECEIVE_LOG, MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), APPLY, Tag.REGION.toString(), this.impl.getConsensusGroupId()});
    }

    private void unbindAutoGauge(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.IOT_CONSENSUS.toString(), new String[]{Tag.NAME.toString(), IMPL, Tag.REGION.toString(), this.impl.getThisNode().getGroupId().toString(), Tag.TYPE.toString(), "searchIndex"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.IOT_CONSENSUS.toString(), new String[]{Tag.NAME.toString(), IMPL, Tag.REGION.toString(), this.impl.getThisNode().getGroupId().toString(), Tag.TYPE.toString(), "safeIndex"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.IOT_CONSENSUS.toString(), new String[]{Tag.NAME.toString(), IMPL, Tag.REGION.toString(), this.impl.getThisNode().getGroupId().toString(), Tag.TYPE.toString(), "syncLag"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.IOT_CONSENSUS.toString(), new String[]{Tag.NAME.toString(), IMPL, Tag.REGION.toString(), this.impl.getThisNode().getGroupId().toString(), Tag.TYPE.toString(), "LogEntriesFromWAL"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.IOT_CONSENSUS.toString(), new String[]{Tag.NAME.toString(), IMPL, Tag.REGION.toString(), this.impl.getThisNode().getGroupId().toString(), Tag.TYPE.toString(), "LogEntriesFromQueue"});
    }

    private void unbindStageTimer(AbstractMetricService metricService) {
        this.getStateMachineLockTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.checkingBeforeWriteTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.writeStateMachineTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.offerRequestToQueueTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.consensusWriteTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        metricService.remove(MetricType.TIMER, Metric.STAGE.toString(), new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "getStateMachineLock", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
        metricService.remove(MetricType.TIMER, Metric.STAGE.toString(), new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "checkingBeforeWrite", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
        metricService.remove(MetricType.TIMER, Metric.STAGE.toString(), new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "writeStateMachine", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
        metricService.remove(MetricType.TIMER, Metric.STAGE.toString(), new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "offerRequestToQueue", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
        metricService.remove(MetricType.TIMER, Metric.STAGE.toString(), new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "consensusWrite", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
    }

    private void unbindSyncLogTimer(AbstractMetricService metricService) {
        metricService.remove(MetricType.TIMER, IOT_RECEIVE_LOG, new String[]{Tag.STAGE.toString(), DESERIALIZE, Tag.REGION.toString(), this.impl.getConsensusGroupId()});
        metricService.remove(MetricType.TIMER, IOT_RECEIVE_LOG, new String[]{Tag.STAGE.toString(), SORT, Tag.REGION.toString(), this.impl.getConsensusGroupId()});
        metricService.remove(MetricType.TIMER, IOT_RECEIVE_LOG, new String[]{Tag.STAGE.toString(), APPLY, Tag.REGION.toString(), this.impl.getConsensusGroupId()});
    }

    public void recordGetStateMachineLockTime(long costTimeInNanos) {
        this.getStateMachineLockTimer.updateNanos(costTimeInNanos);
    }

    public void recordCheckingBeforeWriteTime(long costTimeInNanos) {
        this.checkingBeforeWriteTimer.updateNanos(costTimeInNanos);
    }

    public void recordWriteStateMachineTime(long costTimeInNanos) {
        this.writeStateMachineTimer.updateNanos(costTimeInNanos);
    }

    public void recordOfferRequestToQueueTime(long costTimeInNanos) {
        this.offerRequestToQueueTimer.updateNanos(costTimeInNanos);
    }

    public void recordConsensusWriteTime(long costTimeInNanos) {
        this.consensusWriteTimer.updateNanos(costTimeInNanos);
    }
}

