/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class QueryDataSet
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=577");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=579");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=578");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15202");
    private final ExpandedNodeId nodeId;
    private final ExpandedNodeId typeDefinitionNode;
    private final Variant[] values;

    public QueryDataSet(ExpandedNodeId nodeId, ExpandedNodeId typeDefinitionNode, Variant[] values) {
        this.nodeId = nodeId;
        this.typeDefinitionNode = typeDefinitionNode;
        this.values = values;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public ExpandedNodeId getNodeId() {
        return this.nodeId;
    }

    public ExpandedNodeId getTypeDefinitionNode() {
        return this.typeDefinitionNode;
    }

    public Variant[] getValues() {
        return this.values;
    }

    protected QueryDataSet(QueryDataSetBuilder<?, ?> b) {
        super(b);
        this.nodeId = ((QueryDataSetBuilder)b).nodeId;
        this.typeDefinitionNode = ((QueryDataSetBuilder)b).typeDefinitionNode;
        this.values = ((QueryDataSetBuilder)b).values;
    }

    public static QueryDataSetBuilder<?, ?> builder() {
        return new QueryDataSetBuilderImpl();
    }

    public QueryDataSetBuilder<?, ?> toBuilder() {
        return new QueryDataSetBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryDataSet)) {
            return false;
        }
        QueryDataSet other = (QueryDataSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExpandedNodeId this$nodeId = this.getNodeId();
        ExpandedNodeId other$nodeId = other.getNodeId();
        if (this$nodeId == null ? other$nodeId != null : !((Object)this$nodeId).equals(other$nodeId)) {
            return false;
        }
        ExpandedNodeId this$typeDefinitionNode = this.getTypeDefinitionNode();
        ExpandedNodeId other$typeDefinitionNode = other.getTypeDefinitionNode();
        if (this$typeDefinitionNode == null ? other$typeDefinitionNode != null : !((Object)this$typeDefinitionNode).equals(other$typeDefinitionNode)) {
            return false;
        }
        return Arrays.deepEquals(this.getValues(), other.getValues());
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryDataSet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExpandedNodeId $nodeId = this.getNodeId();
        result = result * 59 + ($nodeId == null ? 43 : ((Object)$nodeId).hashCode());
        ExpandedNodeId $typeDefinitionNode = this.getTypeDefinitionNode();
        result = result * 59 + ($typeDefinitionNode == null ? 43 : ((Object)$typeDefinitionNode).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getValues());
        return result;
    }

    @Override
    public String toString() {
        return "QueryDataSet(nodeId=" + this.getNodeId() + ", typeDefinitionNode=" + this.getTypeDefinitionNode() + ", values=" + Arrays.deepToString(this.getValues()) + ")";
    }

    private static final class QueryDataSetBuilderImpl
    extends QueryDataSetBuilder<QueryDataSet, QueryDataSetBuilderImpl> {
        private QueryDataSetBuilderImpl() {
        }

        @Override
        protected QueryDataSetBuilderImpl self() {
            return this;
        }

        @Override
        public QueryDataSet build() {
            return new QueryDataSet(this);
        }
    }

    public static abstract class QueryDataSetBuilder<C extends QueryDataSet, B extends QueryDataSetBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ExpandedNodeId nodeId;
        private ExpandedNodeId typeDefinitionNode;
        private Variant[] values;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            QueryDataSetBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(QueryDataSet instance, QueryDataSetBuilder<?, ?> b) {
            b.nodeId(instance.nodeId);
            b.typeDefinitionNode(instance.typeDefinitionNode);
            b.values(instance.values);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B nodeId(ExpandedNodeId nodeId) {
            this.nodeId = nodeId;
            return (B)this.self();
        }

        public B typeDefinitionNode(ExpandedNodeId typeDefinitionNode) {
            this.typeDefinitionNode = typeDefinitionNode;
            return (B)this.self();
        }

        public B values(Variant[] values) {
            this.values = values;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "QueryDataSet.QueryDataSetBuilder(super=" + super.toString() + ", nodeId=" + this.nodeId + ", typeDefinitionNode=" + this.typeDefinitionNode + ", values=" + Arrays.deepToString(this.values) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<QueryDataSet> {
        @Override
        public Class<QueryDataSet> getType() {
            return QueryDataSet.class;
        }

        @Override
        public QueryDataSet decode(SerializationContext context, UaDecoder decoder) {
            ExpandedNodeId nodeId = decoder.readExpandedNodeId("NodeId");
            ExpandedNodeId typeDefinitionNode = decoder.readExpandedNodeId("TypeDefinitionNode");
            Variant[] values = decoder.readVariantArray("Values");
            return new QueryDataSet(nodeId, typeDefinitionNode, values);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, QueryDataSet value) {
            encoder.writeExpandedNodeId("NodeId", value.getNodeId());
            encoder.writeExpandedNodeId("TypeDefinitionNode", value.getTypeDefinitionNode());
            encoder.writeVariantArray("Values", value.getValues());
        }
    }
}

