/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.memory;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.storageengine.load.memory.LoadTsFileAbstractMemoryBlock;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTsFileMemoryBlock
extends LoadTsFileAbstractMemoryBlock {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadTsFileMemoryBlock.class);
    private final long totalMemorySizeInBytes;
    private final AtomicLong memoryUsageInBytes;

    LoadTsFileMemoryBlock(long totalMemorySizeInBytes) {
        this.totalMemorySizeInBytes = totalMemorySizeInBytes;
        this.memoryUsageInBytes = new AtomicLong(0L);
    }

    @Override
    public synchronized boolean hasEnoughMemory(long memoryTobeAddedInBytes) {
        return this.memoryUsageInBytes.get() + memoryTobeAddedInBytes <= this.totalMemorySizeInBytes;
    }

    @Override
    public synchronized void addMemoryUsage(long memoryInBytes) {
        if (this.memoryUsageInBytes.addAndGet(memoryInBytes) > this.totalMemorySizeInBytes) {
            LOGGER.debug("{} has exceed total memory size", (Object)this);
        }
        MetricService.getInstance().getOrCreateGauge(Metric.LOAD_MEM.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "LoadTsFileOtherMemory"}).incr(memoryInBytes);
    }

    @Override
    public synchronized void reduceMemoryUsage(long memoryInBytes) {
        if (this.memoryUsageInBytes.addAndGet(-memoryInBytes) < 0L) {
            LOGGER.warn("{} has reduce memory usage to negative", (Object)this);
        }
        MetricService.getInstance().getOrCreateGauge(Metric.LOAD_MEM.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "LoadTsFileOtherMemory"}).decr(memoryInBytes);
    }

    @Override
    protected synchronized void releaseAllMemory() {
        if (this.memoryUsageInBytes.get() != 0L) {
            LOGGER.warn("Try to release memory from a memory block {} which has not released all memory", (Object)this);
        }
        MEMORY_MANAGER.releaseToQuery(this.totalMemorySizeInBytes);
    }

    public String toString() {
        return "LoadTsFileMemoryBlock{totalMemorySizeInBytes=" + this.totalMemorySizeInBytes + ", memoryUsageInBytes=" + this.memoryUsageInBytes.get() + '}';
    }
}

