/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.ClusteringType;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLPartitionBy;
import com.alibaba.druid.sql.ast.SQLPartitionOf;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropCheck;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropColumnItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropForeignKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRename;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRenameColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLColumnConstraint;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLColumnPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLCommentStatement;
import com.alibaba.druid.sql.ast.statement.SQLConstraint;
import com.alibaba.druid.sql.ast.statement.SQLCreateStatement;
import com.alibaba.druid.sql.ast.statement.SQLDDLStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLExternalRecordFormat;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyConstraint;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.ast.statement.SQLUnique;
import com.alibaba.druid.sql.ast.statement.SQLUniqueConstraint;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlKey;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlPrimaryKey;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlUnique;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlTableIndex;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateSynonymStatement;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.FnvHash;
import com.alibaba.druid.util.ListDG;
import com.alibaba.druid.util.lang.Consumer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class SQLCreateTableStatement
extends SQLStatementImpl
implements SQLDDLStatement,
SQLCreateStatement {
    protected int features;
    protected SQLExprTableSource tableSource;
    protected List<SQLTableElement> tableElementList = new ArrayList<SQLTableElement>();
    protected SQLExprTableSource inherits;
    protected SQLSelect select;
    protected SQLExpr comment;
    protected SQLExprTableSource like;
    protected Boolean compress;
    protected Boolean logging;
    protected SQLName tablespace;
    protected SQLPartitionBy partitionBy;
    protected SQLPartitionOf partitionOf;
    protected SQLPartitionBy localPartitioning;
    protected SQLUnique unique;
    protected SQLExpr storedAs;
    protected SQLExpr storedBy;
    protected SQLExpr location;
    protected boolean onCommitPreserveRows;
    protected boolean onCommitDeleteRows;
    protected SQLExternalRecordFormat rowFormat;
    protected final List<SQLColumnDefinition> partitionColumns = new ArrayList<SQLColumnDefinition>(2);
    protected ClusteringType clusteringType;
    protected final List<SQLSelectOrderByItem> clusteredBy = new ArrayList<SQLSelectOrderByItem>();
    protected final List<SQLSelectOrderByItem> sortedBy = new ArrayList<SQLSelectOrderByItem>();
    protected boolean isAutoBucket = false;
    protected int buckets;
    protected int shards;
    protected final List<SQLAssignItem> tableOptions = new ArrayList<SQLAssignItem>();
    protected boolean replace;
    protected boolean ignore;
    protected boolean single;
    protected SQLExpr lifeCycle;

    public SQLCreateTableStatement() {
    }

    public SQLCreateTableStatement(DbType dbType) {
        super(dbType);
    }

    @Override
    protected void accept0(SQLASTVisitor v) {
        if (v.visit(this)) {
            this.acceptChild(v);
        }
        v.endVisit(this);
    }

    protected void acceptChild(SQLASTVisitor v) {
        this.acceptChild(v, this.tableSource);
        this.acceptChild(v, this.tableElementList);
        this.acceptChild(v, this.inherits);
        this.acceptChild(v, this.select);
        this.acceptChild(v, this.comment);
        this.acceptChild(v, this.like);
        this.acceptChild(v, this.tablespace);
        this.acceptChild(v, this.partitionBy);
        this.acceptChild(v, this.localPartitioning);
        this.acceptChild(v, this.storedAs);
        this.acceptChild(v, this.storedBy);
        this.acceptChild(v, this.location);
        this.acceptChild(v, this.unique);
        this.acceptChild(v, this.partitionColumns);
        this.acceptChild(v, this.clusteredBy);
        this.acceptChild(v, this.sortedBy);
        this.acceptChild(v, this.tableOptions);
        this.acceptChild(v, this.lifeCycle);
    }

    public boolean isAutoBucket() {
        return this.isAutoBucket;
    }

    public void setAutoBucket(boolean autoBucket) {
        this.isAutoBucket = autoBucket;
    }

    public SQLExpr getComment() {
        return this.comment;
    }

    public void setComment(SQLExpr comment) {
        if (comment != null) {
            comment.setParent(this);
        }
        this.comment = comment;
    }

    @Override
    public SQLName getName() {
        if (this.tableSource == null) {
            return null;
        }
        return (SQLName)this.tableSource.getExpr();
    }

    public String getTableName() {
        SQLName name = this.getName();
        if (name == null) {
            return null;
        }
        return name.getSimpleName();
    }

    public String getSchema() {
        SQLName name = this.getName();
        if (name == null) {
            return null;
        }
        if (name instanceof SQLPropertyExpr) {
            return ((SQLPropertyExpr)name).getOwnernName();
        }
        return null;
    }

    public void setSchema(String name) {
        if (this.tableSource == null) {
            return;
        }
        this.tableSource.setSchema(name);
    }

    public void setName(SQLName name) {
        this.setTableSource(new SQLExprTableSource(name));
    }

    public void setName(String name) {
        this.setName(new SQLIdentifierExpr(name));
    }

    public SQLExprTableSource getTableSource() {
        return this.tableSource;
    }

    public void setTableSource(SQLExprTableSource tableSource) {
        if (tableSource != null) {
            tableSource.setParent(this);
        }
        this.tableSource = tableSource;
    }

    public void setTableName(String tableName) {
        SQLExpr name = SQLUtils.toSQLExpr(tableName, this.dbType);
        this.setTableSource(new SQLExprTableSource(name));
    }

    public void config(Feature feature) {
        this.config(feature, true);
    }

    public boolean isEnabled(Feature feature) {
        return feature.isEnabled(this.features);
    }

    public void config(Feature feature, boolean state) {
        this.features = feature.config(this.features, state);
    }

    public boolean isTemporary() {
        return Feature.Temporary.isEnabled(this.features);
    }

    public void setTemporary(boolean value) {
        this.features = Feature.Temporary.config(this.features, value);
    }

    public List<SQLTableElement> getTableElementList() {
        return this.tableElementList;
    }

    public SQLColumnDefinition getColumn(String columnName) {
        long hashCode64 = FnvHash.hashCode64(columnName);
        for (SQLTableElement e : this.tableElementList) {
            SQLColumnDefinition column;
            if (!(e instanceof SQLColumnDefinition) || (column = (SQLColumnDefinition)e).nameHashCode64() != hashCode64) continue;
            return column;
        }
        return null;
    }

    public List<SQLColumnDefinition> getColumnDefinitions() {
        ArrayList<SQLColumnDefinition> column = new ArrayList<SQLColumnDefinition>();
        for (SQLTableElement element : this.tableElementList) {
            if (!(element instanceof SQLColumnDefinition)) continue;
            column.add((SQLColumnDefinition)element);
        }
        return column;
    }

    public List<String> getColumnNames(boolean normalized) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (SQLColumnDefinition definition : this.getColumnDefinitions()) {
            String columnName = definition.getColumnName();
            if (normalized) {
                columnName = SQLUtils.normalize(columnName);
            }
            columnNames.add(columnName);
        }
        return columnNames;
    }

    public List<String> getColumnComments() {
        ArrayList<String> comments = new ArrayList<String>();
        for (SQLColumnDefinition definition : this.getColumnDefinitions()) {
            comments.add(((SQLCharExpr)definition.getComment()).getText());
        }
        return comments;
    }

    public List<String> getPrimaryKeyNames() {
        ArrayList<String> keys = new ArrayList<String>();
        for (SQLTableElement element : this.tableElementList) {
            if (!(element instanceof MySqlPrimaryKey)) continue;
            List<SQLSelectOrderByItem> columns = ((MySqlPrimaryKey)element).getColumns();
            for (SQLSelectOrderByItem column : columns) {
                keys.add(SQLUtils.normalize(column.getExpr().toString()));
            }
        }
        return keys;
    }

    public void addColumn(String columnName, String dataType) {
        SQLColumnDefinition column = new SQLColumnDefinition();
        column.setName(columnName);
        column.setDataType(SQLParserUtils.createExprParser(dataType, this.dbType, new SQLParserFeature[0]).parseDataType());
        this.addColumn(column);
    }

    public void addColumn(String name, SQLDataType dataType) {
        this.addColumn(new SQLColumnDefinition(name, dataType));
    }

    public void addColumn(SQLColumnDefinition column) {
        if (column == null) {
            throw new IllegalArgumentException();
        }
        column.setParent(this);
        this.tableElementList.add(column);
    }

    public boolean isIfNotExists() {
        return Feature.IfNotExists.isEnabled(this.features);
    }

    public void setIfNotExists(boolean value) {
        this.features = Feature.IfNotExists.config(this.features, value);
    }

    public SQLExprTableSource getInherits() {
        return this.inherits;
    }

    public void setInherits(SQLExprTableSource inherits) {
        if (inherits != null) {
            inherits.setParent(this);
        }
        this.inherits = inherits;
    }

    public SQLSelect getSelect() {
        return this.select;
    }

    public void setSelect(SQLSelect select) {
        if (select != null) {
            select.setParent(this);
        }
        this.select = select;
    }

    public SQLUnique getUnique() {
        return this.unique;
    }

    public void setUnique(SQLUnique unique) {
        if (unique != null) {
            unique.setParent(this);
        }
        this.unique = unique;
    }

    public SQLExprTableSource getLike() {
        return this.like;
    }

    public void setLike(SQLName like) {
        this.setLike(new SQLExprTableSource(like));
    }

    public void setLike(SQLExprTableSource like) {
        if (like != null) {
            like.setParent(this);
        }
        this.like = like;
    }

    public Boolean getCompress() {
        return this.compress;
    }

    public void setCompress(Boolean compress) {
        this.compress = compress;
    }

    public Boolean getLogging() {
        return this.logging;
    }

    public void setLogging(Boolean logging) {
        this.logging = logging;
    }

    public SQLName getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(SQLName x) {
        if (x != null) {
            x.setParent(this);
        }
        this.tablespace = x;
    }

    public SQLPartitionBy getPartitioning() {
        return this.partitionBy;
    }

    public SQLPartitionBy getLocalPartitioning() {
        return this.localPartitioning;
    }

    public void setPartitionBy(SQLPartitionBy partitionBy) {
        if (partitionBy != null) {
            partitionBy.setParent(this);
        }
        this.partitionBy = partitionBy;
    }

    public SQLPartitionOf getPartitionOf() {
        return this.partitionOf;
    }

    public void setPartitionOf(SQLPartitionOf partitionOf) {
        if (partitionOf != null) {
            partitionOf.setParent(this);
        }
        this.partitionOf = partitionOf;
    }

    public void setLocalPartitioning(SQLPartitionBy localPartitioning) {
        if (localPartitioning != null) {
            localPartitioning.setParent(this);
        }
        this.localPartitioning = localPartitioning;
    }

    @Override
    public List<SQLObject> getChildren() {
        ArrayList<SQLObject> children = new ArrayList<SQLObject>();
        children.add(this.tableSource);
        children.addAll(this.tableElementList);
        if (this.inherits != null) {
            children.add(this.inherits);
        }
        if (this.select != null) {
            children.add(this.select);
        }
        return children;
    }

    public void addBodyBeforeComment(List<String> comments) {
        List attrComments;
        if (this.attributes == null) {
            this.attributes = new HashMap(1);
        }
        if ((attrComments = (List)this.attributes.get("rowFormat.body_before_comment")) == null) {
            this.attributes.put("rowFormat.body_before_comment", comments);
        } else {
            attrComments.addAll(comments);
        }
    }

    public List<String> getBodyBeforeCommentsDirect() {
        if (this.attributes == null) {
            return null;
        }
        return (List)this.attributes.get("rowFormat.body_before_comment");
    }

    public boolean hasBodyBeforeComment() {
        List<String> comments = this.getBodyBeforeCommentsDirect();
        if (comments == null) {
            return false;
        }
        return !comments.isEmpty();
    }

    public String computeName() {
        if (this.tableSource == null) {
            return null;
        }
        SQLExpr expr = this.tableSource.getExpr();
        if (expr instanceof SQLName) {
            String name = ((SQLName)expr).getSimpleName();
            return SQLUtils.normalize(name);
        }
        return null;
    }

    public boolean containsColumn(String columName) {
        return this.findColumn(columName) == null;
    }

    public SQLColumnDefinition findColumn(String columName) {
        if (columName == null) {
            return null;
        }
        long hash = FnvHash.hashCode64(columName);
        return this.findColumn(hash);
    }

    public SQLColumnDefinition findColumn(long columName_hash) {
        for (SQLTableElement element : this.tableElementList) {
            SQLColumnDefinition column;
            if (!(element instanceof SQLColumnDefinition) || (column = (SQLColumnDefinition)element).nameHashCode64() != columName_hash) continue;
            return column;
        }
        for (SQLColumnDefinition column : this.partitionColumns) {
            if (column.nameHashCode64() != columName_hash) continue;
            return column;
        }
        return null;
    }

    public boolean isPrimaryColumn(String columnName) {
        SQLPrimaryKey pk = this.findPrimaryKey();
        if (pk != null && pk.containsColumn(columnName)) {
            return true;
        }
        for (SQLColumnDefinition element : this.getColumnDefinitions()) {
            for (SQLColumnConstraint constraint : element.constraints) {
                if (!(constraint instanceof SQLColumnPrimaryKey) || !SQLUtils.normalize(element.getColumnName()).equalsIgnoreCase(SQLUtils.normalize(columnName))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPrimaryColumn(long columnNameHash) {
        SQLPrimaryKey pk = this.findPrimaryKey();
        if (pk == null) {
            return false;
        }
        return pk.containsColumn(columnNameHash);
    }

    public boolean isOnlyPrimaryKey(long columnNameHash) {
        SQLPrimaryKey pk = this.findPrimaryKey();
        if (pk == null) {
            return false;
        }
        return pk.containsColumn(columnNameHash) && pk.getColumns().size() == 1;
    }

    public boolean isMUL(String columnName) {
        for (SQLTableElement element : this.tableElementList) {
            SQLExpr column;
            MySqlKey unique;
            if (element instanceof MySqlUnique) {
                unique = (MySqlUnique)element;
                column = unique.getColumns().get(0).getExpr();
                if (column instanceof SQLIdentifierExpr && SQLUtils.nameEquals(columnName, ((SQLIdentifierExpr)column).getName())) {
                    return unique.getColumns().size() > 1;
                }
                if (!(column instanceof SQLMethodInvokeExpr) || !SQLUtils.nameEquals(((SQLMethodInvokeExpr)column).getMethodName(), columnName)) continue;
                return true;
            }
            if (!(element instanceof MySqlKey)) continue;
            unique = (MySqlKey)element;
            column = unique.getColumns().get(0).getExpr();
            if (column instanceof SQLIdentifierExpr && SQLUtils.nameEquals(columnName, ((SQLIdentifierExpr)column).getName())) {
                return true;
            }
            if (!(column instanceof SQLMethodInvokeExpr) || !SQLUtils.nameEquals(((SQLMethodInvokeExpr)column).getMethodName(), columnName)) continue;
            return true;
        }
        return false;
    }

    public boolean isUNI(String columnName) {
        for (SQLTableElement element : this.tableElementList) {
            MySqlUnique unique;
            if (!(element instanceof MySqlUnique) || (unique = (MySqlUnique)element).getColumns().isEmpty()) continue;
            SQLExpr column = unique.getColumns().get(0).getExpr();
            if (column instanceof SQLIdentifierExpr && SQLUtils.nameEquals(columnName, ((SQLIdentifierExpr)column).getName())) {
                return unique.getColumns().size() == 1;
            }
            if (!(column instanceof SQLMethodInvokeExpr) || !SQLUtils.nameEquals(((SQLMethodInvokeExpr)column).getMethodName(), columnName)) continue;
            return true;
        }
        return false;
    }

    public MySqlUnique findUnique(String columnName) {
        for (SQLTableElement element : this.tableElementList) {
            MySqlUnique unique;
            if (!(element instanceof MySqlUnique) || !(unique = (MySqlUnique)element).containsColumn(columnName)) continue;
            return unique;
        }
        return null;
    }

    public SQLTableElement findIndex(String columnName) {
        for (SQLTableElement element : this.tableElementList) {
            String keyColumName;
            SQLExpr columnExpr;
            if (element instanceof SQLUniqueConstraint) {
                SQLUniqueConstraint unique = (SQLUniqueConstraint)((Object)element);
                for (SQLSelectOrderByItem item : unique.getColumns()) {
                    columnExpr = item.getExpr();
                    if (!(columnExpr instanceof SQLIdentifierExpr)) continue;
                    keyColumName = ((SQLIdentifierExpr)columnExpr).getName();
                    if (!(keyColumName = SQLUtils.normalize(keyColumName)).equalsIgnoreCase(columnName)) continue;
                    return element;
                }
                continue;
            }
            if (!(element instanceof MySqlTableIndex)) continue;
            List<SQLSelectOrderByItem> indexColumns = ((MySqlTableIndex)element).getColumns();
            for (SQLSelectOrderByItem orderByItem : indexColumns) {
                columnExpr = orderByItem.getExpr();
                if (!(columnExpr instanceof SQLIdentifierExpr)) continue;
                keyColumName = ((SQLIdentifierExpr)columnExpr).getName();
                if (!(keyColumName = SQLUtils.normalize(keyColumName)).equalsIgnoreCase(columnName)) continue;
                return element;
            }
        }
        return null;
    }

    public void forEachColumn(Consumer<SQLColumnDefinition> columnConsumer) {
        if (columnConsumer == null) {
            return;
        }
        for (SQLTableElement element : this.tableElementList) {
            if (!(element instanceof SQLColumnDefinition)) continue;
            columnConsumer.accept((SQLColumnDefinition)element);
        }
    }

    public SQLPrimaryKey findPrimaryKey() {
        for (SQLTableElement element : this.tableElementList) {
            if (!(element instanceof SQLPrimaryKey)) continue;
            return (SQLPrimaryKey)element;
        }
        return null;
    }

    public List<SQLForeignKeyConstraint> findForeignKey() {
        ArrayList<SQLForeignKeyConstraint> fkList = new ArrayList<SQLForeignKeyConstraint>();
        for (SQLTableElement element : this.tableElementList) {
            if (!(element instanceof SQLForeignKeyConstraint)) continue;
            fkList.add((SQLForeignKeyConstraint)element);
        }
        return fkList;
    }

    public boolean hashForeignKey() {
        for (SQLTableElement element : this.tableElementList) {
            if (!(element instanceof SQLForeignKeyConstraint)) continue;
            return true;
        }
        return false;
    }

    public boolean isReferenced(SQLName tableName) {
        if (tableName == null) {
            return false;
        }
        return this.isReferenced(tableName.getSimpleName());
    }

    public boolean isReferenced(String tableName) {
        if (tableName == null) {
            return false;
        }
        tableName = SQLUtils.normalize(tableName);
        for (SQLTableElement element : this.tableElementList) {
            SQLForeignKeyConstraint fk;
            String refTableName;
            if (!(element instanceof SQLForeignKeyConstraint) || !SQLUtils.nameEquals(tableName, refTableName = (fk = (SQLForeignKeyConstraint)element).getReferencedTableName().getSimpleName())) continue;
            return true;
        }
        return false;
    }

    public SQLAlterTableStatement foreignKeyToAlterTable() {
        SQLAlterTableStatement stmt = new SQLAlterTableStatement();
        for (int i = this.tableElementList.size() - 1; i >= 0; --i) {
            SQLTableElement element = this.tableElementList.get(i);
            if (!(element instanceof SQLForeignKeyConstraint)) continue;
            SQLForeignKeyConstraint fk = (SQLForeignKeyConstraint)element;
            this.tableElementList.remove(i);
            stmt.addItem(new SQLAlterTableAddConstraint(fk));
        }
        if (stmt.getItems().isEmpty()) {
            return null;
        }
        stmt.setDbType(this.getDbType());
        stmt.setTableSource(this.tableSource.clone());
        Collections.reverse(stmt.getItems());
        return stmt;
    }

    /*
     * WARNING - void declaration
     */
    public static void sort(List<SQLStatement> stmtList) {
        String fromTableName;
        SQLCreateTableStatement from;
        ListDG.Edge edge;
        int i;
        HashMap<Object, SQLCreateTableStatement> tables = new HashMap<Object, SQLCreateTableStatement>();
        HashMap<String, ArrayList<SQLCreateTableStatement>> referencedTables = new HashMap<String, ArrayList<SQLCreateTableStatement>>();
        for (SQLStatement sQLStatement : stmtList) {
            if (!(sQLStatement instanceof SQLCreateTableStatement)) continue;
            SQLCreateTableStatement sQLCreateTableStatement = (SQLCreateTableStatement)sQLStatement;
            Object tableName = sQLCreateTableStatement.getName().getSimpleName();
            tableName = SQLUtils.normalize((String)tableName).toLowerCase();
            tables.put(tableName, sQLCreateTableStatement);
        }
        ArrayList<ListDG.Edge> edges = new ArrayList<ListDG.Edge>();
        for (SQLCreateTableStatement sQLCreateTableStatement : tables.values()) {
            for (SQLTableElement element : sQLCreateTableStatement.getTableElementList()) {
                ArrayList<SQLCreateTableStatement> referencedList;
                if (!(element instanceof SQLForeignKeyConstraint)) continue;
                SQLForeignKeyConstraint fk = (SQLForeignKeyConstraint)element;
                String refTableName = fk.getReferencedTableName().getSimpleName();
                SQLCreateTableStatement refTable = (SQLCreateTableStatement)tables.get(refTableName = SQLUtils.normalize(refTableName).toLowerCase());
                if (refTable != null) {
                    edges.add(new ListDG.Edge(sQLCreateTableStatement, refTable));
                }
                if ((referencedList = (ArrayList<SQLCreateTableStatement>)referencedTables.get(refTableName)) == null) {
                    referencedList = new ArrayList<SQLCreateTableStatement>();
                    referencedTables.put(refTableName, referencedList);
                }
                referencedList.add(sQLCreateTableStatement);
            }
        }
        for (SQLStatement sQLStatement : stmtList) {
            OracleCreateSynonymStatement createSynonym;
            SQLName object;
            String refTableName;
            SQLCreateTableStatement refTable;
            if (!(sQLStatement instanceof OracleCreateSynonymStatement) || (refTable = (SQLCreateTableStatement)tables.get(refTableName = (object = (createSynonym = (OracleCreateSynonymStatement)sQLStatement).getObject()).getSimpleName())) == null) continue;
            edges.add(new ListDG.Edge(sQLStatement, refTable));
        }
        ListDG listDG = new ListDG(stmtList, edges);
        Object[] objectArray = new SQLStatement[stmtList.size()];
        if (listDG.topologicalSort(objectArray)) {
            int size = stmtList.size();
            for (int i2 = 0; i2 < size; ++i2) {
                stmtList.set(i2, (SQLStatement)objectArray[size - i2 - 1]);
            }
            return;
        }
        ArrayList<SQLAlterTableStatement> alterList = new ArrayList<SQLAlterTableStatement>();
        for (i = edges.size() - 1; i >= 0; --i) {
            void var5_18;
            edge = (ListDG.Edge)edges.get(i);
            from = (SQLCreateTableStatement)edge.from;
            fromTableName = from.getName().getSimpleName();
            if (!referencedTables.containsKey(fromTableName = SQLUtils.normalize(fromTableName).toLowerCase())) continue;
            edges.remove(i);
            Arrays.fill((Object[])var5_18, null);
            Object[] objectArray2 = new SQLStatement[stmtList.size()];
            ListDG listDG2 = new ListDG(stmtList, edges);
            if (listDG2.topologicalSort(objectArray2)) {
                int size = stmtList.size();
                for (int j = 0; j < size; ++j) {
                    Object stmt = objectArray2[size - j - 1];
                    stmtList.set(j, (SQLStatement)stmt);
                }
                SQLAlterTableStatement alter = from.foreignKeyToAlterTable();
                alterList.add(alter);
                stmtList.add(alter);
                return;
            }
            edges.add(i, edge);
        }
        for (i = edges.size() - 1; i >= 0; --i) {
            void var5_20;
            edge = (ListDG.Edge)edges.get(i);
            from = (SQLCreateTableStatement)edge.from;
            fromTableName = from.getName().getSimpleName();
            if (!referencedTables.containsKey(fromTableName = SQLUtils.normalize(fromTableName).toLowerCase())) continue;
            SQLAlterTableStatement alter = from.foreignKeyToAlterTable();
            edges.remove(i);
            if (alter != null) {
                alterList.add(alter);
            }
            Arrays.fill((Object[])var5_20, null);
            Object[] objectArray3 = new SQLStatement[stmtList.size()];
            ListDG listDG3 = new ListDG(stmtList, edges);
            if (!listDG3.topologicalSort(objectArray3)) continue;
            int size = stmtList.size();
            for (int j = 0; j < size; ++j) {
                Object stmt = objectArray3[size - j - 1];
                stmtList.set(j, (SQLStatement)stmt);
            }
            stmtList.addAll(alterList);
            return;
        }
    }

    public void simplify() {
        SQLIdentifierExpr identExpr;
        String tableName;
        String normalized;
        SQLName name = this.getName();
        if (name instanceof SQLPropertyExpr) {
            String normalized2;
            String tableName2 = ((SQLPropertyExpr)name).getName();
            if ((tableName2 = SQLUtils.normalize(tableName2)) != (normalized2 = SQLUtils.normalize(tableName2, this.dbType))) {
                this.setName(normalized2);
                name = this.getName();
            }
        }
        if (name instanceof SQLIdentifierExpr && (normalized = SQLUtils.normalize(tableName = (identExpr = (SQLIdentifierExpr)name).getName(), this.dbType)) != tableName) {
            this.setName(normalized);
        }
        for (SQLTableElement element : this.tableElementList) {
            if (element instanceof SQLColumnDefinition) {
                SQLColumnDefinition column = (SQLColumnDefinition)element;
                column.simplify();
                continue;
            }
            if (!(element instanceof SQLConstraint)) continue;
            ((SQLConstraint)((Object)element)).simplify();
        }
    }

    public boolean apply(SQLDropIndexStatement x) {
        long indexNameHashCode64 = x.getIndexName().nameHashCode64();
        for (int i = this.tableElementList.size() - 1; i >= 0; --i) {
            MySqlTableIndex tableIndex;
            SQLTableElement e = this.tableElementList.get(i);
            if (e instanceof SQLUniqueConstraint) {
                SQLUniqueConstraint unique = (SQLUniqueConstraint)((Object)e);
                if (unique.getName() == null || unique.getName().nameHashCode64() != indexNameHashCode64) continue;
                this.tableElementList.remove(i);
                return true;
            }
            if (!(e instanceof MySqlTableIndex) || !SQLUtils.nameEquals((tableIndex = (MySqlTableIndex)e).getName(), x.getIndexName())) continue;
            this.tableElementList.remove(i);
            return true;
        }
        return false;
    }

    public boolean apply(SQLCommentStatement x) {
        SQLName on = x.getOn().getName();
        SQLExpr comment = x.getComment();
        if (comment == null) {
            return false;
        }
        SQLCommentStatement.Type type = x.getType();
        if (type == SQLCommentStatement.Type.TABLE) {
            if (!SQLUtils.nameEquals(this.getName(), on)) {
                return false;
            }
            this.setComment(comment.clone());
            return true;
        }
        if (type == SQLCommentStatement.Type.COLUMN) {
            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)on;
            if (!SQLUtils.nameEquals(this.getName(), (SQLName)propertyExpr.getOwner())) {
                return false;
            }
            SQLColumnDefinition column = this.findColumn(propertyExpr.nameHashCode64());
            if (column != null) {
                column.setComment(comment.clone());
            }
            return true;
        }
        return false;
    }

    public boolean apply(SQLAlterTableStatement alter) {
        if (!SQLUtils.nameEquals(alter.getName(), this.getName())) {
            return false;
        }
        int applyCount = 0;
        for (SQLAlterTableItem item : alter.getItems()) {
            if (!this.alterApply(item)) continue;
            ++applyCount;
        }
        return applyCount > 0;
    }

    protected boolean alterApply(SQLAlterTableItem item) {
        if (item instanceof SQLAlterTableDropColumnItem) {
            return this.apply((SQLAlterTableDropColumnItem)item);
        }
        if (item instanceof SQLAlterTableAddColumn) {
            return this.apply((SQLAlterTableAddColumn)item);
        }
        if (item instanceof SQLAlterTableAddConstraint) {
            return this.apply((SQLAlterTableAddConstraint)item);
        }
        if (item instanceof SQLAlterTableDropPrimaryKey) {
            return this.apply((SQLAlterTableDropPrimaryKey)item);
        }
        if (item instanceof SQLAlterTableDropIndex) {
            return this.apply((SQLAlterTableDropIndex)item);
        }
        if (item instanceof SQLAlterTableDropConstraint) {
            return this.apply((SQLAlterTableDropConstraint)item);
        }
        if (item instanceof SQLAlterTableDropCheck) {
            return this.apply((SQLAlterTableDropCheck)item);
        }
        if (item instanceof SQLAlterTableDropKey) {
            return this.apply((SQLAlterTableDropKey)item);
        }
        if (item instanceof SQLAlterTableDropForeignKey) {
            return this.apply((SQLAlterTableDropForeignKey)item);
        }
        if (item instanceof SQLAlterTableRename) {
            return this.apply((SQLAlterTableRename)item);
        }
        if (item instanceof SQLAlterTableRenameColumn) {
            return this.apply((SQLAlterTableRenameColumn)item);
        }
        if (item instanceof SQLAlterTableAddIndex) {
            return this.apply((SQLAlterTableAddIndex)item);
        }
        return false;
    }

    private boolean apply(SQLAlterTableRenameColumn item) {
        int columnIndex = this.columnIndexOf(item.getColumn());
        if (columnIndex == -1) {
            return false;
        }
        SQLColumnDefinition column = (SQLColumnDefinition)this.tableElementList.get(columnIndex);
        column.setName(item.getTo().clone());
        return true;
    }

    public boolean renameColumn(String colummName, String newColumnName) {
        if (colummName == null || newColumnName == null || newColumnName.length() == 0) {
            return false;
        }
        int columnIndex = this.columnIndexOf(new SQLIdentifierExpr(colummName));
        if (columnIndex == -1) {
            return false;
        }
        SQLColumnDefinition column = (SQLColumnDefinition)this.tableElementList.get(columnIndex);
        column.setName(new SQLIdentifierExpr(newColumnName));
        return true;
    }

    private boolean apply(SQLAlterTableRename item) {
        SQLName name = item.getToName();
        if (name == null) {
            return false;
        }
        this.setName(name.clone());
        return true;
    }

    private boolean apply(SQLAlterTableDropForeignKey item) {
        for (int i = this.tableElementList.size() - 1; i >= 0; --i) {
            SQLForeignKeyConstraint fk;
            SQLTableElement e = this.tableElementList.get(i);
            if (!(e instanceof SQLForeignKeyConstraint) || !SQLUtils.nameEquals((fk = (SQLForeignKeyConstraint)e).getName(), item.getIndexName())) continue;
            this.tableElementList.remove(i);
            return true;
        }
        return false;
    }

    private boolean apply(SQLAlterTableDropKey item) {
        for (int i = this.tableElementList.size() - 1; i >= 0; --i) {
            SQLUniqueConstraint unique;
            SQLTableElement e = this.tableElementList.get(i);
            if (!(e instanceof SQLUniqueConstraint) || !SQLUtils.nameEquals((unique = (SQLUniqueConstraint)((Object)e)).getName(), item.getKeyName())) continue;
            this.tableElementList.remove(i);
            return true;
        }
        return false;
    }

    private boolean apply(SQLAlterTableDropConstraint item) {
        for (int i = this.tableElementList.size() - 1; i >= 0; --i) {
            SQLConstraint constraint;
            SQLTableElement e = this.tableElementList.get(i);
            if (!(e instanceof SQLConstraint) || !SQLUtils.nameEquals((constraint = (SQLConstraint)((Object)e)).getName(), item.getConstraintName())) continue;
            this.tableElementList.remove(i);
            return true;
        }
        return false;
    }

    private boolean apply(SQLAlterTableDropCheck item) {
        for (int i = this.tableElementList.size() - 1; i >= 0; --i) {
            SQLConstraint constraint;
            SQLTableElement e = this.tableElementList.get(i);
            if (!(e instanceof SQLConstraint) || !SQLUtils.nameEquals((constraint = (SQLConstraint)((Object)e)).getName(), item.getCheckName())) continue;
            this.tableElementList.remove(i);
            return true;
        }
        return false;
    }

    private boolean apply(SQLAlterTableDropIndex item) {
        for (int i = this.tableElementList.size() - 1; i >= 0; --i) {
            MySqlTableIndex tableIndex;
            SQLTableElement e = this.tableElementList.get(i);
            if (e instanceof SQLUniqueConstraint) {
                SQLUniqueConstraint unique = (SQLUniqueConstraint)((Object)e);
                if (!SQLUtils.nameEquals(unique.getName(), item.getIndexName())) continue;
                this.tableElementList.remove(i);
                return true;
            }
            if (!(e instanceof MySqlTableIndex) || !SQLUtils.nameEquals((tableIndex = (MySqlTableIndex)e).getName(), item.getIndexName())) continue;
            this.tableElementList.remove(i);
            return true;
        }
        return false;
    }

    private boolean apply(SQLAlterTableDropPrimaryKey item) {
        for (int i = this.tableElementList.size() - 1; i >= 0; --i) {
            SQLTableElement e = this.tableElementList.get(i);
            if (!(e instanceof SQLPrimaryKey)) continue;
            this.tableElementList.remove(i);
            return true;
        }
        return false;
    }

    private boolean apply(SQLAlterTableAddConstraint item) {
        SQLName name = item.getConstraint().getName();
        if (name != null) {
            long nameHashCode = name.nameHashCode64();
            for (int i = this.tableElementList.size() - 1; i >= 0; --i) {
                SQLName name1;
                SQLTableElement e = this.tableElementList.get(i);
                if (!(e instanceof SQLConstraint) || (name1 = ((SQLConstraint)((Object)e)).getName()) == null || name1.nameHashCode64() != nameHashCode) continue;
                return false;
            }
        }
        this.tableElementList.add((SQLTableElement)((Object)item.getConstraint()));
        return true;
    }

    private boolean apply(SQLAlterTableDropColumnItem item) {
        for (SQLName column : item.getColumns()) {
            SQLTableElement e;
            int i;
            String columnName = column.getSimpleName();
            for (i = this.tableElementList.size() - 1; i >= 0; --i) {
                e = this.tableElementList.get(i);
                if (!(e instanceof SQLColumnDefinition) || !SQLUtils.nameEquals(columnName, ((SQLColumnDefinition)e).getName().getSimpleName())) continue;
                this.tableElementList.remove(i);
            }
            for (i = this.tableElementList.size() - 1; i >= 0; --i) {
                e = this.tableElementList.get(i);
                if (e instanceof SQLUnique) {
                    SQLUnique unique = (SQLUnique)e;
                    unique.applyDropColumn(column);
                    if (!unique.getColumns().isEmpty()) continue;
                    this.tableElementList.remove(i);
                    continue;
                }
                if (!(e instanceof MySqlTableIndex)) continue;
                MySqlTableIndex index = (MySqlTableIndex)e;
                index.applyDropColumn(column);
                if (!index.getColumns().isEmpty()) continue;
                this.tableElementList.remove(i);
            }
        }
        return true;
    }

    protected boolean apply(SQLAlterTableAddIndex item) {
        return false;
    }

    private boolean apply(SQLAlterTableAddColumn item) {
        int beforeIndex;
        int afterIndex;
        int startIndex = this.tableElementList.size();
        if (item.isFirst()) {
            startIndex = 0;
        }
        if ((afterIndex = this.columnIndexOf(item.getAfterColumn())) != -1) {
            startIndex = afterIndex + 1;
        }
        if ((beforeIndex = this.columnIndexOf(item.getFirstColumn())) != -1) {
            startIndex = beforeIndex;
        }
        for (int i = 0; i < item.getColumns().size(); ++i) {
            SQLColumnDefinition column = item.getColumns().get(i);
            int matchIndex = -1;
            for (int j = 0; j < this.tableElementList.size(); ++j) {
                SQLTableElement element = this.tableElementList.get(j);
                if (!(element instanceof SQLColumnDefinition) || column.nameHashCode64() != ((SQLColumnDefinition)element).nameHashCode64()) continue;
                matchIndex = j;
                break;
            }
            if (matchIndex != -1) {
                return false;
            }
            this.tableElementList.add(i + startIndex, column);
            column.setParent(this);
        }
        return true;
    }

    protected int columnIndexOf(SQLName column) {
        if (column == null) {
            return -1;
        }
        String columnName = column.getSimpleName();
        for (int i = this.tableElementList.size() - 1; i >= 0; --i) {
            SQLTableElement e = this.tableElementList.get(i);
            if (!(e instanceof SQLColumnDefinition) || !SQLUtils.nameEquals(columnName, ((SQLColumnDefinition)e).getName().getSimpleName())) continue;
            return i;
        }
        return -1;
    }

    public void cloneTo(SQLCreateTableStatement x) {
        SQLObject e2;
        x.features = this.features;
        if (this.tableSource != null) {
            x.setTableSource(this.tableSource.clone());
        }
        for (SQLTableElement sQLTableElement : this.tableElementList) {
            e2 = sQLTableElement.clone();
            e2.setParent(x);
            x.tableElementList.add((SQLTableElement)e2);
        }
        for (SQLColumnDefinition sQLColumnDefinition : this.partitionColumns) {
            e2 = sQLColumnDefinition.clone();
            ((SQLObjectImpl)e2).setParent(x);
            x.partitionColumns.add((SQLColumnDefinition)e2);
        }
        if (this.inherits != null) {
            x.setInherits(this.inherits.clone());
        }
        if (this.select != null) {
            x.setSelect(this.select.clone());
        }
        if (this.comment != null) {
            x.setComment(this.comment.clone());
        }
        if (this.partitionBy != null) {
            x.setPartitionBy(this.partitionBy.clone());
        }
        if (this.like != null) {
            x.setLike(this.like.clone());
        }
        x.compress = this.compress;
        x.logging = this.logging;
        if (this.tablespace != null) {
            x.setTablespace(this.tablespace.clone());
        }
        if (this.partitionBy != null) {
            x.setPartitionBy(this.partitionBy.clone());
        }
        if (this.localPartitioning != null) {
            x.setLocalPartitioning(this.localPartitioning.clone());
        }
        if (this.storedAs != null) {
            x.setStoredAs(this.storedAs.clone());
        }
        if (this.storedBy != null) {
            x.setStoredBy(this.storedBy.clone());
        }
        if (this.lifeCycle != null) {
            x.setLifeCycle(this.lifeCycle.clone());
        }
        if (this.location != null) {
            x.setLocation(this.location.clone());
        }
        x.onCommitPreserveRows = this.onCommitPreserveRows;
        x.onCommitDeleteRows = this.onCommitDeleteRows;
        for (SQLAssignItem sQLAssignItem : this.tableOptions) {
            SQLAssignItem item2 = sQLAssignItem.clone();
            item2.setParent(sQLAssignItem);
            x.tableOptions.add(item2);
        }
        if (this.rowFormat != null) {
            x.setRowFormat(this.rowFormat.clone());
        }
        if (this.clusteringType != null) {
            x.setClusteringType(this.clusteringType);
        }
        for (SQLSelectOrderByItem sQLSelectOrderByItem : this.clusteredBy) {
            e2 = sQLSelectOrderByItem.clone();
            ((SQLObjectImpl)e2).setParent(x);
            x.clusteredBy.add((SQLSelectOrderByItem)e2);
        }
        for (SQLSelectOrderByItem sQLSelectOrderByItem : this.sortedBy) {
            e2 = sQLSelectOrderByItem.clone();
            ((SQLObjectImpl)e2).setParent(x);
            x.sortedBy.add((SQLSelectOrderByItem)e2);
        }
        x.buckets = this.buckets;
        x.shards = this.shards;
        x.afterSemi = this.afterSemi;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public void setReplace(boolean replace) {
        this.ignore = false;
        this.replace = replace;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.replace = false;
        this.ignore = ignore;
    }

    public boolean isSingle() {
        return this.single;
    }

    public void setSingle(boolean single) {
        this.single = single;
    }

    public SQLExpr getStoredAs() {
        return this.storedAs;
    }

    public void setStoredAs(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.storedAs = x;
    }

    public SQLExpr getStoredBy() {
        return this.storedBy;
    }

    public void setStoredBy(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.storedBy = x;
    }

    @Override
    public SQLCreateTableStatement clone() {
        SQLCreateTableStatement x = new SQLCreateTableStatement(this.dbType);
        this.cloneTo(x);
        return x;
    }

    @Override
    public String toString() {
        return SQLUtils.toSQLString((SQLObject)this, this.dbType);
    }

    public boolean isOnCommitPreserveRows() {
        return this.onCommitPreserveRows;
    }

    public void setOnCommitPreserveRows(boolean onCommitPreserveRows) {
        this.onCommitPreserveRows = onCommitPreserveRows;
    }

    public boolean isExternal() {
        return Feature.External.isEnabled(this.features);
    }

    public void setExternal(boolean external) {
        this.features = Feature.External.config(this.features, external);
    }

    public ClusteringType getClusteringType() {
        return this.clusteringType;
    }

    public void setClusteringType(ClusteringType clusteringType) {
        this.clusteringType = clusteringType;
    }

    public List<SQLSelectOrderByItem> getClusteredBy() {
        return this.clusteredBy;
    }

    public void addClusteredByItem(SQLSelectOrderByItem item) {
        item.setParent(this);
        this.clusteredBy.add(item);
    }

    public List<SQLSelectOrderByItem> getSortedBy() {
        return this.sortedBy;
    }

    public void addSortedByItem(SQLSelectOrderByItem item) {
        item.setParent(this);
        this.sortedBy.add(item);
    }

    public int getBuckets() {
        return this.buckets;
    }

    public void setBuckets(int buckets) {
        this.buckets = buckets;
    }

    public int getShards() {
        return this.shards;
    }

    public void setShards(int shards) {
        this.shards = shards;
    }

    public List<SQLColumnDefinition> getPartitionColumns() {
        return this.partitionColumns;
    }

    public void addPartitionColumn(SQLColumnDefinition column) {
        if (column != null) {
            column.setParent(this);
        }
        this.partitionColumns.add(column);
    }

    public List<SQLAssignItem> getTableOptions() {
        return this.tableOptions;
    }

    @Deprecated
    public List<SQLAssignItem> getTblProperties() {
        return this.tableOptions;
    }

    @Deprecated
    public void addTblProperty(String name, SQLExpr value) {
        this.addOption(name, value);
    }

    public SQLExternalRecordFormat getRowFormat() {
        return this.rowFormat;
    }

    public void setRowFormat(SQLExternalRecordFormat x) {
        if (x != null) {
            x.setParent(this);
        }
        this.rowFormat = x;
    }

    public boolean isDimension() {
        return Feature.Dimension.isEnabled(this.features);
    }

    public void setDimension(boolean dimension) {
        this.features = Feature.Dimension.config(this.features, dimension);
    }

    public SQLExpr getLocation() {
        return this.location;
    }

    public void setLocation(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.location = x;
    }

    public void addOption(String name, SQLExpr value) {
        SQLAssignItem assignItem = new SQLAssignItem(new SQLIdentifierExpr(name), value);
        assignItem.setParent(this);
        this.tableOptions.add(assignItem);
    }

    public SQLExpr getOption(String name) {
        if (name == null) {
            return null;
        }
        long hash64 = FnvHash.hashCode64(name);
        for (SQLAssignItem item : this.tableOptions) {
            SQLExpr target = item.getTarget();
            if (!(target instanceof SQLIdentifierExpr) || ((SQLIdentifierExpr)target).hashCode64() != hash64) continue;
            return item.getValue();
        }
        return null;
    }

    public boolean removeOption(String name) {
        if (name == null) {
            return false;
        }
        long hash64 = FnvHash.hashCode64(name);
        for (int i = this.tableOptions.size() - 1; i >= 0; --i) {
            SQLAssignItem item = this.tableOptions.get(i);
            SQLExpr target = item.getTarget();
            if (!(target instanceof SQLIdentifierExpr) || ((SQLIdentifierExpr)target).hashCode64() != hash64) continue;
            this.tableOptions.remove(i);
            return true;
        }
        return false;
    }

    public SQLExpr getTblProperty(String name) {
        if (name == null) {
            return null;
        }
        long hash64 = FnvHash.hashCode64(name);
        for (SQLAssignItem item : this.tableOptions) {
            SQLExpr target = item.getTarget();
            if (!(target instanceof SQLIdentifierExpr) || ((SQLIdentifierExpr)target).hashCode64() != hash64) continue;
            return item.getValue();
        }
        return null;
    }

    public Object getOptionValue(String name) {
        SQLExpr option = this.getOption(name);
        if (option instanceof SQLValuableExpr) {
            return ((SQLValuableExpr)option).getValue();
        }
        return null;
    }

    public Object getTblPropertyValue(String name) {
        SQLExpr option = this.getTblProperty(name);
        if (option instanceof SQLValuableExpr) {
            return ((SQLValuableExpr)option).getValue();
        }
        return null;
    }

    public Object getOptionOrTblPropertyValue(String name) {
        SQLExpr option = this.getTblProperty(name);
        if (option == null) {
            option = this.getOption(name);
        }
        if (option instanceof SQLValuableExpr) {
            return ((SQLValuableExpr)option).getValue();
        }
        return null;
    }

    public String getCatalog() {
        return null;
    }

    public boolean containsDuplicateColumnNames() {
        return this.containsDuplicateColumnNames(false);
    }

    public boolean containsDuplicateColumnNames(boolean throwException) {
        HashMap<Long, SQLTableElement> columnMap = new HashMap<Long, SQLTableElement>();
        for (SQLTableElement item : this.tableElementList) {
            SQLName columnName;
            long nameHashCode64;
            SQLTableElement old;
            if (!(item instanceof SQLColumnDefinition) || (old = columnMap.put(nameHashCode64 = (columnName = ((SQLColumnDefinition)item).getName()).nameHashCode64(), item)) == null) continue;
            if (throwException) {
                throw new ParserException("Table contains duplicate column names : " + SQLUtils.normalize(columnName.getSimpleName()));
            }
            return true;
        }
        return false;
    }

    @Override
    public SQLDDLStatement.DDLObjectType getDDLObjectType() {
        return SQLDDLStatement.DDLObjectType.TABLE;
    }

    public SQLExpr getLifeCycle() {
        return this.lifeCycle;
    }

    public void setLifeCycle(SQLExpr x) {
        Number number;
        if (x instanceof SQLNumberExpr && (number = ((SQLNumberExpr)x).getNumber()) instanceof BigDecimal) {
            x = new SQLIntegerExpr(((BigDecimal)number).intValueExact());
        }
        if (x != null) {
            x.setParent(this);
        }
        this.lifeCycle = x;
    }

    public static enum Feature {
        Temporary(1),
        Global(2),
        Local(4),
        OrReplace(8),
        IfNotExists(16),
        External(32),
        Transactional(64),
        Shadow(128),
        Dimension(256),
        Set(512),
        MultiSet(1024),
        Volatile(2048),
        Unlogged(4096);

        public final int mask;

        private Feature(int mask) {
            this.mask = mask;
        }

        public boolean isEnabled(long features) {
            return (features & (long)this.mask) != 0L;
        }

        public int config(int features, boolean state) {
            features = state ? (features |= this.mask) : (features &= ~this.mask);
            return features;
        }
    }
}

