/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.impl;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.alibaba.nacos.api.exception.NacosException;
import com.google.gson.Gson;
import com.xiaomi.data.push.client.HttpClientV5;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.DashboardConstant;
import org.apache.ozhera.monitor.bo.DashboardDTO;
import org.apache.ozhera.monitor.bo.GrafanaApiKeyReq;
import org.apache.ozhera.monitor.bo.GrafanaApiKeyRes;
import org.apache.ozhera.monitor.bo.GrafanaCreateDashboardRes;
import org.apache.ozhera.monitor.bo.GrafanaCreateDataSourceReq;
import org.apache.ozhera.monitor.bo.GrafanaCreateDataSourceRes;
import org.apache.ozhera.monitor.bo.GrafanaFolderReq;
import org.apache.ozhera.monitor.bo.GrafanaFolderRes;
import org.apache.ozhera.monitor.bo.GrafanaGetDataSourceRes;
import org.apache.ozhera.monitor.bo.GrafanaGetFolderRes;
import org.apache.ozhera.monitor.dao.GrafanaTemplateDao;
import org.apache.ozhera.monitor.dao.model.GrafanaTemplate;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.HeraDashboardService;
import org.apache.ozhera.monitor.service.prometheus.JobService;
import org.apache.ozhera.monitor.utils.FreeMarkerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"service.selector.property"}, havingValue="outer")
public class HeraDashboardServiceImpl
implements HeraDashboardService {
    private static final Logger log = LoggerFactory.getLogger(HeraDashboardServiceImpl.class);
    private Gson gson = new Gson();
    @Autowired
    GrafanaTemplateDao grafanaTemplateDao;
    @Autowired
    JobService jobService;
    @Value(value="${nacos.config.addrs}")
    private String nacosAddress;
    @NacosValue(value="${grafana.address}", autoRefreshed=true)
    public String grafanaUrl;
    @NacosValue(value="${grafana.domain}", autoRefreshed=true)
    public String grafanaDomain;
    @NacosValue(value="${grafana.apikey.url}", autoRefreshed=true)
    public String grafanaApiKeyUrl;
    @NacosValue(value="${grafana.datasource.url}", autoRefreshed=true)
    public String grafanaDatasourceUrl;
    @NacosValue(value="${grafana.folder.url}", autoRefreshed=true)
    public String grafanaFolderUrl;
    @NacosValue(value="${grafana.jaeger.query.token}", autoRefreshed=true)
    public String jaegerQueryToken;
    @NacosValue(value="${grafana.createDashboard.url}", autoRefreshed=true)
    public String grafanaDashboardUrl;
    public static final String HERA_GRAFANA_TEMPLATE = "/heraGrafanaTemplate";
    public static final String HERA_SCRAPE_JOB_TEMPLATE = "/heraScrapeJobTemplate";
    @Value(value="${server.type}")
    private String serverType;
    @NacosValue(value="${prometheus.url}", autoRefreshed=true)
    private String prometheusUrl;
    @NacosValue(value="${grafana.username}", autoRefreshed=true)
    private String grafanaUserName;
    @NacosValue(value="${grafana.password}", autoRefreshed=true)
    private String grafanaPassword;

    @Override
    @PostConstruct
    public void init() {
        try {
            log.info("begin createDefaultGrafanaResource");
            this.createDefaultScrapeJob();
            this.createDefaultDashboardTemplate();
            DashboardDTO dataSourceDTO = new DashboardDTO();
            if (StringUtils.isBlank((CharSequence)dataSourceDTO.getPrometheusDatasource())) {
                dataSourceDTO.setPrometheusDatasource(this.prometheusUrl);
            }
            if (StringUtils.isBlank((CharSequence)dataSourceDTO.getUsername())) {
                dataSourceDTO.setUsername(this.grafanaUserName);
            }
            if (StringUtils.isBlank((CharSequence)dataSourceDTO.getPassword())) {
                dataSourceDTO.setPassword(this.grafanaPassword);
            }
            if (StringUtils.isBlank((CharSequence)dataSourceDTO.getDashboardFolderName())) {
                dataSourceDTO.setDashboardFolderName("Hera");
            }
            Result result = this.createGrafanaResources(dataSourceDTO);
        }
        catch (Exception e) {
            log.error("GrafanaInitController init error:", (Throwable)e);
            throw new RuntimeException("GrafanaInitController init error");
        }
    }

    @Override
    public Result createGrafanaResources(DashboardDTO dashboardDTO) {
        log.info("HeraDashboardService.createGrafanaResources param:{}", (Object)this.gson.toJson((Object)dashboardDTO));
        String base64Str = dashboardDTO.getUsername() + ":" + dashboardDTO.getPassword();
        String basicAuth = Base64.getEncoder().encodeToString(base64Str.getBytes());
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        header.put("Authorization", "Basic " + basicAuth);
        String apiKey = this.createApiKey(header);
        if (apiKey == null || apiKey.isEmpty()) {
            return Result.fail((ErrorCode)ErrorCode.API_KEY_CREATE_FAIL);
        }
        log.info("createGrafanaResources.apikey:{}", (Object)apiKey);
        header.put("Authorization", "Bearer " + apiKey);
        String datasourceUid = this.createDataSource(header, dashboardDTO.getPrometheusDatasource());
        if (datasourceUid == null || datasourceUid.isEmpty()) {
            return Result.fail((ErrorCode)ErrorCode.DATASOURCE_CREATE_FAIL);
        }
        log.info("createGrafanaResources.datasourceUid:{}", (Object)datasourceUid);
        int folderId = this.createFolder(header, dashboardDTO.getDashboardFolderName());
        if (folderId == -1) {
            return Result.fail((ErrorCode)ErrorCode.FOLDER_CREATE_FAIL);
        }
        this.createDefaultGrafanaDashboard(datasourceUid, header);
        try {
            ConfigService configService = NacosFactory.createConfigService((String)this.nacosAddress);
            String nacosResult = configService.getConfig("mimonitor_open_config", "DEFAULT_GROUP", 5000L);
            Properties props = new Properties();
            props.load(new StringReader(nacosResult));
            props.setProperty("grafana.api.key", apiKey);
            props.setProperty("grafana.prometheus.datasource", "Prometheus");
            props.setProperty("grafana.folder.uid", "Hera");
            props.setProperty("prometheusUid", datasourceUid);
            StringWriter writer = new StringWriter();
            props.store(writer, "after replace!");
            String finalNacosConfig = writer.getBuffer().toString();
            log.info("createGrafanaResources.before overlays nacos config:{}", (Object)finalNacosConfig);
            boolean postResult = configService.publishConfig("mimonitor_open_config", "DEFAULT_GROUP", finalNacosConfig);
            if (!postResult) {
                log.error("createGrafanaResources.create nacos config failed:{}", (Object)postResult);
            } else {
                log.info("createGrafanaResources.create nacos config success");
            }
        }
        catch (NacosException | IOException e) {
            log.error("createGrafanaResources.request nacos error:{}", (Object)e.getMessage());
        }
        return Result.success((Object)"success");
    }

    @Override
    public void createDefaultDashboardTemplate() {
        GrafanaTemplate grafanaGoTemplate;
        DashboardConstant.GRAFANA_SRE_TEMPLATES.forEach(name -> {
            GrafanaTemplate grafanaTemplate = this.grafanaTemplateDao.fetchOneByName((String)name);
            if (grafanaTemplate == null) {
                try {
                    this.insertDashboardTemplate((String)name);
                }
                catch (IOException e) {
                    log.error("HeraDashboardService.createDefaultDashboardTemplate error :{}", (Object)e.getMessage());
                }
            } else {
                int resCount = this.grafanaTemplateDao.deleteHard(grafanaTemplate.getId());
                if (resCount >= 1) {
                    try {
                        this.insertDashboardTemplate((String)name);
                    }
                    catch (IOException e) {
                        log.error("HeraDashboardService.createDefaultDashboardTemplate Multiple create error :{}", (Object)e.getMessage());
                    }
                }
            }
        });
        GrafanaTemplate grafanaTemplate = this.grafanaTemplateDao.fetchOneByName("hera-java\u6a21\u677f");
        if (grafanaTemplate == null) {
            try {
                String content = FreeMarkerUtil.getTemplateStr((String)HERA_GRAFANA_TEMPLATE, (String)"jaegerQuery.ftl");
                GrafanaTemplate template = new GrafanaTemplate();
                template.setName("hera-java\u6a21\u677f");
                template.setCreateTime(new Date());
                template.setUpdateTime(new Date());
                template.setLanguage(0);
                template.setPlatform(0);
                template.setAppType(0);
                template.setTemplate(content);
                template.setDeleted(false);
                template.setPanelIdList("110,148,152,112,116,118,150,122,120,126,124,130,128,132,134,136,138,140,142,144,146,52,56,58,60,66,95,96,50,82,68,78,74,76,102,104,106,146,159,163,168,169,170,171,172,173,174,176,178");
                int insertRes = this.grafanaTemplateDao.insert(template);
                log.info("HeraDashboardService.createDefaultDashboardTemplate name:{},insertRes:{}", (Object)"hera-java\u6a21\u677f", (Object)insertRes);
            }
            catch (IOException e) {
                log.error("HeraDashboardService.createDefaultDashboardTemplate java template error :{}", (Object)e.getMessage());
            }
        }
        if ((grafanaGoTemplate = this.grafanaTemplateDao.fetchOneByName("hera-golang\u6a21\u677f")) == null) {
            try {
                String content = FreeMarkerUtil.getTemplateStr((String)HERA_GRAFANA_TEMPLATE, (String)"golang.ftl");
                GrafanaTemplate template = new GrafanaTemplate();
                template.setName("hera-golang\u6a21\u677f");
                template.setCreateTime(new Date());
                template.setUpdateTime(new Date());
                template.setLanguage(1);
                template.setPlatform(0);
                template.setAppType(0);
                template.setTemplate(content);
                template.setDeleted(false);
                template.setPanelIdList("110,148,152,112,116,120,124,128,132,134,136,138,140,142,144,146,66,95,96,50,82,68,78,102,104,106,146,159,170,171,172,173,174,150,126,130,122,118,163,169,168");
                int insertRes = this.grafanaTemplateDao.insert(template);
                log.info("HeraDashboardService.createDefaultDashboardTemplate name:{},insertRes:{}", (Object)"hera-golang\u6a21\u677f", (Object)insertRes);
            }
            catch (IOException e) {
                log.error("HeraDashboardService.createDefaultDashboardTemplate golang template error :{}", (Object)e.getMessage());
            }
        }
    }

    private void insertDashboardTemplate(String name) throws IOException {
        String content = FreeMarkerUtil.getTemplateStr((String)HERA_GRAFANA_TEMPLATE, (String)(name + ".ftl"));
        GrafanaTemplate template = new GrafanaTemplate();
        template.setName(name);
        template.setCreateTime(new Date());
        template.setUpdateTime(new Date());
        template.setLanguage(0);
        template.setPlatform(0);
        template.setAppType(1);
        template.setTemplate(content);
        template.setDeleted(false);
        int insertRes = this.grafanaTemplateDao.insert(template);
        log.info("HeraDashboardService.insertDashboardTemplate name:{},insertRes:{}", (Object)name, (Object)insertRes);
    }

    public void createDefaultScrapeJob() {
        HashMap<String, String> jaegerQueryMap = new HashMap<String, String>();
        jaegerQueryMap.put("token", this.jaegerQueryToken);
        try {
            Result golangRuntimeResult;
            Result customizeResult;
            Result nodeResult;
            Result dockerResult;
            Result jvmResult;
            Result jaegerResult = this.jobService.searchJobByName(null, "hera", "jaeger-query");
            log.info("jaegerResult:{}", (Object)jaegerResult);
            if (jaegerResult.getData().equals("null")) {
                log.info("jaeger_query job begin create");
                String jaegerQueryJobJson = FreeMarkerUtil.getContent((String)HERA_SCRAPE_JOB_TEMPLATE, (String)"jaegerQueryScrapeJob.ftl", jaegerQueryMap);
                Result jaegerQueryJobRes = this.jobService.createJob(null, "Hera", jaegerQueryJobJson, "\u521d\u59cb\u5316\u521b\u5efa\u4e1a\u52a1\u76d1\u63a7");
                log.info("HeraDashboardService.createDefaultScrapeJob jaeger_query res: {}", jaegerQueryJobRes.getData());
            }
            if ((jvmResult = this.jobService.searchJobByName(null, "hera", "mione-yewujiankong-china-jvm")).getData().equals("null")) {
                log.info("jvm job begin create");
                String jvmJobJson = FreeMarkerUtil.getContent((String)HERA_SCRAPE_JOB_TEMPLATE, (String)"jvmScrapeJob.ftl", new HashMap());
                Result jvmJobJsonRes = this.jobService.createJob(null, "Hera", jvmJobJson, "\u521d\u59cb\u5316\u521b\u5efajvm\u76d1\u63a7");
                log.info("HeraDashboardService.createDefaultScrapeJob jvm res: {}", jvmJobJsonRes.getData());
            }
            if ((dockerResult = this.jobService.searchJobByName(null, "hera", "mione-china-cadvisor-k8s")).getData().equals("null")) {
                log.info("docker job begin create");
                String dockerJobJson = FreeMarkerUtil.getContent((String)HERA_SCRAPE_JOB_TEMPLATE, (String)"dockerScrapeJob.ftl", new HashMap());
                Result dockerJobJsonRes = this.jobService.createJob(null, "Hera", dockerJobJson, "\u521d\u59cb\u5316\u521b\u5efa\u5bb9\u5668\u76d1\u63a7");
                log.info("HeraDashboardService.createDefaultScrapeJob docker res: {}", dockerJobJsonRes.getData());
            }
            if ((nodeResult = this.jobService.searchJobByName(null, "hera", "mione-china-node-k8s")).getData().equals("null")) {
                log.info("node job begin create");
                String nodeJobJson = FreeMarkerUtil.getContent((String)HERA_SCRAPE_JOB_TEMPLATE, (String)"nodeScrapeJob.ftl", new HashMap());
                Result nodeJobJsonRes = this.jobService.createJob(null, "Hera", nodeJobJson, "\u521d\u59cb\u5316\u521b\u5efa\u7269\u7406\u673a\u76d1\u63a7");
                log.info("HeraDashboardService.createDefaultScrapeJob node res: {}", nodeJobJsonRes.getData());
            }
            if ((customizeResult = this.jobService.searchJobByName(null, "hera", "mione-china-customize")).getData().equals("null")) {
                log.info("customize job begin create");
                String customizeJobJson = FreeMarkerUtil.getContent((String)HERA_SCRAPE_JOB_TEMPLATE, (String)"customizeScrapeJob.ftl", new HashMap());
                Result customizeJobJsonRes = this.jobService.createJob(null, "Hera", customizeJobJson, "\u521d\u59cb\u5316\u521b\u5efa\u81ea\u5b9a\u4e49\u76d1\u63a7");
                log.info("HeraDashboardService.createDefaultScrapeJob customize res: {}", customizeJobJsonRes.getData());
            }
            if ((golangRuntimeResult = this.jobService.searchJobByName(null, "hera", "mione-golang-runtime")).getData().equals("null")) {
                log.info("golangRuntimeResult job begin create");
                String golangRuntimeJobJson = FreeMarkerUtil.getContent((String)HERA_SCRAPE_JOB_TEMPLATE, (String)"golangRuntimeScrapeJob.ftl", new HashMap());
                Result golangRuntimeJobJsonRes = this.jobService.createJob(null, "Hera", golangRuntimeJobJson, "\u521d\u59cb\u5316\u521b\u5efagolang Runtime\u76d1\u63a7");
                log.info("HeraDashboardService.createDefaultScrapeJob golang runtime res: {}", golangRuntimeJobJsonRes.getData());
            }
        }
        catch (Exception e) {
            log.error("HeraDashboardService.createDefaultScrapeJob error :{}", (Object)e.getMessage());
        }
    }

    private String createApiKey(Map<String, String> header) {
        String apiKeyName = "hera-" + System.currentTimeMillis();
        GrafanaApiKeyReq req = new GrafanaApiKeyReq(apiKeyName, "Admin");
        log.info("GrafanaApiKeyReq:{}", (Object)this.gson.toJson((Object)req));
        try {
            String grafanaApiKeyResStr = HttpClientV5.post((String)(this.grafanaUrl + this.grafanaApiKeyUrl), (String)this.gson.toJson((Object)req), header);
            log.info("HeraDashboardService.createApiKey request apikey res:{}", (Object)grafanaApiKeyResStr);
            GrafanaApiKeyRes grafanaApiKeyRes = (GrafanaApiKeyRes)this.gson.fromJson(grafanaApiKeyResStr, GrafanaApiKeyRes.class);
            return grafanaApiKeyRes.getKey();
        }
        catch (Exception e) {
            log.error("HeraDashboardService.createApiKey error :{}", (Object)e.getMessage());
            return null;
        }
    }

    private String createDataSource(Map<String, String> header, String prometheusDatasourceUrl) {
        GrafanaCreateDataSourceReq req = new GrafanaCreateDataSourceReq();
        req.setName("Prometheus");
        req.setType("prometheus");
        req.setAccess("proxy");
        req.setBasicAuth(false);
        req.setUrl(prometheusDatasourceUrl);
        log.info("GrafanaCreateDataSourceReq:{}", (Object)this.gson.toJson((Object)req));
        try {
            String getDatasourceRes = HttpClientV5.get((String)(this.grafanaUrl + this.grafanaDatasourceUrl + "/name/Prometheus"), header);
            log.info("HeraDashboardService.createDataSource getDatasourceRes:{}", (Object)getDatasourceRes);
            GrafanaGetDataSourceRes grafanaGetDataSourceRes = (GrafanaGetDataSourceRes)this.gson.fromJson(getDatasourceRes, GrafanaGetDataSourceRes.class);
            if (grafanaGetDataSourceRes.getUid() != null) {
                return grafanaGetDataSourceRes.getUid();
            }
            String grafanaDatasourceResStr = HttpClientV5.post((String)(this.grafanaUrl + this.grafanaDatasourceUrl), (String)this.gson.toJson((Object)req), header);
            log.info("HeraDashboardService.createDataSource request res:{}", (Object)grafanaDatasourceResStr);
            GrafanaCreateDataSourceRes grafanaCreateDataSourceRes = (GrafanaCreateDataSourceRes)this.gson.fromJson(grafanaDatasourceResStr, GrafanaCreateDataSourceRes.class);
            return grafanaCreateDataSourceRes.getDatasource().getUid();
        }
        catch (Exception e) {
            log.error("HeraDashboardService.createDataSource error :{}", (Object)e.getMessage());
            return null;
        }
    }

    private int createFolder(Map<String, String> header, String folderTitle) {
        GrafanaFolderReq req = new GrafanaFolderReq();
        req.setTitle(folderTitle);
        req.setUid("Hera");
        log.info("GrafanaCreateFolderReq:{}", (Object)this.gson.toJson((Object)req));
        try {
            String getFolderRes = HttpClientV5.get((String)(this.grafanaUrl + this.grafanaFolderUrl + "/Hera"), header);
            log.info("HeraDashboardService.createFolder getFolderRes:{}", (Object)getFolderRes);
            GrafanaGetFolderRes grafanaGetFolderRes = (GrafanaGetFolderRes)this.gson.fromJson(getFolderRes, GrafanaGetFolderRes.class);
            if (grafanaGetFolderRes.getId() != null) {
                return grafanaGetFolderRes.getId();
            }
            String grafanaFolderResStr = HttpClientV5.post((String)(this.grafanaUrl + this.grafanaFolderUrl), (String)this.gson.toJson((Object)req), header);
            log.info("HeraDashboardService.createFolder request res:{}", (Object)grafanaFolderResStr);
            GrafanaFolderRes grafanaFolderRes = (GrafanaFolderRes)this.gson.fromJson(grafanaFolderResStr, GrafanaFolderRes.class);
            return grafanaFolderRes.getId();
        }
        catch (Exception e) {
            log.error("HeraDashboardService.createFolder error :{}", (Object)e.getMessage());
            return -1;
        }
    }

    private void createDefaultGrafanaDashboard(String prometheusUid, Map<String, String> header) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("prometheusUid", prometheusUid);
        map.put("serviceMarketUrl", this.grafanaDomain + "/d/${__data.fields.application.text}/ye-wu-jian-kong-${__data.fields.application.text}?orgId=1&refresh=30s&theme=light");
        map.put("query0", "${query0}");
        map.put("env", this.serverType);
        map.put("serviceName", "hera");
        DashboardConstant.GRAFANA_SRE_TEMPLATES.forEach(name -> {
            GrafanaTemplate grafanaTemplate = this.grafanaTemplateDao.fetchOneByName((String)name);
            try {
                if (grafanaTemplate != null) {
                    String template = FreeMarkerUtil.freemarkerProcess((Map)map, (String)grafanaTemplate.getTemplate());
                    log.info("HeraDashboardService.createDefaultGrafanaDashboard name :{} begin!", name);
                    String grafanaDashboardResStr = HttpClientV5.post((String)(this.grafanaUrl + this.grafanaDashboardUrl), (String)template, (Map)header);
                    log.info("HeraDashboardService.createDefaultGrafanaDashboard request " + name + " template res:{}", (Object)grafanaDashboardResStr);
                    GrafanaCreateDashboardRes grafanaCreateDashboardRes = (GrafanaCreateDashboardRes)this.gson.fromJson(grafanaDashboardResStr, GrafanaCreateDashboardRes.class);
                    if (!grafanaCreateDashboardRes.getStatus().equals("success")) {
                        log.error("HeraDashboardService.createDefaultGrafanaDashboard name:{},status:{},message:{}", new Object[]{name, grafanaCreateDashboardRes.getStatus(), grafanaCreateDashboardRes.getMessage()});
                    }
                } else {
                    log.error("HeraDashboardService.createDefaultGrafanaDashboard " + name + " template fetch error!");
                }
            }
            catch (Exception e) {
                log.error("HeraDashboardService.createDefaultGrafanaDashboard error:{}", (Throwable)e);
            }
        });
    }
}

