/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.stream.config;

import com.alibaba.nacos.api.config.listener.Listener;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.anno.Component;
import com.xiaomi.youpin.docean.common.StringUtils;
import com.xiaomi.youpin.docean.plugin.nacos.NacosConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ozhera.log.common.Config;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.model.LogtailConfig;
import org.apache.ozhera.log.model.MilogSpaceData;
import org.apache.ozhera.log.model.SinkConfig;
import org.apache.ozhera.log.stream.job.JobManager;
import org.apache.ozhera.log.stream.job.extension.StreamCommonExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class MilogConfigListener {
    private static final Logger log = LoggerFactory.getLogger(MilogConfigListener.class);
    private Long spaceId;
    private String dataId;
    private String group;
    private Listener listener;
    private MilogSpaceData milogSpaceData;
    private NacosConfig nacosConfig;
    private JobManager jobManager;
    private Gson gson = new Gson();
    private Map<Long, LogtailConfig> oldLogTailConfigMap = new ConcurrentHashMap<Long, LogtailConfig>();
    private Map<Long, SinkConfig> oldSinkConfigMap = new ConcurrentHashMap<Long, SinkConfig>();
    private ReentrantLock buildDataLock = new ReentrantLock();
    private StreamCommonExtension streamCommonExtension;
    private static ExecutorService THREAD_POOL = Executors.newVirtualThreadPerTaskExecutor();

    public MilogConfigListener(Long spaceId, String dataId, String group, MilogSpaceData milogSpaceData, NacosConfig nacosConfig) {
        this.spaceId = spaceId;
        this.dataId = dataId;
        this.group = group;
        this.milogSpaceData = milogSpaceData;
        this.nacosConfig = nacosConfig;
        this.jobManager = new JobManager();
        this.listener = this.getListener(dataId, milogSpaceData);
        nacosConfig.addListener(dataId, group, this.listener);
        this.streamCommonExtension = this.getStreamCommonExtensionInstance();
    }

    private StreamCommonExtension getStreamCommonExtensionInstance() {
        String factualServiceName = Config.ins().get("common.stream.extension", "defaultCommonStreamExtension");
        return (StreamCommonExtension)Ioc.ins().getBean(factualServiceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNacosConfigDataJob(MilogSpaceData newMilogSpaceData) throws Exception {
        boolean locked = false;
        try {
            locked = this.buildDataLock.tryLock(1L, TimeUnit.MINUTES);
            if (locked) {
                if (!this.oldLogTailConfigMap.isEmpty() && !this.oldSinkConfigMap.isEmpty()) {
                    List sinkConfigs = newMilogSpaceData.getSpaceConfig();
                    this.stopUnusedOldStoreJobs(sinkConfigs);
                    for (SinkConfig sinkConfig : sinkConfigs) {
                        this.stopOldJobsForRemovedTailIds(sinkConfig);
                        if (this.oldSinkConfigMap.containsKey(sinkConfig.getLogstoreId())) {
                            if (!this.isStoreSame(sinkConfig, this.oldSinkConfigMap.get(sinkConfig.getLogstoreId()))) {
                                this.restartPerTail(sinkConfig, this.milogSpaceData);
                                continue;
                            }
                            this.handlePerTailComparison(sinkConfig, this.milogSpaceData);
                            continue;
                        }
                        this.newStoreStart(sinkConfig, this.milogSpaceData);
                    }
                } else {
                    this.initNewJob(newMilogSpaceData);
                }
            } else {
                log.warn("handleNacosConfigDataJob lock failed,data:{}", (Object)this.gson.toJson((Object)newMilogSpaceData));
            }
        }
        finally {
            if (locked) {
                this.buildDataLock.unlock();
            }
        }
    }

    private void restartPerTail(SinkConfig sinkConfig, MilogSpaceData newMilogSpaceData) {
        this.stopOldJobsForStore(sinkConfig.getLogstoreId());
        for (LogtailConfig logtailConfig : sinkConfig.getLogtailConfigs()) {
            this.startTailPer(sinkConfig, logtailConfig, newMilogSpaceData.getMilogSpaceId());
        }
        this.oldSinkConfigMap.put(sinkConfig.getLogstoreId(), sinkConfig);
    }

    private void handlePerTailComparison(SinkConfig sinkConfig, MilogSpaceData newMilogSpaceData) {
        for (LogtailConfig logtailConfig : sinkConfig.getLogtailConfigs()) {
            if (this.isTailSame(logtailConfig, this.oldLogTailConfigMap.get(logtailConfig.getLogtailId()))) continue;
            if (null != this.oldLogTailConfigMap.get(logtailConfig.getLogtailId())) {
                this.stopOldJobForTail(logtailConfig, sinkConfig);
            }
            this.startTailPer(sinkConfig, logtailConfig, newMilogSpaceData.getMilogSpaceId());
        }
    }

    private void newStoreStart(SinkConfig sinkConfig, MilogSpaceData newMilogSpaceData) {
        for (LogtailConfig logtailConfig : sinkConfig.getLogtailConfigs()) {
            this.startTailPer(sinkConfig, logtailConfig, newMilogSpaceData.getMilogSpaceId());
        }
        this.oldSinkConfigMap.put(sinkConfig.getLogstoreId(), sinkConfig);
    }

    private void stopAllJobClear() {
        if (!this.oldSinkConfigMap.isEmpty()) {
            for (SinkConfig sinkConfig : this.oldSinkConfigMap.values()) {
                this.stopOldJobsForStore(sinkConfig.getLogstoreId());
            }
            this.oldSinkConfigMap.clear();
        }
    }

    private void stopOldJobsForRemovedTailIds(SinkConfig sinkConfig) {
        List collect;
        List newIds = sinkConfig.getLogtailConfigs().stream().map(LogtailConfig::getLogtailId).collect(Collectors.toList());
        List<Object> oldIds = Lists.newArrayList();
        if (this.oldSinkConfigMap.containsKey(sinkConfig.getLogstoreId())) {
            oldIds = this.oldSinkConfigMap.get(sinkConfig.getLogstoreId()).getLogtailConfigs().stream().map(LogtailConfig::getLogtailId).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(collect = oldIds.stream().filter(tailId -> !newIds.contains(tailId)).collect(Collectors.toList()))) {
            log.info("newIds:{},oldIds:{},collect:{}", new Object[]{this.gson.toJson(newIds), this.gson.toJson((Object)oldIds), this.gson.toJson(collect)});
            for (Long tailId2 : collect) {
                this.stopOldJobForTail(this.oldLogTailConfigMap.get(tailId2), sinkConfig);
            }
        }
    }

    private void stopUnusedOldStoreJobs(List<SinkConfig> newSinkConfig) {
        List oldStoreIds = this.oldSinkConfigMap.keySet().stream().toList();
        List<Long> newStoreIds = newSinkConfig.stream().map(SinkConfig::getLogstoreId).toList();
        List<Long> unusedStoreIds = oldStoreIds.stream().filter(tailId -> !newStoreIds.contains(tailId)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(unusedStoreIds)) {
            unusedStoreIds.forEach(this::stopOldJobsForStore);
        }
    }

    private boolean isStoreSame(SinkConfig newConfig, SinkConfig oldConfig) {
        if (null == oldConfig) {
            return false;
        }
        return newConfig.equals((Object)oldConfig);
    }

    private boolean isTailSame(LogtailConfig newTail, LogtailConfig oldTail) {
        if (null == oldTail) {
            return false;
        }
        return newTail.equals((Object)oldTail);
    }

    public MilogConfigListener() {
    }

    private void stopOldJobsForStore(Long logStoreId) {
        SinkConfig sinkConfig = this.oldSinkConfigMap.get(logStoreId);
        if (null != sinkConfig) {
            log.info("[listen tail] The task to stop:{}", (Object)this.gson.toJson((Object)sinkConfig.getLogtailConfigs()));
            List logTailConfigs = sinkConfig.getLogtailConfigs();
            for (LogtailConfig logTailConfig : logTailConfigs) {
                this.stopOldJobForTail(logTailConfig, sinkConfig);
            }
        }
        this.oldSinkConfigMap.remove(logStoreId);
    }

    private void stopOldJobForTail(LogtailConfig logTailConfig, SinkConfig sinkConfig) {
        log.info("[listen tail] needs to stop the old task,oldTail{},oldEsIndex:{}", (Object)this.gson.toJson((Object)logTailConfig), (Object)sinkConfig.getEsIndex());
        if (null != logTailConfig) {
            this.jobManager.stopJob(logTailConfig);
            this.oldLogTailConfigMap.remove(logTailConfig.getLogtailId());
        }
    }

    private void initNewJob(MilogSpaceData newMilogSpaceData) {
        this.stopOldJobsIfNeeded();
        log.info("Start all tasks to restart the current space\uff0cspaceData:{}", (Object)this.gson.toJson((Object)newMilogSpaceData));
        HashMap<Long, LogtailConfig> newLogTailConfigMap = new HashMap<Long, LogtailConfig>();
        HashMap<Long, SinkConfig> newSinkConfigMap = new HashMap<Long, SinkConfig>();
        List newSpaceConfig = newMilogSpaceData.getSpaceConfig();
        if (newSpaceConfig != null) {
            for (SinkConfig sinkConfig : newSpaceConfig) {
                List logTailConfigs = sinkConfig.getLogtailConfigs();
                if (logTailConfigs != null) {
                    for (LogtailConfig logTailConfig : logTailConfigs) {
                        if (null == logTailConfig) continue;
                        newLogTailConfigMap.put(logTailConfig.getLogtailId(), logTailConfig);
                        this.startTailPer(sinkConfig, logTailConfig, newMilogSpaceData.getMilogSpaceId());
                    }
                }
                newSinkConfigMap.put(sinkConfig.getLogstoreId(), sinkConfig);
            }
        }
        this.milogSpaceData = newMilogSpaceData;
        this.oldLogTailConfigMap = newLogTailConfigMap;
        this.oldSinkConfigMap = newSinkConfigMap;
    }

    private void stopOldJobsIfNeeded() {
        if (!this.oldLogTailConfigMap.isEmpty()) {
            for (LogtailConfig logtailConfig : this.oldLogTailConfigMap.values()) {
                this.jobManager.stopJob(logtailConfig);
            }
            this.oldLogTailConfigMap.clear();
        }
        if (!this.oldSinkConfigMap.isEmpty()) {
            for (SinkConfig sinkConfig : this.oldSinkConfigMap.values()) {
                this.stopOldJobsForStore(sinkConfig.getLogstoreId());
            }
            this.oldSinkConfigMap.clear();
        }
    }

    private void startTailPer(SinkConfig sinkConfig, LogtailConfig logTailConfig, Long logSpaceId) {
        if (null == logSpaceId || null == logTailConfig || null == logTailConfig.getLogtailId()) {
            log.error("logSpaceId or logTailConfig or logTailId is null,sinkConfig:{},logTailConfig:{},logSpaceId:{}", new Object[]{this.gson.toJson((Object)sinkConfig), this.gson.toJson((Object)logTailConfig), this.spaceId});
            return;
        }
        Boolean isStart = this.streamCommonExtension.preCheckTaskExecution(sinkConfig, logTailConfig, logSpaceId);
        if (!isStart.booleanValue()) {
            log.warn("preCheckTaskExecution error,preCheckTaskExecution is false,LogTailConfig:{}", (Object)this.gson.toJson((Object)logTailConfig));
            return;
        }
        log.info("\u3010Listen tail\u3011Initialize the new task, tail configuration:{},index:{},cluster information\uff1a{},spaceId:{}", new Object[]{this.gson.toJson((Object)logTailConfig), sinkConfig.getEsIndex(), this.gson.toJson((Object)sinkConfig.getEsInfo()), logSpaceId});
        this.jobManager.startJob(logTailConfig, sinkConfig, logSpaceId);
        this.oldLogTailConfigMap.put(logTailConfig.getLogtailId(), logTailConfig);
    }

    @NotNull
    private Listener getListener(final String dataId, final MilogSpaceData milogSpaceData) {
        return new Listener(){

            public Executor getExecutor() {
                return THREAD_POOL;
            }

            public void receiveConfigInfo(String dataValue) {
                try {
                    log.info("listen tail received a configuration request:{},a configuration that already exists:storeMap:{},tailMap:{}", new Object[]{dataValue, MilogConfigListener.this.gson.toJson(MilogConfigListener.this.oldSinkConfigMap), MilogConfigListener.this.gson.toJson(MilogConfigListener.this.oldLogTailConfigMap)});
                    if (StringUtils.isNotEmpty((String)dataValue) && !"null".equals(dataValue)) {
                        MilogSpaceData newMilogSpaceData = (MilogSpaceData)Constant.GSON.fromJson(dataValue = MilogConfigListener.this.streamCommonExtension.dataPreProcess(dataValue), MilogSpaceData.class);
                        if (null == newMilogSpaceData || CollectionUtils.isEmpty((Collection)newMilogSpaceData.getSpaceConfig())) {
                            log.warn("Listen tail received configuration error,dataId:{},spaceId:{}", (Object)dataId, (Object)milogSpaceData.getMilogSpaceId());
                            return;
                        }
                        MilogConfigListener.this.handleNacosConfigDataJob(newMilogSpaceData);
                    } else {
                        MilogConfigListener.this.stopAllJobClear();
                    }
                }
                catch (Exception e) {
                    log.error(String.format("listen tail error,dataId:%s", dataId), (Throwable)e);
                }
            }
        };
    }

    public void shutdown() {
        if (this.listener != null) {
            this.nacosConfig.removeListener(this.dataId, this.group, this.listener);
        }
    }

    public JobManager getJobManager() {
        return this.jobManager;
    }
}

