/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.client;

import com.xiaomi.data.push.client.Response;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultEventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientV4 {
    private static final Logger log = LoggerFactory.getLogger(HttpClientV4.class);
    private static final String VERSION = "0.0.1:2020-06-13";
    public final AttributeKey<String> id = AttributeKey.newInstance((String)"channel_id");
    private final ConcurrentHashMap<String, DefaultPromise<Response>> latchMap = new ConcurrentHashMap();
    private Bootstrap bootstrap;
    private Bootstrap httpsBootstrap;
    private SslContextBuilder sslContext;
    private AttributeKey<Boolean> ssl_key = AttributeKey.newInstance((String)"ssl");

    public HttpClientV4() {
        log.info("version:{}", (Object)VERSION);
        this.sslContext = SslContextBuilder.forClient();
        this.bootstrap = this.getBootstrap(false);
        this.httpsBootstrap = this.getBootstrap(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response get(String url, Map<String, String> headers, long timeout) {
        String channelId = "";
        try {
            URI uri = new URI(url);
            int port = this.port(uri);
            boolean ishttps = this.ishttps(uri);
            Channel channel = (ishttps ? this.httpsBootstrap : this.bootstrap).connect(uri.getHost(), port).sync().channel();
            DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, uri.getPath());
            httpRequest.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderNames.CONNECTION);
            httpRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)httpRequest.content().readableBytes());
            httpRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)uri.getHost());
            headers.entrySet().stream().forEach(it -> httpRequest.headers().set((String)it.getKey(), it.getValue()));
            channelId = channel.id().asLongText();
            channel.attr(this.id).set((Object)channelId);
            DefaultPromise promise = new DefaultPromise((EventExecutor)new DefaultEventLoop());
            this.latchMap.put(channelId, (DefaultPromise<Response>)promise);
            channel.writeAndFlush((Object)httpRequest);
            Response res = (Response)promise.get(timeout, TimeUnit.MILLISECONDS);
            channel.close();
            Response response = res;
            return response;
        }
        catch (Throwable ex) {
            Response response = new Response(500, ex.toString().getBytes());
            return response;
        }
        finally {
            this.latchMap.remove(channelId);
        }
    }

    private boolean ishttps(URI uri) {
        return uri.getScheme().toLowerCase().equals("https");
    }

    private int port(URI uri) {
        int port = uri.getPort();
        if (port == -1) {
            if (this.ishttps(uri)) {
                return 443;
            }
            return 80;
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response post(String url, String body, Map<String, String> headers, long timeout) {
        String channelId = "";
        try {
            URI uri = new URI(url);
            int port = this.port(uri);
            Channel channel = (this.ishttps(uri) ? this.httpsBootstrap : this.bootstrap).connect(uri.getHost(), port).sync().channel();
            ByteBuf buffer = Unpooled.wrappedBuffer((byte[])body.getBytes());
            DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, uri.getPath(), buffer);
            httpRequest.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderNames.CONNECTION);
            httpRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)body.length());
            httpRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)uri.getHost());
            headers.entrySet().stream().forEach(it -> httpRequest.headers().set((String)it.getKey(), it.getValue()));
            DefaultPromise promise = new DefaultPromise((EventExecutor)new DefaultEventLoop());
            channelId = channel.id().asLongText();
            channel.attr(this.id).set((Object)channelId);
            this.latchMap.put(channelId, (DefaultPromise<Response>)promise);
            channel.writeAndFlush((Object)httpRequest);
            Response res = (Response)promise.get(timeout, TimeUnit.MILLISECONDS);
            channel.close();
            Response response = res;
            return response;
        }
        catch (Throwable ex) {
            Response response = new Response(500, ex.getMessage().getBytes());
            return response;
        }
        finally {
            this.latchMap.remove(channelId);
        }
    }

    private Bootstrap getBootstrap(final boolean ssl) {
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)new NioEventLoopGroup(256))).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.SO_SNDBUF, (Object)65535)).option(ChannelOption.SO_RCVBUF, (Object)65535)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel socketChannel) throws SSLException {
                if (ssl) {
                    SSLEngine engine = HttpClientV4.this.sslContext.build().newEngine(socketChannel.alloc());
                    socketChannel.pipeline().addFirst("ssl", (ChannelHandler)new SslHandler(engine));
                }
                socketChannel.pipeline().addLast(new ChannelHandler[]{new HttpClientCodec()});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new HttpContentDecompressor()});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new HttpObjectAggregator(0x400000)});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new HttpClientMsgHandler()});
            }
        });
        return bootstrap;
    }

    private class HttpClientMsgHandler
    extends SimpleChannelInboundHandler<FullHttpResponse> {
        private HttpClientMsgHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse res) {
            DefaultPromise<Response> p;
            Attribute v = ctx.channel().attr(HttpClientV4.this.id);
            if (v.get() != null && null != (p = HttpClientV4.this.latchMap.get(v.get()))) {
                if (res.content() != null) {
                    byte[] data = new byte[res.content().readableBytes()];
                    res.content().getBytes(0, data);
                    p.setSuccess((Object)new Response(res.status().code(), data));
                } else {
                    int code = res.status().code();
                    Response httpRes = new Response(code, null);
                    p.setSuccess((Object)httpRes);
                }
            }
        }
    }
}

