/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.mvc.http2;

import com.xiaomi.youpin.docean.config.HttpServerConfig;
import com.xiaomi.youpin.docean.mvc.HttpHandlerRead;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.codec.http2.Http2StreamFrameToHttpObjectCodec;
import io.netty.util.AsciiString;

public class Http2UpgradeCodecFactory
implements HttpServerUpgradeHandler.UpgradeCodecFactory {
    private HttpServerConfig config;

    public Http2UpgradeCodecFactory(HttpServerConfig config) {
        this.config = config;
    }

    public HttpServerUpgradeHandler.UpgradeCodec newUpgradeCodec(CharSequence protocol) {
        if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
            return new Http2ServerUpgradeCodec(Http2FrameCodecBuilder.forServer().build(), new ChannelHandler[]{new Http2MultiplexHandler((ChannelHandler)new Http2MultiplexHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
                    ch.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<HttpObject>(){

                        protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
                            HttpHandlerRead.read(ctx, msg, Http2UpgradeCodecFactory.this.config);
                        }
                    }});
                }
            }))});
        }
        return null;
    }
}

