/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.RedisException;
import java.net.SocketAddress;

public class RedisConnectionException
extends RedisException {
    public RedisConnectionException(String msg) {
        super(msg);
    }

    public RedisConnectionException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public static RedisConnectionException create(SocketAddress remoteAddress, Throwable cause) {
        return RedisConnectionException.create(remoteAddress == null ? null : remoteAddress.toString(), cause);
    }

    public static RedisConnectionException create(String remoteAddress, Throwable cause) {
        if (remoteAddress == null) {
            if (cause instanceof RedisConnectionException) {
                return new RedisConnectionException(cause.getMessage(), cause.getCause());
            }
            return new RedisConnectionException(null, cause);
        }
        return new RedisConnectionException(String.format("Unable to connect to %s", remoteAddress), cause);
    }

    public static RedisConnectionException create(Throwable cause) {
        if (cause instanceof RedisConnectionException) {
            return new RedisConnectionException(cause.getMessage(), cause.getCause());
        }
        return new RedisConnectionException("Unable to connect", cause);
    }

    public static boolean isProtectedMode(String error) {
        return error != null && error.startsWith("DENIED");
    }
}

