/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.server;

import com.facebook.thrift.TByteArrayOutputStream;
import com.facebook.thrift.TException;
import com.facebook.thrift.TProcessor;
import com.facebook.thrift.TProcessorFactory;
import com.facebook.thrift.protocol.TBinaryProtocol;
import com.facebook.thrift.protocol.THeaderProtocol;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolFactory;
import com.facebook.thrift.server.TRpcConnectionContext;
import com.facebook.thrift.server.TServer;
import com.facebook.thrift.server.TThreadFactoryImpl;
import com.facebook.thrift.transport.TFramedTransport;
import com.facebook.thrift.transport.TIOStreamTransport;
import com.facebook.thrift.transport.TNonblockingServerTransport;
import com.facebook.thrift.transport.TNonblockingTransport;
import com.facebook.thrift.transport.TTransport;
import com.facebook.thrift.transport.TTransportException;
import com.facebook.thrift.utils.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class TNonblockingServer
extends TServer {
    private static final Logger LOGGER = Logger.getLogger(TNonblockingServer.class.getName());
    private static final int selectWaitTime_ = 500;
    private final ExecutorService tcpWorkerPool_;
    private volatile boolean stopped_ = true;
    private SelectThread selectThread_;
    private final long MAX_READ_BUFFER_BYTES;
    protected final Options options_;
    private final AtomicLong readBufferBytesAllocated = new AtomicLong(0L);

    public TNonblockingServer(TProcessor processor, TNonblockingServerTransport serverTransport) {
        this(new TProcessorFactory(processor), serverTransport);
    }

    public TNonblockingServer(TProcessorFactory processorFactory, TNonblockingServerTransport serverTransport) {
        this(processorFactory, serverTransport, new TFramedTransport.Factory(), new TFramedTransport.Factory(), (TProtocolFactory)new TBinaryProtocol.Factory(), (TProtocolFactory)new TBinaryProtocol.Factory());
    }

    public TNonblockingServer(TProcessor processor, TNonblockingServerTransport serverTransport, TProtocolFactory protocolFactory) {
        this(processor, serverTransport, new TFramedTransport.Factory(), new TFramedTransport.Factory(), protocolFactory, protocolFactory);
    }

    public TNonblockingServer(TProcessor processor, TNonblockingServerTransport serverTransport, TFramedTransport.Factory transportFactory, TProtocolFactory protocolFactory) {
        this(processor, serverTransport, transportFactory, transportFactory, protocolFactory, protocolFactory);
    }

    public TNonblockingServer(TProcessorFactory processorFactory, TNonblockingServerTransport serverTransport, TFramedTransport.Factory transportFactory, TProtocolFactory protocolFactory) {
        this(processorFactory, serverTransport, transportFactory, transportFactory, protocolFactory, protocolFactory);
    }

    public TNonblockingServer(TProcessor processor, TNonblockingServerTransport serverTransport, TFramedTransport.Factory inputTransportFactory, TFramedTransport.Factory outputTransportFactory, TProtocolFactory inputProtocolFactory, TProtocolFactory outputProtocolFactory) {
        this(new TProcessorFactory(processor), serverTransport, inputTransportFactory, outputTransportFactory, inputProtocolFactory, outputProtocolFactory);
    }

    public TNonblockingServer(TProcessorFactory processorFactory, TNonblockingServerTransport serverTransport, TFramedTransport.Factory inputTransportFactory, TFramedTransport.Factory outputTransportFactory, TProtocolFactory inputProtocolFactory, TProtocolFactory outputProtocolFactory) {
        this(processorFactory, serverTransport, inputTransportFactory, outputTransportFactory, inputProtocolFactory, outputProtocolFactory, new Options());
    }

    public TNonblockingServer(TProcessorFactory processorFactory, TNonblockingServerTransport serverTransport, TFramedTransport.Factory inputTransportFactory, TFramedTransport.Factory outputTransportFactory, TProtocolFactory inputProtocolFactory, TProtocolFactory outputProtocolFactory, Options options) {
        super(processorFactory, serverTransport, inputTransportFactory, outputTransportFactory, inputProtocolFactory, outputProtocolFactory);
        this.options_ = options;
        this.options_.validate();
        this.MAX_READ_BUFFER_BYTES = options.maxReadBufferBytes;
        SynchronousQueue<Runnable> queue = this.options_.queueSize == 0 ? new SynchronousQueue() : new LinkedBlockingQueue(this.options_.queueSize);
        this.tcpWorkerPool_ = new ThreadPoolExecutor(this.options_.minWorkerThreads, this.options_.maxWorkerThreads, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, queue, new TThreadFactoryImpl("thrift-tcpworker"));
    }

    protected void submitTask(Runnable r) throws ServerOverloadedException {
        try {
            if (this.options_.forceSingleThreaded) {
                r.run();
            } else {
                this.tcpWorkerPool_.execute(r);
            }
        }
        catch (RejectedExecutionException e) {
            throw new ServerOverloadedException(e);
        }
    }

    @Override
    public void serve() {
        if (!this.startListening()) {
            return;
        }
        if (!this.startSelectorThread()) {
            return;
        }
        this.joinSelector();
        this.stopListening();
    }

    protected boolean startListening() {
        try {
            this.serverTransport_.listen();
            return true;
        }
        catch (TTransportException ttx) {
            LOGGER.error("Failed to start listening on server socket!", ttx);
            return false;
        }
    }

    protected void stopListening() {
        this.serverTransport_.close();
    }

    protected boolean startSelectorThread() {
        try {
            this.selectThread_ = new SelectThread((TNonblockingServerTransport)this.serverTransport_);
            this.stopped_ = false;
            this.selectThread_.start();
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Failed to start selector thread!", e);
            return false;
        }
    }

    protected void joinSelector() {
        try {
            this.selectThread_.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void stop() {
        this.stopped_ = true;
        if (this.selectThread_ != null) {
            this.selectThread_.wakeupSelector();
        }
    }

    protected long getReadBufferBytesAllocated() {
        return this.readBufferBytesAllocated.get();
    }

    protected void requestInvoke(FrameBuffer frameBuffer) throws ServerOverloadedException {
        frameBuffer.invoke();
    }

    public boolean isStopped() {
        return this.selectThread_.isStopped();
    }

    protected void requestCancellation(FrameBuffer frameBuffer) {
        this.selectThread_.requestCancellation(frameBuffer);
    }

    public static class Options {
        public int minWorkerThreads = 8;
        public int maxWorkerThreads = Integer.MAX_VALUE;
        public boolean forceSingleThreaded = false;
        public int queueSize = Integer.MAX_VALUE;
        public long timeout = 2000L;
        public long maxReadBufferBytes = Long.MAX_VALUE;

        public void validate() {
            if (this.maxReadBufferBytes <= 1024L) {
                throw new IllegalArgumentException("You must allocate at least 1KB to the read buffer.");
            }
        }
    }

    public static class ServerOverloadedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ServerOverloadedException() {
        }

        public ServerOverloadedException(Throwable th) {
            super(th);
        }
    }

    protected class FrameBuffer {
        private static final int READING_FRAME_SIZE = 1;
        private static final int READING_FRAME = 2;
        private static final int READ_FRAME_COMPLETE = 3;
        private static final int AWAITING_REGISTER_WRITE = 4;
        private static final int WRITING = 6;
        private static final int AWAITING_REGISTER_READ = 7;
        private static final int AWAITING_CLOSE = 8;
        private final long creationTime_ = System.currentTimeMillis();
        private final TNonblockingTransport trans_;
        private final SelectionKey selectionKey_;
        private int state_ = 1;
        private ByteBuffer buffer_;
        private TByteArrayOutputStream response_;

        public FrameBuffer(TNonblockingTransport trans, SelectionKey selectionKey) {
            this.trans_ = trans;
            this.selectionKey_ = selectionKey;
            this.buffer_ = ByteBuffer.allocate(4);
        }

        public boolean isValid() {
            long currentTime = System.currentTimeMillis();
            return currentTime - this.creationTime_ < TNonblockingServer.this.options_.timeout;
        }

        public synchronized boolean read() {
            if (this.state_ == 1) {
                if (!this.internalRead()) {
                    return false;
                }
                if (this.buffer_.remaining() == 0) {
                    int frameSize = this.buffer_.getInt(0);
                    if (frameSize <= 0) {
                        LOGGER.error("Read an invalid frame size of " + frameSize + ". Are you using TFramedTransport on the client side?");
                        return false;
                    }
                    int newBufferSize = frameSize + 4;
                    if ((long)newBufferSize > TNonblockingServer.this.MAX_READ_BUFFER_BYTES) {
                        LOGGER.error("Read a frame size of " + frameSize + ", which is bigger than the maximum allowable buffer size for ALL connections.");
                        return false;
                    }
                    if (TNonblockingServer.this.readBufferBytesAllocated.addAndGet(newBufferSize) > TNonblockingServer.this.MAX_READ_BUFFER_BYTES) {
                        TNonblockingServer.this.readBufferBytesAllocated.addAndGet(-newBufferSize);
                        return true;
                    }
                    this.buffer_ = ByteBuffer.allocate(newBufferSize);
                    this.buffer_.putInt(frameSize);
                    this.state_ = 2;
                } else {
                    return true;
                }
            }
            if (this.state_ == 2) {
                if (!this.internalRead()) {
                    return false;
                }
                if (this.buffer_.remaining() == 0) {
                    this.state_ = 3;
                }
                return true;
            }
            LOGGER.error("Read was called but state is invalid (" + this.state_ + ")");
            return false;
        }

        public synchronized boolean write() {
            if (this.state_ == 6) {
                try {
                    if (this.trans_.write(this.buffer_) < 0) {
                        return false;
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("Got an IOException during write!", e);
                    return false;
                }
                if (this.buffer_.remaining() == 0) {
                    this.state_ = 7;
                }
                return true;
            }
            LOGGER.error("Write was called, but state is invalid (" + this.state_ + ")");
            return false;
        }

        public synchronized void changeSelectInterests() {
            if (this.state_ == 4 || this.state_ == 6) {
                this.state_ = 6;
                this.selectionKey_.interestOps(4);
            } else if (this.state_ == 7) {
                this.buffer_ = ByteBuffer.allocate(4);
                this.state_ = 1;
                this.selectionKey_.interestOps(1);
            } else if (this.state_ == 8) {
                this.cancel();
            } else if (this.state_ == 1 || this.state_ == 2) {
                this.selectionKey_.interestOps(1);
            } else {
                LOGGER.error("changeSelectInterest was called, but state is invalid (" + this.state_ + ")");
            }
            if (Thread.currentThread() != TNonblockingServer.this.selectThread_) {
                TNonblockingServer.this.selectThread_.wakeupSelector();
            }
        }

        public synchronized void cancel() {
            this.close();
            this.selectionKey_.cancel();
        }

        public synchronized void close() {
            if (this.state_ == 2 || this.state_ == 3) {
                TNonblockingServer.this.readBufferBytesAllocated.addAndGet(-this.buffer_.capacity());
            }
            this.trans_.close();
        }

        public synchronized boolean isFrameFullyRead() {
            return this.state_ == 3;
        }

        private void responseReady() {
            TNonblockingServer.this.readBufferBytesAllocated.addAndGet(-this.buffer_.capacity());
            if (this.response_.len() == 0) {
                this.state_ = 7;
                this.buffer_ = null;
            } else {
                this.buffer_ = ByteBuffer.wrap(this.response_.get(), 0, this.response_.len());
                this.state_ = 4;
            }
            this.changeSelectInterests();
        }

        public synchronized void invoke() {
            TProtocol outProt;
            TProtocol inProt;
            TTransport inTrans;
            if (TNonblockingServer.this.inputProtocolFactory_ instanceof THeaderProtocol.Factory) {
                inTrans = this.getInputOutputTransport();
                outProt = inProt = TNonblockingServer.this.inputProtocolFactory_.getProtocol(inTrans);
            } else {
                inTrans = this.getInputTransport();
                inProt = TNonblockingServer.this.inputProtocolFactory_.getProtocol(inTrans);
                outProt = TNonblockingServer.this.outputProtocolFactory_.getProtocol(this.getOutputTransport());
            }
            try {
                TRpcConnectionContext server_ctx = new TRpcConnectionContext(this.trans_, inProt, outProt);
                TNonblockingServer.this.processorFactory_.getProcessor(inTrans).process(inProt, outProt, server_ctx);
                this.responseReady();
                return;
            }
            catch (TException te) {
                LOGGER.warn("Exception while invoking!", te);
            }
            catch (Exception e) {
                LOGGER.error("Unexpected exception while invoking!", e);
            }
            TNonblockingServer.this.readBufferBytesAllocated.addAndGet(-this.buffer_.capacity());
            this.buffer_ = null;
            this.state_ = 8;
            this.changeSelectInterests();
        }

        public synchronized TTransport getInputTransport() {
            return TNonblockingServer.this.inputTransportFactory_.getTransport(new TIOStreamTransport(new ByteArrayInputStream(this.buffer_.array())));
        }

        private TTransport getOutputTransport() {
            this.response_ = new TByteArrayOutputStream();
            return TNonblockingServer.this.outputTransportFactory_.getTransport(new TIOStreamTransport(this.response_));
        }

        private TTransport getInputOutputTransport() {
            this.response_ = new TByteArrayOutputStream();
            return TNonblockingServer.this.inputTransportFactory_.getTransport(new TIOStreamTransport(new ByteArrayInputStream(this.buffer_.array()), this.response_));
        }

        private boolean internalRead() {
            try {
                return this.trans_.read(this.buffer_) >= 0;
            }
            catch (IOException e) {
                LOGGER.warn("Got an IOException in internalRead!", e);
                return false;
            }
        }
    }

    protected class SelectThread
    extends Thread {
        private static final String name_ = "Thrift-Selector";
        private final TNonblockingServerTransport serverTransport;
        private final Selector selector;
        private final Set<FrameBuffer> cancellations;

        public SelectThread(TNonblockingServerTransport serverTransport) throws IOException {
            super(name_);
            this.cancellations = new HashSet<FrameBuffer>();
            this.serverTransport = serverTransport;
            this.selector = SelectorProvider.provider().openSelector();
            serverTransport.registerSelector(this.selector);
        }

        public boolean isStopped() {
            return TNonblockingServer.this.stopped_;
        }

        @Override
        public void run() {
            while (!TNonblockingServer.this.stopped_) {
                this.select();
                this.processCancellations();
            }
        }

        public void wakeupSelector() {
            this.selector.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestCancellation(FrameBuffer frameBuffer) {
            Set<FrameBuffer> set = this.cancellations;
            synchronized (set) {
                this.cancellations.add(frameBuffer);
            }
            this.selector.wakeup();
        }

        private void select() {
            try {
                this.selector.select(500L);
                Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
                while (!TNonblockingServer.this.stopped_ && selectedKeys.hasNext()) {
                    SelectionKey key = selectedKeys.next();
                    selectedKeys.remove();
                    if (!key.isValid()) {
                        this.cleanupSelectionkey(key);
                        continue;
                    }
                    if (key.isAcceptable()) {
                        this.handleAccept();
                        continue;
                    }
                    if (key.isReadable()) {
                        key.interestOps(0);
                        TcpReader readHandler = new TcpReader(key);
                        try {
                            TNonblockingServer.this.submitTask(readHandler);
                        }
                        catch (ServerOverloadedException e) {
                            this.cleanupSelectionkey(key);
                        }
                        continue;
                    }
                    if (key.isWritable()) {
                        key.interestOps(0);
                        TcpWriter writeHandler = new TcpWriter(key);
                        try {
                            TNonblockingServer.this.submitTask(writeHandler);
                        }
                        catch (ServerOverloadedException e) {
                            this.cleanupSelectionkey(key);
                        }
                        continue;
                    }
                    LOGGER.warn("Unexpected state in select! " + key.interestOps());
                }
            }
            catch (IOException e) {
                LOGGER.warn("Got an IOException while selecting!", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processCancellations() {
            Set<FrameBuffer> set = this.cancellations;
            synchronized (set) {
                for (FrameBuffer fb : this.cancellations) {
                    fb.cancel();
                }
                this.cancellations.clear();
            }
        }

        private void handleAccept() throws IOException {
            TNonblockingTransport client = null;
            try {
                client = (TNonblockingTransport)this.serverTransport.accept();
            }
            catch (TTransportException tte) {
                LOGGER.warn("Exception trying to accept!", tte);
                return;
            }
            SelectionKey clientKey = client.registerSelector(this.selector, 1);
            FrameBuffer frameBuffer = new FrameBuffer(client, clientKey);
            clientKey.attach(frameBuffer);
        }

        private void handleRead(SelectionKey key) {
            FrameBuffer buffer = (FrameBuffer)key.attachment();
            if (buffer.read()) {
                if (buffer.isFrameFullyRead()) {
                    try {
                        TNonblockingServer.this.requestInvoke(buffer);
                    }
                    catch (ServerOverloadedException e) {
                        TNonblockingServer.this.requestCancellation(buffer);
                    }
                } else {
                    buffer.changeSelectInterests();
                }
            } else {
                TNonblockingServer.this.requestCancellation(buffer);
            }
        }

        private void handleWrite(SelectionKey key) {
            FrameBuffer buffer = (FrameBuffer)key.attachment();
            if (buffer.write()) {
                buffer.changeSelectInterests();
            } else {
                TNonblockingServer.this.requestCancellation(buffer);
            }
        }

        private void cleanupSelectionkey(SelectionKey key) {
            FrameBuffer buffer = (FrameBuffer)key.attachment();
            if (buffer != null) {
                buffer.close();
            }
            key.cancel();
        }

        private class TcpWriter
        extends TcpHandler {
            TcpWriter(SelectionKey sKey) {
                super(sKey);
            }

            @Override
            public void run() {
                SelectThread.this.handleWrite(this.sKey_);
            }
        }

        private class TcpReader
        extends TcpHandler {
            TcpReader(SelectionKey sKey) {
                super(sKey);
            }

            @Override
            public void run() {
                SelectThread.this.handleRead(this.sKey_);
            }
        }

        private abstract class TcpHandler
        implements Runnable {
            protected final SelectionKey sKey_;

            TcpHandler(SelectionKey sKey) {
                this.sKey_ = sKey;
            }
        }
    }
}

