/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.paimon.compression.CompressOptions;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.disk.RowBuffer;
import org.apache.paimon.io.BundleRecords;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.RollingFileWriter;
import org.apache.paimon.memory.MemorySegmentPool;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.IOUtils;

public interface SinkWriter<T> {
    public boolean write(T var1) throws IOException;

    public List<DataFileMeta> flush() throws IOException;

    public boolean flushMemory() throws IOException;

    public long memoryOccupancy();

    public void close();

    public void setMemoryPool(MemorySegmentPool var1);

    public boolean bufferSpillableWriter();

    public static class BufferedSinkWriter<T>
    implements SinkWriter<T> {
        private final Supplier<RollingFileWriter<T, DataFileMeta>> writerSupplier;
        private final Function<T, InternalRow> toRow;
        private final Function<InternalRow, T> fromRow;
        private final IOManager ioManager;
        private final RowType rowType;
        private final boolean spillable;
        private final MemorySize maxDiskSize;
        private final CompressOptions compression;
        private RowBuffer writeBuffer;

        public BufferedSinkWriter(Supplier<RollingFileWriter<T, DataFileMeta>> writerSupplier, Function<T, InternalRow> toRow, Function<InternalRow, T> fromRow, IOManager ioManager, RowType rowType, boolean spillable, MemorySize maxDiskSize, CompressOptions compression) {
            this.writerSupplier = writerSupplier;
            this.toRow = toRow;
            this.fromRow = fromRow;
            this.ioManager = ioManager;
            this.rowType = rowType;
            this.spillable = spillable;
            this.maxDiskSize = maxDiskSize;
            this.compression = compression;
        }

        public RowBuffer rowBuffer() {
            return this.writeBuffer;
        }

        @Override
        public boolean write(T data) throws IOException {
            return this.writeBuffer.put(this.toRow.apply(data));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<DataFileMeta> flush() throws IOException {
            ArrayList<DataFileMeta> flushedFiles = new ArrayList<DataFileMeta>();
            if (this.writeBuffer != null) {
                this.writeBuffer.complete();
                RollingFileWriter<T, DataFileMeta> writer = this.writerSupplier.get();
                IOException exception = null;
                try (RowBuffer.RowBufferIterator iterator2 = this.writeBuffer.newIterator();){
                    while (iterator2.advanceNext()) {
                        writer.write(this.fromRow.apply(iterator2.getRow()));
                    }
                }
                catch (IOException e) {
                    exception = e;
                }
                finally {
                    if (exception != null) {
                        IOUtils.closeQuietly(writer);
                        throw exception;
                    }
                    writer.close();
                }
                flushedFiles.addAll((Collection<DataFileMeta>)writer.result());
                this.writeBuffer.reset();
            }
            return flushedFiles;
        }

        @Override
        public long memoryOccupancy() {
            return this.writeBuffer.memoryOccupancy();
        }

        @Override
        public void close() {
            if (this.writeBuffer != null) {
                this.writeBuffer.reset();
                this.writeBuffer = null;
            }
        }

        @Override
        public void setMemoryPool(MemorySegmentPool memoryPool) {
            this.writeBuffer = RowBuffer.getBuffer(this.ioManager, memoryPool, new InternalRowSerializer(this.rowType), this.spillable, this.maxDiskSize, this.compression);
        }

        @Override
        public boolean bufferSpillableWriter() {
            return this.spillable;
        }

        @Override
        public boolean flushMemory() throws IOException {
            return this.writeBuffer.flushMemory();
        }
    }

    public static class DirectSinkWriter<T>
    implements SinkWriter<T> {
        private final Supplier<RollingFileWriter<T, DataFileMeta>> writerSupplier;
        private RollingFileWriter<T, DataFileMeta> writer;

        public DirectSinkWriter(Supplier<RollingFileWriter<T, DataFileMeta>> writerSupplier) {
            this.writerSupplier = writerSupplier;
        }

        @Override
        public boolean write(T data) throws IOException {
            if (this.writer == null) {
                this.writer = this.writerSupplier.get();
            }
            this.writer.write(data);
            return true;
        }

        public void writeBundle(BundleRecords bundle) throws IOException {
            if (this.writer == null) {
                this.writer = this.writerSupplier.get();
            }
            this.writer.writeBundle(bundle);
        }

        @Override
        public List<DataFileMeta> flush() throws IOException {
            ArrayList<DataFileMeta> flushedFiles = new ArrayList<DataFileMeta>();
            if (this.writer != null) {
                this.writer.close();
                flushedFiles.addAll((Collection<DataFileMeta>)this.writer.result());
                this.writer = null;
            }
            return flushedFiles;
        }

        @Override
        public boolean flushMemory() throws IOException {
            return false;
        }

        @Override
        public long memoryOccupancy() {
            return 0L;
        }

        @Override
        public void close() {
            if (this.writer != null) {
                this.writer.abort();
                this.writer = null;
            }
        }

        @Override
        public void setMemoryPool(MemorySegmentPool memoryPool) {
        }

        @Override
        public boolean bufferSpillableWriter() {
            return false;
        }
    }
}

