/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import java.io.FileNotFoundException;
import org.apache.paimon.Snapshot;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.snapshot.ReadPlanStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;

public class StaticFromSnapshotStartingScanner
extends ReadPlanStartingScanner {
    public StaticFromSnapshotStartingScanner(SnapshotManager snapshotManager, long snapshotId) {
        super(snapshotManager);
        this.startingSnapshotId = snapshotId;
    }

    @Override
    public ScanMode startingScanMode() {
        return ScanMode.ALL;
    }

    @Override
    public SnapshotReader configure(SnapshotReader snapshotReader) {
        return snapshotReader.withMode(ScanMode.ALL).withSnapshot(this.getSnapshot());
    }

    public Snapshot getSnapshot() {
        try {
            return this.snapshotManager.tryGetSnapshot(this.startingSnapshotId);
        }
        catch (FileNotFoundException e) {
            Long earliestSnapshotId = this.snapshotManager.earliestSnapshotId();
            Long latestSnapshotId = this.snapshotManager.latestSnapshotId();
            if (earliestSnapshotId == null || latestSnapshotId == null) {
                throw new IllegalArgumentException("There is currently no snapshot.");
            }
            Preconditions.checkArgument(this.startingSnapshotId >= earliestSnapshotId && this.startingSnapshotId <= latestSnapshotId, "The specified scan snapshotId %s is out of available snapshotId range [%s, %s].", this.startingSnapshotId, earliestSnapshotId, latestSnapshotId);
            throw new RuntimeException(e);
        }
    }
}

