/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.parquet.net.openhft.hashing;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.paimon.shade.parquet.net.openhft.hashing.ByteBufferAccess;
import org.apache.paimon.shade.parquet.net.openhft.hashing.CharSequenceAccess;
import org.apache.paimon.shade.parquet.net.openhft.hashing.UnsafeAccess;

public abstract class Access<T> {
    public static <T> Access<T> unsafe() {
        return UnsafeAccess.INSTANCE;
    }

    public static Access<ByteBuffer> toByteBuffer() {
        return ByteBufferAccess.INSTANCE;
    }

    public static <T extends CharSequence> Access<T> toNativeCharSequence() {
        return CharSequenceAccess.nativeCharSequenceAccess();
    }

    public static <T extends CharSequence> Access<T> toCharSequence(ByteOrder backingOrder) {
        return CharSequenceAccess.charSequenceAccess(backingOrder);
    }

    protected Access() {
    }

    public long getLong(T input, long offset) {
        if (this.byteOrder(input) == ByteOrder.LITTLE_ENDIAN) {
            return this.getUnsignedInt(input, offset) | this.getUnsignedInt(input, offset + 4L) << 32;
        }
        return this.getUnsignedInt(input, offset + 4L) | this.getUnsignedInt(input, offset) << 32;
    }

    public long getUnsignedInt(T input, long offset) {
        return (long)this.getInt(input, offset) & 0xFFFFFFFFL;
    }

    public int getInt(T input, long offset) {
        if (this.byteOrder(input) == ByteOrder.LITTLE_ENDIAN) {
            return this.getUnsignedShort(input, offset) | this.getUnsignedShort(input, offset + 2L) << 16;
        }
        return this.getUnsignedShort(input, offset + 2L) | this.getUnsignedShort(input, offset) << 16;
    }

    public int getUnsignedShort(T input, long offset) {
        if (this.byteOrder(input) == ByteOrder.LITTLE_ENDIAN) {
            return this.getUnsignedByte(input, offset) | this.getUnsignedByte(input, offset + 1L) << 8;
        }
        return this.getUnsignedByte(input, offset + 1L) | this.getUnsignedByte(input, offset) << 8;
    }

    public int getShort(T input, long offset) {
        return (short)this.getUnsignedShort(input, offset);
    }

    public int getUnsignedByte(T input, long offset) {
        return this.getByte(input, offset) & 0xFF;
    }

    public abstract int getByte(T var1, long var2);

    public long i64(T input, long offset) {
        return this.getLong(input, offset);
    }

    public long u32(T input, long offset) {
        return this.getUnsignedInt(input, offset);
    }

    public int i32(T input, long offset) {
        return this.getInt(input, offset);
    }

    public int u16(T input, long offset) {
        return this.getUnsignedShort(input, offset);
    }

    public int i16(T input, long offset) {
        return this.getShort(input, offset);
    }

    public int u8(T input, long offset) {
        return this.getUnsignedByte(input, offset);
    }

    public int i8(T input, long offset) {
        return this.getByte(input, offset);
    }

    public abstract ByteOrder byteOrder(T var1);

    public Access<T> byteOrder(T input, ByteOrder byteOrder) {
        return this.byteOrder(input) == byteOrder ? this : this.reverseAccess();
    }

    protected abstract Access<T> reverseAccess();

    static <T> Access<T> newDefaultReverseAccess(Access<T> access) {
        return access instanceof ReverseAccess ? access.reverseAccess() : new ReverseAccess(access);
    }

    private static class ReverseAccess<T>
    extends Access<T> {
        final Access<T> access;

        private ReverseAccess(Access<T> access) {
            this.access = access;
        }

        @Override
        public long getLong(T input, long offset) {
            return Long.reverseBytes(this.access.getLong(input, offset));
        }

        @Override
        public long getUnsignedInt(T input, long offset) {
            return Long.reverseBytes(this.access.getUnsignedInt(input, offset)) >>> 32;
        }

        @Override
        public int getInt(T input, long offset) {
            return Integer.reverseBytes(this.access.getInt(input, offset));
        }

        @Override
        public int getUnsignedShort(T input, long offset) {
            return Integer.reverseBytes(this.access.getUnsignedShort(input, offset)) >>> 16;
        }

        @Override
        public int getShort(T input, long offset) {
            return Integer.reverseBytes(this.access.getShort(input, offset)) >> 16;
        }

        @Override
        public int getUnsignedByte(T input, long offset) {
            return this.access.getUnsignedByte(input, offset);
        }

        @Override
        public int getByte(T input, long offset) {
            return this.access.getByte(input, offset);
        }

        @Override
        public ByteOrder byteOrder(T input) {
            return ByteOrder.LITTLE_ENDIAN == this.access.byteOrder(input) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        }

        @Override
        protected Access<T> reverseAccess() {
            return this.access;
        }
    }
}

