/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.hadoop.hive.serde2.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Date;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;

public class DateWritable
implements WritableComparable<DateWritable> {
    private static final long MILLIS_PER_DAY = TimeUnit.DAYS.toMillis(1L);
    private static final ThreadLocal<TimeZone> LOCAL_TIMEZONE = new ThreadLocal<TimeZone>(){

        @Override
        protected TimeZone initialValue() {
            return Calendar.getInstance().getTimeZone();
        }
    };
    private static final ThreadLocal<Calendar> UTC_CALENDAR = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            return new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        }
    };
    private static final ThreadLocal<Calendar> LOCAL_CALENDAR = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            return Calendar.getInstance();
        }
    };
    private int daysSinceEpoch = 0;

    public DateWritable() {
    }

    public DateWritable(DateWritable d) {
        this.set(d);
    }

    public DateWritable(Date d) {
        this.set(d);
    }

    public DateWritable(int d) {
        this.set(d);
    }

    public void set(int d) {
        this.daysSinceEpoch = d;
    }

    public void set(Date d) {
        if (d == null) {
            this.daysSinceEpoch = 0;
            return;
        }
        this.set(DateWritable.dateToDays(d));
    }

    public void set(DateWritable d) {
        this.set(d.daysSinceEpoch);
    }

    public Date get() {
        return this.get(true);
    }

    public Date get(boolean doesTimeMatter) {
        return new Date(DateWritable.daysToMillis(this.daysSinceEpoch, doesTimeMatter));
    }

    public int getDays() {
        return this.daysSinceEpoch;
    }

    public long getTimeInSeconds() {
        return this.get().getTime() / 1000L;
    }

    public static Date timeToDate(long l) {
        return new Date(l * 1000L);
    }

    public static long daysToMillis(int d) {
        return DateWritable.daysToMillis(d, true);
    }

    public static long daysToMillis(int d, boolean doesTimeMatter) {
        long utcMidnight = (long)d * MILLIS_PER_DAY;
        long utcMidnightOffset = LOCAL_TIMEZONE.get().getOffset(utcMidnight);
        long hopefullyMidnight = utcMidnight - utcMidnightOffset;
        long offsetAtHM = LOCAL_TIMEZONE.get().getOffset(hopefullyMidnight);
        if (utcMidnightOffset == offsetAtHM) {
            return hopefullyMidnight;
        }
        if (!doesTimeMatter) {
            return DateWritable.daysToMillis(d + 1) - (MILLIS_PER_DAY >> 1);
        }
        Calendar utc = UTC_CALENDAR.get();
        Calendar local = LOCAL_CALENDAR.get();
        utc.setTimeInMillis(utcMidnight);
        local.set(utc.get(1), utc.get(2), utc.get(5));
        return local.getTimeInMillis();
    }

    public static int millisToDays(long millisLocal) {
        long millisUtc = millisLocal + (long)LOCAL_TIMEZONE.get().getOffset(millisLocal);
        int days = millisUtc >= 0L ? (int)(millisUtc / MILLIS_PER_DAY) : (int)((millisUtc - 86399999L) / MILLIS_PER_DAY);
        return days;
    }

    public static int dateToDays(Date d) {
        long millisLocal = d.getTime();
        return DateWritable.millisToDays(millisLocal);
    }

    public void readFields(DataInput in) throws IOException {
        this.daysSinceEpoch = WritableUtils.readVInt((DataInput)in);
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)this.daysSinceEpoch);
    }

    public int compareTo(DateWritable d) {
        return this.daysSinceEpoch - d.daysSinceEpoch;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DateWritable)) {
            return false;
        }
        return this.compareTo((DateWritable)o) == 0;
    }

    public String toString() {
        return this.get(false).toString();
    }

    public int hashCode() {
        return this.daysSinceEpoch;
    }
}

