/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.predicate;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.predicate.And;
import org.apache.paimon.predicate.CompoundPredicate;
import org.apache.paimon.predicate.Contains;
import org.apache.paimon.predicate.EndsWith;
import org.apache.paimon.predicate.Equal;
import org.apache.paimon.predicate.GreaterOrEqual;
import org.apache.paimon.predicate.GreaterThan;
import org.apache.paimon.predicate.In;
import org.apache.paimon.predicate.IsNotNull;
import org.apache.paimon.predicate.IsNull;
import org.apache.paimon.predicate.LeafPredicate;
import org.apache.paimon.predicate.LeafUnaryFunction;
import org.apache.paimon.predicate.LessOrEqual;
import org.apache.paimon.predicate.LessThan;
import org.apache.paimon.predicate.NotEqual;
import org.apache.paimon.predicate.NullFalseLeafBinaryFunction;
import org.apache.paimon.predicate.Or;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.StartsWith;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.InternalRowPartitionComputer;
import org.apache.paimon.utils.Preconditions;

@Public
public class PredicateBuilder {
    private final RowType rowType;
    private final List<String> fieldNames;

    public PredicateBuilder(RowType rowType) {
        this.rowType = rowType;
        this.fieldNames = rowType.getFieldNames();
    }

    public int indexOf(String field) {
        return this.fieldNames.indexOf(field);
    }

    public Predicate equal(int idx, Object literal) {
        return this.leaf(Equal.INSTANCE, idx, literal);
    }

    public Predicate notEqual(int idx, Object literal) {
        return this.leaf(NotEqual.INSTANCE, idx, literal);
    }

    public Predicate lessThan(int idx, Object literal) {
        return this.leaf(LessThan.INSTANCE, idx, literal);
    }

    public Predicate lessOrEqual(int idx, Object literal) {
        return this.leaf(LessOrEqual.INSTANCE, idx, literal);
    }

    public Predicate greaterThan(int idx, Object literal) {
        return this.leaf(GreaterThan.INSTANCE, idx, literal);
    }

    public Predicate greaterOrEqual(int idx, Object literal) {
        return this.leaf(GreaterOrEqual.INSTANCE, idx, literal);
    }

    public Predicate isNull(int idx) {
        return this.leaf(IsNull.INSTANCE, idx);
    }

    public Predicate isNotNull(int idx) {
        return this.leaf(IsNotNull.INSTANCE, idx);
    }

    public Predicate startsWith(int idx, Object patternLiteral) {
        return this.leaf(StartsWith.INSTANCE, idx, patternLiteral);
    }

    public Predicate endsWith(int idx, Object patternLiteral) {
        return this.leaf(EndsWith.INSTANCE, idx, patternLiteral);
    }

    public Predicate contains(int idx, Object patternLiteral) {
        return this.leaf(Contains.INSTANCE, idx, patternLiteral);
    }

    public Predicate leaf(NullFalseLeafBinaryFunction function, int idx, Object literal) {
        DataField field = this.rowType.getFields().get(idx);
        return new LeafPredicate(function, field.type(), idx, field.name(), Collections.singletonList(literal));
    }

    public Predicate leaf(LeafUnaryFunction function, int idx) {
        DataField field = this.rowType.getFields().get(idx);
        return new LeafPredicate(function, field.type(), idx, field.name(), Collections.emptyList());
    }

    public Predicate in(int idx, List<Object> literals) {
        if (literals.size() > 20) {
            DataField field = this.rowType.getFields().get(idx);
            return new LeafPredicate(In.INSTANCE, field.type(), idx, field.name(), literals);
        }
        ArrayList<Predicate> equals = new ArrayList<Predicate>(literals.size());
        for (Object literal : literals) {
            equals.add(this.equal(idx, literal));
        }
        return PredicateBuilder.or(equals);
    }

    public Predicate notIn(int idx, List<Object> literals) {
        return this.in(idx, literals).negate().get();
    }

    public Predicate between(int idx, Object includedLowerBound, Object includedUpperBound) {
        return new CompoundPredicate(And.INSTANCE, Arrays.asList(this.greaterOrEqual(idx, includedLowerBound), this.lessOrEqual(idx, includedUpperBound)));
    }

    public static Predicate and(Predicate ... predicates) {
        return PredicateBuilder.and(Arrays.asList(predicates));
    }

    public static Predicate and(List<Predicate> predicates) {
        Preconditions.checkArgument(predicates.size() > 0, "There must be at least 1 inner predicate to construct an AND predicate");
        if (predicates.size() == 1) {
            return predicates.get(0);
        }
        return (Predicate)predicates.stream().reduce((a, b) -> new CompoundPredicate(And.INSTANCE, Arrays.asList(a, b))).get();
    }

    @Nullable
    public static Predicate andNullable(Predicate ... predicates) {
        return PredicateBuilder.andNullable(Arrays.asList(predicates));
    }

    @Nullable
    public static Predicate andNullable(List<Predicate> predicates) {
        if ((predicates = predicates.stream().filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            return null;
        }
        return PredicateBuilder.and(predicates);
    }

    public static Predicate or(Predicate ... predicates) {
        return PredicateBuilder.or(Arrays.asList(predicates));
    }

    public static Predicate or(List<Predicate> predicates) {
        Preconditions.checkArgument(predicates.size() > 0, "There must be at least 1 inner predicate to construct an OR predicate");
        return (Predicate)predicates.stream().reduce((a, b) -> new CompoundPredicate(Or.INSTANCE, Arrays.asList(a, b))).get();
    }

    public static List<Predicate> splitAnd(@Nullable Predicate predicate) {
        if (predicate == null) {
            return Collections.emptyList();
        }
        ArrayList<Predicate> result = new ArrayList<Predicate>();
        PredicateBuilder.splitCompound(And.INSTANCE, predicate, result);
        return result;
    }

    public static List<Predicate> splitOr(@Nullable Predicate predicate) {
        if (predicate == null) {
            return Collections.emptyList();
        }
        ArrayList<Predicate> result = new ArrayList<Predicate>();
        PredicateBuilder.splitCompound(Or.INSTANCE, predicate, result);
        return result;
    }

    private static void splitCompound(CompoundPredicate.Function function, Predicate predicate, List<Predicate> result) {
        if (predicate instanceof CompoundPredicate && ((CompoundPredicate)predicate).function().equals(function)) {
            for (Predicate child : ((CompoundPredicate)predicate).children()) {
                PredicateBuilder.splitCompound(function, child, result);
            }
        } else {
            result.add(predicate);
        }
    }

    public static Object convertJavaObject(DataType literalType, Object o) {
        if (o == null) {
            return null;
        }
        switch (literalType.getTypeRoot()) {
            case BOOLEAN: {
                return o;
            }
            case BIGINT: {
                return ((Number)o).longValue();
            }
            case DOUBLE: {
                return ((Number)o).doubleValue();
            }
            case TINYINT: {
                return ((Number)o).byteValue();
            }
            case SMALLINT: {
                return ((Number)o).shortValue();
            }
            case INTEGER: {
                return ((Number)o).intValue();
            }
            case FLOAT: {
                return Float.valueOf(((Number)o).floatValue());
            }
            case CHAR: 
            case VARCHAR: {
                return BinaryString.fromString(o.toString());
            }
            case DATE: {
                LocalDate localDate;
                if (o instanceof Timestamp) {
                    localDate = ((Timestamp)o).toLocalDateTime().toLocalDate();
                } else if (o instanceof Date) {
                    localDate = ((Date)o).toLocalDate();
                } else if (o instanceof LocalDate) {
                    localDate = (LocalDate)o;
                } else {
                    throw new UnsupportedOperationException("Unexpected date literal of class " + o.getClass().getName());
                }
                LocalDate epochDay = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC).toLocalDate();
                return (int)ChronoUnit.DAYS.between(epochDay, localDate);
            }
            case TIME_WITHOUT_TIME_ZONE: {
                LocalTime localTime;
                if (o instanceof Time) {
                    localTime = ((Time)o).toLocalTime();
                } else if (o instanceof LocalTime) {
                    localTime = (LocalTime)o;
                } else {
                    throw new UnsupportedOperationException("Unexpected time literal of class " + o.getClass().getName());
                }
                return (int)(localTime.toNanoOfDay() / 1000000L);
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)literalType;
                int precision = decimalType.getPrecision();
                int scale = decimalType.getScale();
                return Decimal.fromBigDecimal((BigDecimal)o, precision, scale);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                if (o instanceof Timestamp) {
                    return org.apache.paimon.data.Timestamp.fromSQLTimestamp((Timestamp)o);
                }
                if (o instanceof Instant) {
                    Instant o1 = (Instant)o;
                    LocalDateTime dateTime = o1.atZone(ZoneId.systemDefault()).toLocalDateTime();
                    return org.apache.paimon.data.Timestamp.fromLocalDateTime(dateTime);
                }
                if (o instanceof LocalDateTime) {
                    return org.apache.paimon.data.Timestamp.fromLocalDateTime((LocalDateTime)o);
                }
                throw new UnsupportedOperationException(String.format("Unsupported class %s for timestamp without timezone ", o.getClass()));
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                if (o instanceof Timestamp) {
                    Timestamp timestamp = (Timestamp)o;
                    return org.apache.paimon.data.Timestamp.fromInstant(timestamp.toInstant());
                }
                if (o instanceof Instant) {
                    return org.apache.paimon.data.Timestamp.fromInstant((Instant)o);
                }
                throw new UnsupportedOperationException(String.format("Unsupported class %s for timestamp with local time zone ", o.getClass()));
            }
        }
        throw new UnsupportedOperationException("Unsupported predicate leaf type " + literalType.getTypeRoot().name());
    }

    public static List<Predicate> pickTransformFieldMapping(List<Predicate> predicates, List<String> inputFields, List<String> pickedFields) {
        return PredicateBuilder.pickTransformFieldMapping(predicates, inputFields.stream().mapToInt(pickedFields::indexOf).toArray());
    }

    public static List<Predicate> pickTransformFieldMapping(List<Predicate> predicates, int[] fieldIdxMapping) {
        ArrayList<Predicate> pick = new ArrayList<Predicate>();
        for (Predicate p : predicates) {
            Optional<Predicate> mapped = PredicateBuilder.transformFieldMapping(p, fieldIdxMapping);
            mapped.ifPresent(pick::add);
        }
        return pick;
    }

    public static Optional<Predicate> transformFieldMapping(Predicate predicate, int[] fieldIdxMapping) {
        if (predicate instanceof CompoundPredicate) {
            CompoundPredicate compoundPredicate = (CompoundPredicate)predicate;
            ArrayList<Predicate> children = new ArrayList<Predicate>();
            for (Predicate child : compoundPredicate.children()) {
                Optional<Predicate> mapped = PredicateBuilder.transformFieldMapping(child, fieldIdxMapping);
                if (mapped.isPresent()) {
                    children.add(mapped.get());
                    continue;
                }
                return Optional.empty();
            }
            return Optional.of(new CompoundPredicate(compoundPredicate.function(), children));
        }
        LeafPredicate leafPredicate = (LeafPredicate)predicate;
        int mapped = fieldIdxMapping[leafPredicate.index()];
        if (mapped >= 0) {
            return Optional.of(new LeafPredicate(leafPredicate.function(), leafPredicate.type(), mapped, leafPredicate.fieldName(), leafPredicate.literals()));
        }
        return Optional.empty();
    }

    public static boolean containsFields(Predicate predicate, Set<String> fields) {
        if (predicate instanceof CompoundPredicate) {
            for (Predicate child : ((CompoundPredicate)predicate).children()) {
                if (!PredicateBuilder.containsFields(child, fields)) continue;
                return true;
            }
            return false;
        }
        LeafPredicate leafPredicate = (LeafPredicate)predicate;
        return fields.contains(leafPredicate.fieldName());
    }

    public static List<Predicate> excludePredicateWithFields(@Nullable List<Predicate> predicates, Set<String> fields) {
        if (predicates == null || predicates.isEmpty() || fields.isEmpty()) {
            return predicates;
        }
        return predicates.stream().filter(f -> !PredicateBuilder.containsFields(f, fields)).collect(Collectors.toList());
    }

    @Nullable
    public static Predicate partition(Map<String, String> map, RowType rowType, String defaultPartValue) {
        Map<String, Object> internalValues = InternalRowPartitionComputer.convertSpecToInternal(map, rowType, defaultPartValue);
        List<String> fieldNames = rowType.getFieldNames();
        Predicate predicate = null;
        PredicateBuilder builder = new PredicateBuilder(rowType);
        for (Map.Entry<String, Object> entry : internalValues.entrySet()) {
            Predicate predicateTemp;
            int idx = fieldNames.indexOf(entry.getKey());
            Object literal = internalValues.get(entry.getKey());
            Predicate predicate2 = predicateTemp = literal == null ? builder.isNull(idx) : builder.equal(idx, literal);
            if (predicate == null) {
                predicate = predicateTemp;
                continue;
            }
            predicate = PredicateBuilder.and(predicate, predicateTemp);
        }
        return predicate;
    }

    public static Predicate partitions(List<Map<String, String>> partitions, RowType rowType, String defaultPartValue) {
        return PredicateBuilder.or((Predicate[])partitions.stream().map(p -> PredicateBuilder.partition(p, rowType, defaultPartValue)).toArray(Predicate[]::new));
    }
}

