/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.partition.actions;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.paimon.fs.Path;
import org.apache.paimon.partition.actions.PartitionMarkDoneAction;
import org.apache.paimon.table.PartitionHandler;
import org.apache.paimon.utils.PartitionPathUtils;

public class MarkPartitionDoneEventAction
implements PartitionMarkDoneAction {
    private final PartitionHandler partitionHandler;

    public MarkPartitionDoneEventAction(PartitionHandler partitionHandler) {
        this.partitionHandler = partitionHandler;
    }

    @Override
    public void markDone(String partition) throws Exception {
        LinkedHashMap<String, String> partitionSpec = PartitionPathUtils.extractPartitionSpecFromPath(new Path(partition));
        this.partitionHandler.markDonePartitions(Collections.singletonList(partitionSpec));
    }

    @Override
    public void close() throws IOException {
        try {
            this.partitionHandler.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

