/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.ManifestEntry;

public class CommitStats {
    private final long duration;
    private final int attempts;
    private final long tableFilesAdded;
    private final long tableFilesAppended;
    private final long tableFilesDeleted;
    private final long changelogFilesAppended;
    private final long compactionInputFileSize;
    private final long compactionOutputFileSize;
    private final long changelogFilesCompacted;
    private final long changelogRecordsCompacted;
    private final long deltaRecordsCompacted;
    private final long changelogRecordsAppended;
    private final long deltaRecordsAppended;
    private final long tableFilesCompacted;
    private final long generatedSnapshots;
    private final long numPartitionsWritten;
    private final long numBucketsWritten;

    public CommitStats(List<ManifestEntry> appendTableFiles, List<ManifestEntry> appendChangelogFiles, List<ManifestEntry> compactTableFiles, List<ManifestEntry> compactChangelogFiles, long commitDuration, int generatedSnapshots, int attempts) {
        ArrayList<ManifestEntry> addedTableFiles = new ArrayList<ManifestEntry>(appendTableFiles);
        List compactAfterFiles = compactTableFiles.stream().filter(f -> FileKind.ADD.equals((Object)f.kind())).collect(Collectors.toList());
        addedTableFiles.addAll(compactAfterFiles);
        List deletedTableFiles = compactTableFiles.stream().filter(f -> FileKind.DELETE.equals((Object)f.kind())).collect(Collectors.toList());
        this.compactionInputFileSize = deletedTableFiles.stream().map(ManifestEntry::file).map(DataFileMeta::fileSize).reduce(Long::sum).orElse(0L);
        this.compactionOutputFileSize = compactAfterFiles.stream().map(ManifestEntry::file).map(DataFileMeta::fileSize).reduce(Long::sum).orElse(0L);
        this.tableFilesAdded = addedTableFiles.size();
        this.tableFilesAppended = appendTableFiles.size();
        this.tableFilesDeleted = deletedTableFiles.size();
        this.tableFilesCompacted = compactTableFiles.size();
        this.changelogFilesAppended = appendChangelogFiles.size();
        this.changelogFilesCompacted = compactChangelogFiles.size();
        this.numPartitionsWritten = CommitStats.numChangedPartitions(appendTableFiles, compactTableFiles);
        this.numBucketsWritten = CommitStats.numChangedBuckets(appendTableFiles, compactTableFiles);
        this.changelogRecordsCompacted = this.getRowCounts(compactChangelogFiles);
        this.deltaRecordsCompacted = this.getRowCounts(compactTableFiles);
        this.changelogRecordsAppended = this.getRowCounts(appendChangelogFiles);
        this.deltaRecordsAppended = this.getRowCounts(appendTableFiles);
        this.duration = commitDuration;
        this.generatedSnapshots = generatedSnapshots;
        this.attempts = attempts;
    }

    @VisibleForTesting
    protected static long numChangedPartitions(List<ManifestEntry> ... changes) {
        return Arrays.stream(changes).flatMap(Collection::stream).map(ManifestEntry::partition).distinct().count();
    }

    @VisibleForTesting
    protected static long numChangedBuckets(List<ManifestEntry> ... changes) {
        return CommitStats.changedPartBuckets(changes).values().stream().mapToLong(Set::size).sum();
    }

    @VisibleForTesting
    protected static List<BinaryRow> changedPartitions(List<ManifestEntry> ... changes) {
        return Arrays.stream(changes).flatMap(Collection::stream).map(ManifestEntry::partition).distinct().collect(Collectors.toList());
    }

    @VisibleForTesting
    protected static Map<BinaryRow, Set<Integer>> changedPartBuckets(List<ManifestEntry> ... changes) {
        LinkedHashMap<BinaryRow, Set<Integer>> changedPartBuckets = new LinkedHashMap<BinaryRow, Set<Integer>>();
        Arrays.stream(changes).flatMap(Collection::stream).forEach(entry -> changedPartBuckets.computeIfAbsent(entry.partition(), k -> new LinkedHashSet()).add(entry.bucket()));
        return changedPartBuckets;
    }

    private long getRowCounts(List<ManifestEntry> files) {
        return files.stream().mapToLong(file -> file.file().rowCount()).sum();
    }

    @VisibleForTesting
    protected long getTableFilesAdded() {
        return this.tableFilesAdded;
    }

    @VisibleForTesting
    protected long getTableFilesDeleted() {
        return this.tableFilesDeleted;
    }

    @VisibleForTesting
    protected long getTableFilesAppended() {
        return this.tableFilesAppended;
    }

    @VisibleForTesting
    protected long getTableFilesCompacted() {
        return this.tableFilesCompacted;
    }

    @VisibleForTesting
    protected long getChangelogFilesAppended() {
        return this.changelogFilesAppended;
    }

    @VisibleForTesting
    protected long getChangelogFilesCompacted() {
        return this.changelogFilesCompacted;
    }

    @VisibleForTesting
    protected long getGeneratedSnapshots() {
        return this.generatedSnapshots;
    }

    @VisibleForTesting
    protected long getDeltaRecordsAppended() {
        return this.deltaRecordsAppended;
    }

    @VisibleForTesting
    protected long getChangelogRecordsAppended() {
        return this.changelogRecordsAppended;
    }

    @VisibleForTesting
    protected long getDeltaRecordsCompacted() {
        return this.deltaRecordsCompacted;
    }

    @VisibleForTesting
    protected long getChangelogRecordsCompacted() {
        return this.changelogRecordsCompacted;
    }

    @VisibleForTesting
    protected long getNumPartitionsWritten() {
        return this.numPartitionsWritten;
    }

    @VisibleForTesting
    protected long getNumBucketsWritten() {
        return this.numBucketsWritten;
    }

    @VisibleForTesting
    protected long getDuration() {
        return this.duration;
    }

    @VisibleForTesting
    protected int getAttempts() {
        return this.attempts;
    }

    public long getCompactionInputFileSize() {
        return this.compactionInputFileSize;
    }

    public long getCompactionOutputFileSize() {
        return this.compactionOutputFileSize;
    }
}

