/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.concurrent.Callable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.catalog.CatalogLock;
import org.apache.paimon.catalog.Identifier;

@Public
public interface Lock
extends AutoCloseable {
    public <T> T runWithLock(Callable<T> var1) throws Exception;

    public static Lock empty() {
        return new EmptyLock();
    }

    public static Lock fromCatalog(CatalogLock lock, Identifier tablePath) {
        if (lock == null) {
            return new EmptyLock();
        }
        return new CatalogLockImpl(lock, tablePath);
    }

    public static class CatalogLockImpl
    implements Lock {
        private final CatalogLock catalogLock;
        private final Identifier tablePath;

        private CatalogLockImpl(CatalogLock catalogLock, Identifier tablePath) {
            this.catalogLock = catalogLock;
            this.tablePath = tablePath;
        }

        @Override
        public <T> T runWithLock(Callable<T> callable) throws Exception {
            return this.catalogLock.runWithLock(this.tablePath.getDatabaseName(), this.tablePath.getObjectName(), callable);
        }

        @Override
        public void close() throws Exception {
            this.catalogLock.close();
        }
    }

    public static class EmptyLock
    implements Lock {
        @Override
        public <T> T runWithLock(Callable<T> callable) throws Exception {
            return callable.call();
        }

        @Override
        public void close() {
        }
    }
}

