/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io.cache;

import org.apache.paimon.io.cache.Cache;
import org.apache.paimon.io.cache.CacheKey;
import org.apache.paimon.io.cache.CaffeineCache;
import org.apache.paimon.io.cache.GuavaCache;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.RemovalCause;
import org.apache.paimon.shade.guava30.com.google.common.cache.RemovalNotification;

public abstract class CacheBuilder {
    protected MemorySize memorySize;

    CacheBuilder maximumWeight(MemorySize memorySize) {
        this.memorySize = memorySize;
        return this;
    }

    public abstract Cache build();

    public static CacheBuilder newBuilder(Cache.CacheType type) {
        switch (type) {
            case CAFFEINE: {
                return new CaffeineCacheBuilder();
            }
            case GUAVA: {
                return new GuavaCacheBuilder();
            }
        }
        throw new UnsupportedOperationException("Unsupported CacheType: " + (Object)((Object)type));
    }

    private static int weigh(CacheKey cacheKey, Cache.CacheValue cacheValue) {
        return cacheValue.segment.size();
    }

    static class GuavaCacheBuilder
    extends CacheBuilder {
        GuavaCacheBuilder() {
        }

        @Override
        public Cache build() {
            return new GuavaCache(org.apache.paimon.shade.guava30.com.google.common.cache.CacheBuilder.newBuilder().weigher((x$0, x$1) -> CacheBuilder.weigh(x$0, x$1)).concurrencyLevel(1).maximumWeight(this.memorySize.getBytes()).removalListener(this::onRemoval).build());
        }

        private void onRemoval(RemovalNotification<CacheKey, Cache.CacheValue> notification) {
            if (notification.getValue() != null) {
                ((Cache.CacheValue)notification.getValue()).callback.onRemoval((CacheKey)notification.getKey());
            }
        }
    }

    static class CaffeineCacheBuilder
    extends CacheBuilder {
        CaffeineCacheBuilder() {
        }

        @Override
        public Cache build() {
            return new CaffeineCache(Caffeine.newBuilder().weigher((x$0, x$1) -> CacheBuilder.weigh(x$0, x$1)).maximumWeight(this.memorySize.getBytes()).removalListener(this::onRemoval).executor(Runnable::run).build());
        }

        private void onRemoval(CacheKey key, Cache.CacheValue value, RemovalCause cause) {
            if (value != null) {
                value.callback.onRemoval(key);
            }
        }
    }
}

