/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Timestamp;
import org.apache.paimon.data.columnar.Dictionary;
import org.apache.paimon.format.parquet.writer.ParquetRowDataWriter;
import org.apache.paimon.shade.org.apache.parquet.io.api.Binary;
import org.apache.paimon.utils.Preconditions;

public final class ParquetDictionary
implements Dictionary {
    private final org.apache.paimon.shade.org.apache.parquet.column.Dictionary dictionary;

    public ParquetDictionary(org.apache.paimon.shade.org.apache.parquet.column.Dictionary dictionary) {
        this.dictionary = dictionary;
    }

    @Override
    public int decodeToInt(int id) {
        return this.dictionary.decodeToInt(id);
    }

    @Override
    public long decodeToLong(int id) {
        return this.dictionary.decodeToLong(id);
    }

    @Override
    public float decodeToFloat(int id) {
        return this.dictionary.decodeToFloat(id);
    }

    @Override
    public double decodeToDouble(int id) {
        return this.dictionary.decodeToDouble(id);
    }

    @Override
    public byte[] decodeToBinary(int id) {
        return this.dictionary.decodeToBinary(id).getBytesUnsafe();
    }

    @Override
    public org.apache.paimon.data.Timestamp decodeToTimestamp(int id) {
        return ParquetDictionary.decodeInt96ToTimestamp(true, this.dictionary, id);
    }

    public static org.apache.paimon.data.Timestamp decodeInt96ToTimestamp(boolean utcTimestamp, org.apache.paimon.shade.org.apache.parquet.column.Dictionary dictionary, int id) {
        Binary binary = dictionary.decodeToBinary(id);
        Preconditions.checkArgument(binary.length() == 12, "Timestamp with int96 should be 12 bytes.");
        ByteBuffer buffer = binary.toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
        return ParquetDictionary.int96ToTimestamp(utcTimestamp, buffer.getLong(), buffer.getInt());
    }

    public static org.apache.paimon.data.Timestamp int96ToTimestamp(boolean utcTimestamp, long nanosOfDay, int julianDay) {
        long millisecond = ParquetDictionary.julianDayToMillis(julianDay) + nanosOfDay / ParquetRowDataWriter.NANOS_PER_MILLISECOND;
        if (utcTimestamp) {
            int nanoOfMillisecond = (int)(nanosOfDay % ParquetRowDataWriter.NANOS_PER_MILLISECOND);
            return org.apache.paimon.data.Timestamp.fromEpochMillis(millisecond, nanoOfMillisecond);
        }
        Timestamp timestamp = new Timestamp(millisecond);
        timestamp.setNanos((int)(nanosOfDay % ParquetRowDataWriter.NANOS_PER_SECOND));
        return org.apache.paimon.data.Timestamp.fromSQLTimestamp(timestamp);
    }

    private static long julianDayToMillis(int julianDay) {
        return (long)(julianDay - 2440588) * ParquetRowDataWriter.MILLIS_IN_DAY;
    }
}

