/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.append;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.append.AppendCompactTask;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.deletionvectors.append.AppendDeleteFileMaintainer;
import org.apache.paimon.deletionvectors.append.BaseAppendDeleteFileMaintainer;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.source.DeletionFile;
import org.apache.paimon.table.source.EndOfScanException;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;

public class AppendCompactCoordinator {
    private static final int FILES_BATCH = 100000;
    protected static final int REMOVE_AGE = 10;
    protected static final int COMPACT_AGE = 5;
    private final SnapshotManager snapshotManager;
    private final long targetFileSize;
    private final long compactionFileSize;
    private final double deleteThreshold;
    private final long openFileCost;
    private final int minFileNum;
    private final DvMaintainerCache dvMaintainerCache;
    private final FilesIterator filesIterator;
    final Map<BinaryRow, SubCoordinator> subCoordinators = new HashMap<BinaryRow, SubCoordinator>();

    public AppendCompactCoordinator(FileStoreTable table, boolean isStreaming) {
        this(table, isStreaming, null);
    }

    public AppendCompactCoordinator(FileStoreTable table, boolean isStreaming, @Nullable Predicate filter) {
        Preconditions.checkArgument(table.primaryKeys().isEmpty());
        this.snapshotManager = table.snapshotManager();
        CoreOptions options = table.coreOptions();
        this.targetFileSize = options.targetFileSize(false);
        this.compactionFileSize = options.compactionFileSize(false);
        this.deleteThreshold = options.compactionDeleteRatioThreshold();
        this.openFileCost = options.splitOpenFileCost();
        this.minFileNum = options.compactionMinFileNum();
        this.dvMaintainerCache = options.deletionVectorsEnabled() ? new DvMaintainerCache(table.store().newIndexFileHandler()) : null;
        this.filesIterator = new FilesIterator(table, isStreaming, filter);
    }

    public List<AppendCompactTask> run() {
        if (this.scan()) {
            return this.compactPlan();
        }
        return Collections.emptyList();
    }

    @VisibleForTesting
    boolean scan() {
        HashMap<BinaryRow, List> files = new HashMap<BinaryRow, List>();
        for (int i = 0; i < 100000; ++i) {
            ManifestEntry entry;
            try {
                entry = this.filesIterator.next();
            }
            catch (EndOfScanException e) {
                if (!files.isEmpty()) {
                    files.forEach(this::notifyNewFiles);
                    return true;
                }
                throw e;
            }
            if (entry == null) break;
            BinaryRow partition = entry.partition();
            files.computeIfAbsent(partition, k -> new ArrayList()).add(entry.file());
        }
        if (files.isEmpty()) {
            return false;
        }
        files.forEach(this::notifyNewFiles);
        return true;
    }

    @VisibleForTesting
    FilesIterator filesIterator() {
        return this.filesIterator;
    }

    @VisibleForTesting
    void notifyNewFiles(BinaryRow partition, List<DataFileMeta> files) {
        List<DataFileMeta> toCompact = files.stream().filter(file -> this.shouldCompact(partition, (DataFileMeta)file)).collect(Collectors.toList());
        this.subCoordinators.computeIfAbsent(partition, pp -> new SubCoordinator(partition)).addFiles(toCompact);
    }

    @VisibleForTesting
    List<AppendCompactTask> compactPlan() {
        List<AppendCompactTask> tasks = this.subCoordinators.values().stream().flatMap(s -> s.plan().stream()).collect(Collectors.toList());
        new ArrayList<SubCoordinator>(this.subCoordinators.values()).stream().filter(SubCoordinator::readyToRemove).map(SubCoordinator::partition).forEach(this.subCoordinators::remove);
        return tasks;
    }

    @VisibleForTesting
    HashSet<DataFileMeta> listRestoredFiles() {
        HashSet<DataFileMeta> result = new HashSet<DataFileMeta>();
        this.subCoordinators.values().stream().map(SubCoordinator::toCompact).forEach(result::addAll);
        return result;
    }

    private boolean shouldCompact(BinaryRow partition, DataFileMeta file) {
        return file.fileSize() < this.compactionFileSize || this.tooHighDeleteRatio(partition, file);
    }

    private boolean tooHighDeleteRatio(BinaryRow partition, DataFileMeta file) {
        DeletionFile deletionFile;
        if (this.dvMaintainerCache != null && (deletionFile = this.dvMaintainerCache.dvMaintainer(partition).getDeletionFile(file.fileName())) != null) {
            Long cardinality = deletionFile.cardinality();
            long rowCount = file.rowCount();
            return cardinality == null || (double)cardinality.longValue() > (double)rowCount * this.deleteThreshold;
        }
        return false;
    }

    @VisibleForTesting
    AppendDeleteFileMaintainer dvMaintainer(BinaryRow partition) {
        return this.dvMaintainerCache.dvMaintainer(partition);
    }

    class FilesIterator {
        private final SnapshotReader snapshotReader;
        private final boolean streamingMode;
        @Nullable
        private Long nextSnapshot = null;
        @Nullable
        private Iterator<ManifestEntry> currentIterator;

        public FilesIterator(FileStoreTable table, @Nullable boolean isStreaming, Predicate filter) {
            this.snapshotReader = table.newSnapshotReader();
            if (filter != null) {
                this.snapshotReader.withFilter(filter);
            }
            if (table.coreOptions().manifestDeleteFileDropStats()) {
                this.snapshotReader.dropStats();
            }
            this.streamingMode = isStreaming;
        }

        private void assignNewIterator() {
            this.currentIterator = null;
            if (this.nextSnapshot == null) {
                this.nextSnapshot = AppendCompactCoordinator.this.snapshotManager.latestSnapshotId();
                if (this.nextSnapshot == null) {
                    if (!this.streamingMode) {
                        throw new EndOfScanException();
                    }
                    return;
                }
                this.snapshotReader.withMode(ScanMode.ALL);
            } else {
                if (!this.streamingMode) {
                    throw new EndOfScanException();
                }
                this.snapshotReader.withMode(ScanMode.DELTA);
            }
            if (!AppendCompactCoordinator.this.snapshotManager.snapshotExists(this.nextSnapshot)) {
                return;
            }
            Snapshot snapshot = AppendCompactCoordinator.this.snapshotManager.snapshot(this.nextSnapshot);
            Long l = this.nextSnapshot;
            Long l2 = this.nextSnapshot = Long.valueOf(this.nextSnapshot + 1L);
            if (AppendCompactCoordinator.this.dvMaintainerCache != null) {
                AppendCompactCoordinator.this.dvMaintainerCache.refresh();
            }
            this.currentIterator = this.snapshotReader.withManifestEntryFilter(entry -> AppendCompactCoordinator.this.shouldCompact(entry.partition(), entry.file())).withSnapshot(snapshot).readFileIterator();
        }

        @Nullable
        public ManifestEntry next() {
            while (true) {
                if (this.currentIterator == null) {
                    this.assignNewIterator();
                    if (this.currentIterator == null) {
                        return null;
                    }
                }
                if (this.currentIterator.hasNext()) {
                    ManifestEntry entry = this.currentIterator.next();
                    if (entry.kind() == FileKind.DELETE) continue;
                    return entry;
                }
                this.currentIterator = null;
            }
        }
    }

    private class DvMaintainerCache {
        private final IndexFileHandler indexFileHandler;
        private final Map<BinaryRow, AppendDeleteFileMaintainer> cache = new ConcurrentHashMap<BinaryRow, AppendDeleteFileMaintainer>();

        private DvMaintainerCache(IndexFileHandler indexFileHandler) {
            this.indexFileHandler = indexFileHandler;
        }

        private void refresh() {
            this.cache.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AppendDeleteFileMaintainer dvMaintainer(BinaryRow partition) {
            AppendDeleteFileMaintainer maintainer = this.cache.get(partition);
            if (maintainer == null) {
                DvMaintainerCache dvMaintainerCache = this;
                synchronized (dvMaintainerCache) {
                    maintainer = BaseAppendDeleteFileMaintainer.forUnawareAppend(this.indexFileHandler, AppendCompactCoordinator.this.snapshotManager.latestSnapshot(), partition);
                }
                this.cache.put(partition, maintainer);
            }
            return maintainer;
        }
    }

    class SubCoordinator {
        private final BinaryRow partition;
        private final HashSet<DataFileMeta> toCompact = new HashSet();
        int age = 0;

        public SubCoordinator(BinaryRow partition) {
            this.partition = partition;
        }

        public List<AppendCompactTask> plan() {
            return this.pickCompact();
        }

        public BinaryRow partition() {
            return this.partition;
        }

        public HashSet<DataFileMeta> toCompact() {
            return this.toCompact;
        }

        private List<AppendCompactTask> pickCompact() {
            List<List<DataFileMeta>> waitCompact = this.agePack();
            return waitCompact.stream().map(files -> new AppendCompactTask(this.partition, (List<DataFileMeta>)files)).collect(Collectors.toList());
        }

        public void addFiles(List<DataFileMeta> dataFileMetas) {
            this.age = 0;
            this.toCompact.addAll(dataFileMetas);
        }

        public boolean readyToRemove() {
            return this.toCompact.isEmpty() || this.age > 10;
        }

        private List<List<DataFileMeta>> agePack() {
            List<List<DataFileMeta>> packed = AppendCompactCoordinator.this.dvMaintainerCache == null ? this.pack(this.toCompact) : this.packInDeletionVectorVMode(this.toCompact);
            if (packed.isEmpty() && ++this.age > 5 && this.toCompact.size() > 1) {
                ArrayList<DataFileMeta> all = new ArrayList<DataFileMeta>(this.toCompact);
                this.toCompact.clear();
                packed = Collections.singletonList(all);
            }
            return packed;
        }

        private List<List<DataFileMeta>> pack(Set<DataFileMeta> toCompact) {
            ArrayList<DataFileMeta> files = new ArrayList<DataFileMeta>(toCompact);
            files.sort(Comparator.comparingLong(DataFileMeta::fileSize));
            ArrayList<List<DataFileMeta>> result = new ArrayList<List<DataFileMeta>>();
            FileBin fileBin = new FileBin();
            for (DataFileMeta fileMeta : files) {
                fileBin.addFile(fileMeta);
                if (!fileBin.enoughContent()) continue;
                result.add(fileBin.drain());
            }
            if (fileBin.enoughInputFiles()) {
                result.add(fileBin.drain());
            }
            return result;
        }

        private List<List<DataFileMeta>> packInDeletionVectorVMode(Set<DataFileMeta> toCompact) {
            HashMap<String, List> filesWithDV = new HashMap<String, List>();
            HashSet<DataFileMeta> rest = new HashSet<DataFileMeta>();
            for (DataFileMeta dataFile : toCompact) {
                String indexFile = AppendCompactCoordinator.this.dvMaintainerCache.dvMaintainer(this.partition).getIndexFilePath(dataFile.fileName());
                if (indexFile == null) {
                    rest.add(dataFile);
                    continue;
                }
                filesWithDV.computeIfAbsent(indexFile, f -> new ArrayList()).add(dataFile);
            }
            ArrayList dvGroups = new ArrayList(filesWithDV.values());
            dvGroups.sort(Comparator.comparingLong(this::fileSizeOfList));
            ArrayList<List<DataFileMeta>> result = new ArrayList<List<DataFileMeta>>();
            FileBin fileBin = new FileBin();
            for (List dvGroup : dvGroups) {
                fileBin.addFiles(dvGroup);
                if (!fileBin.enoughContent()) continue;
                result.add(fileBin.drain());
            }
            if (!fileBin.bin.isEmpty()) {
                result.add(fileBin.drain());
            }
            if (rest.size() > 1) {
                result.addAll(this.pack(rest));
            }
            return result;
        }

        private long fileSizeOfList(List<DataFileMeta> list) {
            return list.stream().mapToLong(DataFileMeta::fileSize).sum();
        }

        private class FileBin {
            List<DataFileMeta> bin = new ArrayList<DataFileMeta>();
            long totalFileSize = 0L;

            private FileBin() {
            }

            public List<DataFileMeta> drain() {
                ArrayList<DataFileMeta> result = new ArrayList<DataFileMeta>(this.bin);
                this.bin.forEach(SubCoordinator.this.toCompact::remove);
                this.bin.clear();
                this.totalFileSize = 0L;
                return result;
            }

            public void addFiles(List<DataFileMeta> files) {
                files.forEach(this::addFile);
            }

            public void addFile(DataFileMeta file) {
                this.totalFileSize += file.fileSize() + AppendCompactCoordinator.this.openFileCost;
                this.bin.add(file);
            }

            private boolean enoughContent() {
                return this.bin.size() > 1 && this.totalFileSize >= AppendCompactCoordinator.this.targetFileSize * 2L;
            }

            private boolean enoughInputFiles() {
                return this.bin.size() >= AppendCompactCoordinator.this.minFileNum;
            }
        }
    }
}

