/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.source;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.fluss.lake.paimon.source.PaimonSplit;
import org.apache.fluss.lake.serializer.SimpleVersionedSerializer;
import org.apache.paimon.io.DataOutputViewStreamWrapper;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.utils.InstantiationUtil;

public class PaimonSplitSerializer
implements SimpleVersionedSerializer<PaimonSplit> {
    private static final int VERSION_1 = 1;

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(PaimonSplit paimonSplit) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper(out);
        DataSplit dataSplit = paimonSplit.dataSplit();
        InstantiationUtil.serializeObject(view, dataSplit);
        view.writeBoolean(paimonSplit.isBucketUnAware());
        return out.toByteArray();
    }

    public PaimonSplit deserialize(int version, byte[] serialized) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(serialized);
        try {
            DataSplit dataSplit = (DataSplit)InstantiationUtil.deserializeObject(in, this.getClass().getClassLoader());
            if (version == 1) {
                DataInputStream dis = new DataInputStream(in);
                boolean isBucketUnAware = dis.readBoolean();
                return new PaimonSplit(dataSplit, isBucketUnAware);
            }
            throw new IOException("Unsupported PaimonSplit serialization version: " + version);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Failed to deserialize PaimonSplit", e);
        }
    }
}

