/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.fluss.lake.source.LakeSplit;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.table.source.DataSplit;

public class PaimonSplit
implements LakeSplit {
    private final DataSplit dataSplit;
    private final boolean isBucketUnAware;

    public PaimonSplit(DataSplit dataSplit, boolean isBucketUnAware) {
        this.dataSplit = dataSplit;
        this.isBucketUnAware = isBucketUnAware;
    }

    public int bucket() {
        if (this.isBucketUnAware) {
            return -1;
        }
        return this.dataSplit.bucket();
    }

    public List<String> partition() {
        BinaryRow partition = this.dataSplit.partition();
        if (partition.getFieldCount() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> partitions = new ArrayList<String>();
        for (int i = 0; i < partition.getFieldCount(); ++i) {
            partitions.add(partition.getString(i).toString());
        }
        return partitions;
    }

    public DataSplit dataSplit() {
        return this.dataSplit;
    }

    public boolean isBucketUnAware() {
        return this.isBucketUnAware;
    }
}

