/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.concurrent;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.apache.hadoop.util.concurrent.ExecutorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopScheduledThreadPoolExecutor.class);

    public HadoopScheduledThreadPoolExecutor(int corePoolSize) {
        super(corePoolSize);
    }

    public HadoopScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory2) {
        super(corePoolSize, threadFactory2);
    }

    public HadoopScheduledThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, handler);
    }

    public HadoopScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory2, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory2, handler);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeExecute in thread: " + Thread.currentThread().getName() + ", runnable type: " + r.getClass().getName());
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        ExecutorHelper.logThrowableFromAfterExecute(r, t);
    }
}

