/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.io.retry.Idempotent;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.KerberosInfo;

@KerberosInfo(serverPrincipal="hadoop.security.service.user.name.key")
@InterfaceAudience.Public
@InterfaceStability.Evolving
public interface HAServiceProtocol {
    public static final long versionID = 1L;

    @Idempotent
    public void monitorHealth() throws HealthCheckFailedException, AccessControlException, IOException;

    @Idempotent
    public void transitionToActive(StateChangeRequestInfo var1) throws ServiceFailedException, AccessControlException, IOException;

    @Idempotent
    public void transitionToStandby(StateChangeRequestInfo var1) throws ServiceFailedException, AccessControlException, IOException;

    @Idempotent
    public void transitionToObserver(StateChangeRequestInfo var1) throws ServiceFailedException, AccessControlException, IOException;

    @Idempotent
    public HAServiceStatus getServiceStatus() throws AccessControlException, IOException;

    public static class StateChangeRequestInfo {
        private final RequestSource source;

        public StateChangeRequestInfo(RequestSource source2) {
            this.source = source2;
        }

        public RequestSource getSource() {
            return this.source;
        }
    }

    public static enum RequestSource {
        REQUEST_BY_USER,
        REQUEST_BY_USER_FORCED,
        REQUEST_BY_ZKFC;

    }

    public static enum HAServiceState {
        INITIALIZING("initializing"),
        ACTIVE("active"),
        STANDBY("standby"),
        OBSERVER("observer"),
        STOPPING("stopping");

        private String name;

        private HAServiceState(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

