/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.core.internal;

import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.bifromq.basecrdt.core.api.CCounterOperation;
import org.apache.bifromq.basecrdt.core.api.ICCounter;
import org.apache.bifromq.basecrdt.core.internal.CausalCRDT;
import org.apache.bifromq.basecrdt.core.internal.DotFunc;
import org.apache.bifromq.basecrdt.core.internal.IDotFunc;
import org.apache.bifromq.basecrdt.core.internal.IDotMap;
import org.apache.bifromq.basecrdt.core.internal.VarLong;
import org.apache.bifromq.basecrdt.proto.Dot;
import org.apache.bifromq.basecrdt.proto.Replica;
import org.apache.bifromq.basecrdt.proto.StateLattice;

class CCounter
extends CausalCRDT<IDotMap, CCounterOperation>
implements ICCounter {
    private volatile long read = 0L;

    CCounter(Replica replica, CausalCRDT.DotStoreAccessor<IDotMap> dotStoreAccessor, CausalCRDT.CRDTOperationExecutor<CCounterOperation> executor) {
        super(replica, dotStoreAccessor, executor);
        this.refresh();
    }

    @Override
    public long read() {
        return this.read;
    }

    @Override
    protected void handleInflation(Iterable<StateLattice> addEvents, Iterable<StateLattice> removeEvents) {
        this.refresh();
    }

    private void refresh() {
        long total = 0L;
        IDotMap dotMap = (IDotMap)this.dotStoreAccessor.fetch();
        Iterator<ByteString> dotFuncKeys = dotMap.dotFuncKeys();
        while (dotFuncKeys.hasNext()) {
            ByteString dotFuncKey = dotFuncKeys.next();
            IDotFunc dotFunc = dotMap.subDotFunc(dotFuncKey).orElse(DotFunc.BOTTOM);
            HashMap dots = Maps.newHashMap();
            for (Dot dot : dotFunc) {
                if (!dots.containsKey(dot.getReplicaId())) {
                    total += VarLong.decode(dotFunc.value(dot).get());
                    dots.put(dot.getReplicaId(), dot);
                    continue;
                }
                if (((Dot)dots.get(dot.getReplicaId())).getVer() >= dot.getVer()) continue;
                total -= VarLong.decode(dotFunc.value((Dot)dots.get(dot.getReplicaId())).get());
                total += VarLong.decode(dotFunc.value(dot).get());
                dots.put(dot.getReplicaId(), dot);
            }
        }
        this.read = total;
    }
}

