/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.demo.plugin;

import java.net.URI;
import lombok.Generated;
import org.apache.bifromq.demo.plugin.WebHookBasedResourceThrottler;
import org.apache.bifromq.plugin.resourcethrottler.IResourceThrottler;
import org.apache.bifromq.plugin.resourcethrottler.TenantResourceType;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class DemoResourceThrottler
implements IResourceThrottler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DemoResourceThrottler.class);
    private static final String PLUGIN_RESOURCE_THROTTLER_URL = "plugin.resourcethrottler.url";
    private final IResourceThrottler delegate;

    public DemoResourceThrottler() {
        IResourceThrottler delegate1;
        String webhookUrl = System.getProperty(PLUGIN_RESOURCE_THROTTLER_URL);
        if (webhookUrl == null) {
            log.info("No webhook url specified, fallback to no resource will be throttled.");
            delegate1 = (tenantId, type) -> true;
        } else {
            try {
                URI webhookURI = URI.create(webhookUrl);
                delegate1 = new WebHookBasedResourceThrottler(webhookURI);
                log.info("DemoResourceThrottler's webhook URL: {}", (Object)webhookUrl);
            }
            catch (Throwable e) {
                delegate1 = (tenantId, type) -> true;
            }
        }
        this.delegate = delegate1;
    }

    public boolean hasResource(String tenantId, TenantResourceType type) {
        return this.delegate.hasResource(tenantId, type);
    }
}

