/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baseenv;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.baseenv.IEnvProvider;

public class NettyEnv {
    public static EventLoopGroup createEventLoopGroup(String name) {
        IEnvProvider envProvider = EnvProvider.INSTANCE;
        if (Epoll.isAvailable()) {
            return new EpollEventLoopGroup(envProvider.newThreadFactory(name));
        }
        if (KQueue.isAvailable()) {
            return new KQueueEventLoopGroup(envProvider.newThreadFactory(name));
        }
        return new NioEventLoopGroup();
    }

    public static EventLoopGroup createEventLoopGroup(int nThreads, String name) {
        IEnvProvider envProvider = EnvProvider.INSTANCE;
        if (Epoll.isAvailable()) {
            return new EpollEventLoopGroup(nThreads, envProvider.newThreadFactory(name));
        }
        if (KQueue.isAvailable()) {
            return new KQueueEventLoopGroup(nThreads, envProvider.newThreadFactory(name));
        }
        return new NioEventLoopGroup(nThreads, envProvider.newThreadFactory(name));
    }

    public static Class<? extends SocketChannel> getSocketChannelClass() {
        if (Epoll.isAvailable()) {
            return EpollSocketChannel.class;
        }
        if (KQueue.isAvailable()) {
            return KQueueSocketChannel.class;
        }
        return NioSocketChannel.class;
    }

    public static Class<? extends ServerSocketChannel> getServerSocketChannelClass() {
        if (Epoll.isAvailable()) {
            return EpollServerSocketChannel.class;
        }
        if (KQueue.isAvailable()) {
            return KQueueServerSocketChannel.class;
        }
        return NioServerSocketChannel.class;
    }

    public static Class<? extends SocketChannel> determineSocketChannelClass(EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup instanceof EpollEventLoopGroup) {
            return EpollSocketChannel.class;
        }
        if (eventLoopGroup instanceof KQueueEventLoopGroup) {
            return KQueueSocketChannel.class;
        }
        return NioSocketChannel.class;
    }

    public static Class<? extends ServerSocketChannel> determineServerSocketChannelClass(EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup instanceof EpollEventLoopGroup) {
            return EpollServerSocketChannel.class;
        }
        if (eventLoopGroup instanceof KQueueEventLoopGroup) {
            return KQueueServerSocketChannel.class;
        }
        return NioServerSocketChannel.class;
    }

    public static Class<? extends DatagramChannel> getDatagramChannelClass() {
        if (Epoll.isAvailable()) {
            return EpollDatagramChannel.class;
        }
        if (KQueue.isAvailable()) {
            return KQueueDatagramChannel.class;
        }
        return NioDatagramChannel.class;
    }
}

