/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler;

import com.google.protobuf.ByteString;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttConnAckMessage;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.bifromq.base.util.FutureTracker;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.inbox.client.IInboxClient;
import org.apache.bifromq.inbox.rpc.proto.AttachRequest;
import org.apache.bifromq.inbox.rpc.proto.DetachReply;
import org.apache.bifromq.inbox.rpc.proto.DetachRequest;
import org.apache.bifromq.inbox.rpc.proto.ExistRequest;
import org.apache.bifromq.inbox.storage.proto.InboxVersion;
import org.apache.bifromq.inbox.storage.proto.LWT;
import org.apache.bifromq.metrics.ITenantMeter;
import org.apache.bifromq.metrics.TenantMetric;
import org.apache.bifromq.mqtt.handler.ChannelAttrs;
import org.apache.bifromq.mqtt.handler.ConditionalSlowDownHandler;
import org.apache.bifromq.mqtt.handler.MQTTPacketFilter;
import org.apache.bifromq.mqtt.handler.MQTTSessionHandler;
import org.apache.bifromq.mqtt.handler.MQTTSessionIdUtil;
import org.apache.bifromq.mqtt.handler.TenantSettings;
import org.apache.bifromq.mqtt.handler.condition.DirectMemPressureCondition;
import org.apache.bifromq.mqtt.handler.condition.HeapMemPressureCondition;
import org.apache.bifromq.mqtt.handler.condition.InboundResourceCondition;
import org.apache.bifromq.mqtt.handler.condition.ORCondition;
import org.apache.bifromq.mqtt.handler.record.GoAway;
import org.apache.bifromq.mqtt.session.IMQTTPersistentSession;
import org.apache.bifromq.mqtt.session.IMQTTTransientSession;
import org.apache.bifromq.mqtt.session.MQTTSessionContext;
import org.apache.bifromq.mqtt.utils.IMQTTMessageSizer;
import org.apache.bifromq.plugin.authprovider.type.Success;
import org.apache.bifromq.plugin.eventcollector.Event;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.eventcollector.ThreadLocalEventPool;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.channelclosed.ProtocolError;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientconnected.ClientConnected;
import org.apache.bifromq.plugin.resourcethrottler.IResourceThrottler;
import org.apache.bifromq.plugin.resourcethrottler.TenantResourceType;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.sysprops.props.SanityCheckMqttUtf8String;
import org.apache.bifromq.type.ClientInfo;
import org.apache.bifromq.type.UserProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MQTTConnectHandler
extends ChannelDuplexHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MQTTConnectHandler.class);
    protected static final boolean SANITY_CHECK = (Boolean)SanityCheckMqttUtf8String.INSTANCE.get();
    private final FutureTracker cancellableTasks = new FutureTracker();
    protected ChannelHandlerContext ctx;
    protected MQTTSessionContext sessionCtx;
    private IInboxClient inboxClient;
    private IEventCollector eventCollector;
    private IResourceThrottler resourceThrottler;
    private ISettingProvider settingProvider;
    private boolean isGoAway;

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.ctx = ctx;
        this.sessionCtx = ChannelAttrs.mqttSessionContext(ctx);
        this.inboxClient = this.sessionCtx.inboxClient;
        this.eventCollector = this.sessionCtx.eventCollector;
        this.resourceThrottler = this.sessionCtx.resourceThrottler;
        this.settingProvider = this.sessionCtx.settingProvider;
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.cancellableTasks.stop();
        ctx.fireChannelInactive();
    }

    public final void channelRead(ChannelHandlerContext ctx, Object msg) {
        MqttMessage mqttMessage = (MqttMessage)msg;
        log.trace("Received {}", (Object)mqttMessage);
        if (mqttMessage.fixedHeader().messageType() == MqttMessageType.CONNECT) {
            MqttConnectMessage connMsg = (MqttConnectMessage)msg;
            GoAway goAway = this.sanityCheck(connMsg);
            if (goAway != null) {
                this.handleGoAway(goAway);
                return;
            }
            long reqId = System.nanoTime();
            ((CompletableFuture)this.cancellableTasks.track(this.authenticate(connMsg)).thenComposeAsync(okOrGoAway -> {
                if (okOrGoAway.goAway != null) {
                    return CompletableFuture.completedFuture(okOrGoAway);
                }
                return this.checkConnectPermission(connMsg, okOrGoAway.successInfo);
            }, (Executor)ctx.executor())).thenComposeAsync(okOrGoAway -> {
                if (okOrGoAway.goAway != null) {
                    this.handleGoAway(okOrGoAway.goAway);
                    return CompletableFuture.completedFuture(null);
                }
                ClientInfo clientInfo = okOrGoAway.successInfo.clientInfo;
                String tenantId = clientInfo.getTenantId();
                if (!this.resourceThrottler.hasResource(tenantId, TenantResourceType.TotalConnections)) {
                    this.handleGoAway(this.onNoEnoughResources(connMsg, TenantResourceType.TotalConnections, clientInfo));
                    return CompletableFuture.completedFuture(null);
                }
                if (!this.resourceThrottler.hasResource(tenantId, TenantResourceType.TotalSessionMemoryBytes)) {
                    this.handleGoAway(this.onNoEnoughResources(connMsg, TenantResourceType.TotalSessionMemoryBytes, clientInfo));
                    return CompletableFuture.completedFuture(null);
                }
                if (!this.resourceThrottler.hasResource(tenantId, TenantResourceType.TotalConnectPerSecond)) {
                    this.handleGoAway(this.onNoEnoughResources(connMsg, TenantResourceType.TotalConnectPerSecond, clientInfo));
                    return CompletableFuture.completedFuture(null);
                }
                TenantSettings settings = new TenantSettings(tenantId, this.settingProvider);
                GoAway isInvalid = this.validate(connMsg, settings, clientInfo);
                if (isInvalid != null) {
                    this.handleGoAway(isInvalid);
                    return CompletableFuture.completedFuture(null);
                }
                GoAway needRedirect = this.needRedirect(clientInfo);
                if (needRedirect != null) {
                    this.handleGoAway(needRedirect);
                    return CompletableFuture.completedFuture(null);
                }
                LWT willMessage = connMsg.variableHeader().isWillFlag() ? this.getWillMessage(connMsg, clientInfo) : null;
                int keepAliveSeconds = this.keepAliveSeconds(connMsg.variableHeader().keepAliveTimeSeconds(), settings);
                String userSessionId = MQTTSessionIdUtil.userSessionId(clientInfo);
                String requestClientId = connMsg.payload().clientIdentifier();
                if (this.isCleanStart(connMsg, settings)) {
                    return this.expireInbox(reqId, requestClientId, userSessionId, clientInfo).thenAccept(result -> {
                        if (result == ExpireResult.ERROR) {
                            return;
                        }
                        int sessionExpiryInterval = this.getSessionExpiryInterval(connMsg, settings);
                        if (sessionExpiryInterval == 0) {
                            this.setupTransientSessionHandler(connMsg, settings, userSessionId, keepAliveSeconds, result == ExpireResult.OK, willMessage, okOrGoAway.successInfo, ctx);
                        } else {
                            AttachRequest.Builder reqBuilder = AttachRequest.newBuilder().setReqId(System.nanoTime()).setInboxId(userSessionId).setExpirySeconds(sessionExpiryInterval).setLimit(settings.inboxQueueLength).setDropOldest(settings.inboxDropOldest).setClient(clientInfo.toBuilder().putMetadata("sessionType", "p").build()).setNow(HLC.INST.getPhysical());
                            if (willMessage != null && willMessage.getDelaySeconds() > 0) {
                                reqBuilder.setLwt(willMessage);
                            }
                            this.inboxClient.attach(reqBuilder.build()).thenAcceptAsync(attachReply -> {
                                switch (attachReply.getCode()) {
                                    case OK: {
                                        InboxVersion inboxVersion = attachReply.getVersion();
                                        if (inboxVersion.getMod() > 0L) {
                                            this.handleGoAway(this.onInboxCallRetry(clientInfo, "Client id conflict"));
                                            break;
                                        }
                                        this.setupPersistentSessionHandler(connMsg, settings, userSessionId, keepAliveSeconds, sessionExpiryInterval, inboxVersion, willMessage, okOrGoAway.successInfo, ctx);
                                        break;
                                    }
                                    case TRY_LATER: {
                                        this.handleGoAway(this.onInboxCallRetry(clientInfo, "Inbox service call needs retry"));
                                        break;
                                    }
                                    case BACK_PRESSURE_REJECTED: {
                                        this.handleGoAway(this.onInboxCallBusy(clientInfo, "Inbox service busy"));
                                        break;
                                    }
                                    default: {
                                        this.handleGoAway(this.onInboxCallError(clientInfo, "Inbox service error"));
                                    }
                                }
                            }, (Executor)ctx.executor());
                        }
                    });
                }
                int sessionExpiryInterval = this.getSessionExpiryInterval(connMsg, settings);
                if (sessionExpiryInterval == 0) {
                    return this.inboxClient.exist(ExistRequest.newBuilder().setReqId(reqId).setTenantId(clientInfo.getTenantId()).setInboxId(userSessionId).build()).thenAcceptAsync(getReply -> {
                        switch (getReply.getCode()) {
                            case EXIST: {
                                AttachRequest.Builder reqBuilder = AttachRequest.newBuilder().setReqId(System.nanoTime()).setInboxId(userSessionId).setExpirySeconds(sessionExpiryInterval).setLimit(settings.inboxQueueLength).setDropOldest(settings.inboxDropOldest).setClient(clientInfo.toBuilder().putMetadata("sessionType", "p").build()).setNow(HLC.INST.getPhysical());
                                if (willMessage != null && willMessage.getDelaySeconds() > 0) {
                                    reqBuilder.setLwt(willMessage);
                                }
                                this.inboxClient.attach(reqBuilder.build()).thenAcceptAsync(attachReply -> {
                                    switch (attachReply.getCode()) {
                                        case OK: {
                                            InboxVersion inboxInstance = attachReply.getVersion();
                                            if (inboxInstance.getMod() > 0L) {
                                                this.setupPersistentSessionHandler(connMsg, settings, userSessionId, keepAliveSeconds, sessionExpiryInterval, inboxInstance, willMessage, okOrGoAway.successInfo, ctx);
                                                break;
                                            }
                                            this.setupTransientSessionHandler(connMsg, settings, userSessionId, keepAliveSeconds, false, willMessage, okOrGoAway.successInfo, ctx);
                                            break;
                                        }
                                        case TRY_LATER: {
                                            this.handleGoAway(this.onInboxCallRetry(clientInfo, "Inbox service call[attach] needs retry"));
                                            break;
                                        }
                                        case BACK_PRESSURE_REJECTED: {
                                            this.handleGoAway(this.onInboxCallBusy(clientInfo, "Inbox service call[attach] busy"));
                                            break;
                                        }
                                        default: {
                                            this.handleGoAway(this.onInboxCallError(clientInfo, "Inbox service call[attach] error"));
                                        }
                                    }
                                }, (Executor)ctx.executor());
                                break;
                            }
                            case NO_INBOX: {
                                this.setupTransientSessionHandler(connMsg, settings, userSessionId, keepAliveSeconds, false, willMessage, okOrGoAway.successInfo, ctx);
                                break;
                            }
                            case BACK_PRESSURE_REJECTED: {
                                this.handleGoAway(this.onInboxCallBusy(clientInfo, "Inbox service call[exist] busy"));
                                break;
                            }
                            case TRY_LATER: {
                                this.handleGoAway(this.onInboxCallRetry(clientInfo, "Inbox service call[exist] needs retry"));
                                break;
                            }
                            case ERROR: {
                                this.handleGoAway(this.onInboxCallError(clientInfo, "Inbox service call[exist] error"));
                                break;
                            }
                        }
                    }, (Executor)ctx.executor());
                }
                AttachRequest.Builder reqBuilder = AttachRequest.newBuilder().setReqId(System.nanoTime()).setInboxId(userSessionId).setExpirySeconds(sessionExpiryInterval).setLimit(settings.inboxQueueLength).setDropOldest(settings.inboxDropOldest).setClient(clientInfo.toBuilder().putMetadata("sessionType", "p").build()).setNow(HLC.INST.getPhysical());
                if (willMessage != null && willMessage.getDelaySeconds() > 0) {
                    reqBuilder.setLwt(willMessage);
                }
                return this.inboxClient.attach(reqBuilder.build()).thenAcceptAsync(attachReply -> {
                    switch (attachReply.getCode()) {
                        case OK: {
                            this.setupPersistentSessionHandler(connMsg, settings, userSessionId, keepAliveSeconds, sessionExpiryInterval, attachReply.getVersion(), willMessage, okOrGoAway.successInfo, ctx);
                            break;
                        }
                        case TRY_LATER: {
                            this.handleGoAway(this.onInboxCallRetry(clientInfo, "Inbox service call[attach] needs retry"));
                            break;
                        }
                        case BACK_PRESSURE_REJECTED: {
                            this.handleGoAway(this.onInboxCallBusy(clientInfo, "Inbox service call[attach] busy"));
                            break;
                        }
                        default: {
                            this.handleGoAway(this.onInboxCallError(clientInfo, "Inbox service call[attach] error"));
                        }
                    }
                }, (Executor)ctx.executor());
            }, (Executor)ctx.executor());
        } else if (mqttMessage.decoderResult().isSuccess()) {
            this.handleMqttMessage(mqttMessage);
        } else {
            this.handleGoAway(new GoAway(new Event[]{((ProtocolError)((ProtocolError)ThreadLocalEventPool.getLocal(ProtocolError.class)).peerAddress(ChannelAttrs.socketAddress(ctx.channel()))).statement(mqttMessage.decoderResult().cause().getMessage())}));
        }
    }

    private CompletableFuture<ExpireResult> expireInbox(long reqId, String requestClientId, String userSessionId, ClientInfo clientInfo) {
        if (requestClientId.isEmpty()) {
            return CompletableFuture.completedFuture(ExpireResult.NOT_FOUND);
        }
        return this.inboxClient.exist(ExistRequest.newBuilder().setReqId(reqId).setTenantId(clientInfo.getTenantId()).setInboxId(userSessionId).build()).thenComposeAsync(existReply -> {
            switch (existReply.getCode()) {
                case NO_INBOX: {
                    return CompletableFuture.completedFuture(ExpireResult.NOT_FOUND);
                }
                case EXIST: {
                    return ((CompletableFuture)this.inboxClient.detach(DetachRequest.newBuilder().setReqId(reqId).setInboxId(userSessionId).setExpirySeconds(0).setDiscardLWT(true).setClient(clientInfo).setNow(HLC.INST.getPhysical()).build()).exceptionally(e -> {
                        log.debug("Failed to expire inbox", e);
                        return DetachReply.newBuilder().setReqId(reqId).setCode(DetachReply.Code.ERROR).build();
                    })).thenApplyAsync(reply -> {
                        switch (reply.getCode()) {
                            case OK: {
                                return ExpireResult.OK;
                            }
                            case NO_INBOX: {
                                return ExpireResult.NOT_FOUND;
                            }
                            case TRY_LATER: {
                                this.handleGoAway(this.onInboxCallRetry(clientInfo, "Inbox service call[expire] needs retry"));
                                return ExpireResult.ERROR;
                            }
                            case BACK_PRESSURE_REJECTED: {
                                this.handleGoAway(this.onInboxCallBusy(clientInfo, "Inbox service call[expire] busy"));
                                return ExpireResult.ERROR;
                            }
                        }
                        this.handleGoAway(this.onInboxCallError(clientInfo, "Inbox service call[expire] error"));
                        return ExpireResult.ERROR;
                    }, (Executor)this.ctx.executor());
                }
                case TRY_LATER: {
                    this.handleGoAway(this.onInboxCallError(clientInfo, "Inbox service call[exist] needs retry"));
                    return CompletableFuture.completedFuture(ExpireResult.ERROR);
                }
                case BACK_PRESSURE_REJECTED: {
                    this.handleGoAway(this.onInboxCallError(clientInfo, "Inbox service call[exist] needs busy"));
                    return CompletableFuture.completedFuture(ExpireResult.ERROR);
                }
            }
            this.handleGoAway(this.onInboxCallError(clientInfo, "Inbox service call[exist] error"));
            return CompletableFuture.completedFuture(ExpireResult.ERROR);
        }, (Executor)this.ctx.executor());
    }

    protected abstract GoAway sanityCheck(MqttConnectMessage var1);

    protected abstract CompletableFuture<AuthResult> authenticate(MqttConnectMessage var1);

    protected abstract CompletableFuture<AuthResult> checkConnectPermission(MqttConnectMessage var1, SuccessInfo var2);

    protected abstract void handleMqttMessage(MqttMessage var1);

    protected abstract GoAway onNoEnoughResources(MqttConnectMessage var1, TenantResourceType var2, ClientInfo var3);

    protected abstract GoAway validate(MqttConnectMessage var1, TenantSettings var2, ClientInfo var3);

    protected abstract GoAway needRedirect(ClientInfo var1);

    protected abstract LWT getWillMessage(MqttConnectMessage var1, ClientInfo var2);

    protected abstract boolean isCleanStart(MqttConnectMessage var1, TenantSettings var2);

    protected abstract int getSessionExpiryInterval(MqttConnectMessage var1, TenantSettings var2);

    protected abstract GoAway onInboxCallError(ClientInfo var1, String var2);

    protected abstract GoAway onInboxCallRetry(ClientInfo var1, String var2);

    protected abstract GoAway onInboxCallBusy(ClientInfo var1, String var2);

    protected abstract MQTTSessionHandler buildTransientSessionHandler(MqttConnectMessage var1, TenantSettings var2, ITenantMeter var3, String var4, int var5, LWT var6, ClientInfo var7, ChannelHandlerContext var8);

    protected abstract MQTTSessionHandler buildPersistentSessionHandler(MqttConnectMessage var1, TenantSettings var2, ITenantMeter var3, String var4, int var5, int var6, InboxVersion var7, LWT var8, ClientInfo var9, ChannelHandlerContext var10);

    private void setupTransientSessionHandler(MqttConnectMessage connMsg, TenantSettings settings, String userSessionId, int keepAliveSeconds, boolean sessionExists, LWT willMessage, SuccessInfo successInfo, ChannelHandlerContext ctx) {
        int maxPacketSize = this.maxPacketSize(connMsg, settings);
        ClientInfo clientInfo = successInfo.clientInfo;
        clientInfo = clientInfo.toBuilder().putMetadata("sessionType", "t").build();
        ctx.pipeline().addBefore((EventExecutorGroup)ctx.executor(), MqttDecoder.class.getName(), "MQTT5SizeBasedPacketFilter", (ChannelHandler)new MQTTPacketFilter(maxPacketSize, settings, clientInfo, this.eventCollector));
        ctx.pipeline().replace(ctx.pipeline().get("ConditionalRejectHandler"), "SlowDownHandler", (ChannelHandler)new ConditionalSlowDownHandler(ORCondition.or(DirectMemPressureCondition.INSTANCE, HeapMemPressureCondition.INSTANCE, new InboundResourceCondition(this.resourceThrottler, clientInfo)), this.eventCollector, this.sessionCtx::nanoTime, clientInfo));
        ITenantMeter tenantMeter = ITenantMeter.get((String)clientInfo.getTenantId());
        IMQTTMessageSizer sizer = clientInfo.getMetadataOrDefault("ver", "").equals("5") ? IMQTTMessageSizer.mqtt5() : IMQTTMessageSizer.mqtt3();
        tenantMeter.recordSummary(TenantMetric.MqttIngressBytes, (double)sizer.sizeByHeader(connMsg.fixedHeader()));
        MQTTSessionHandler sessionHandler = this.buildTransientSessionHandler(connMsg, settings, tenantMeter, userSessionId, keepAliveSeconds, willMessage, clientInfo, ctx);
        assert (sessionHandler instanceof IMQTTTransientSession);
        ctx.pipeline().replace((ChannelHandler)this, "MQTTTransientSession", (ChannelHandler)sessionHandler);
        ClientInfo finalClientInfo = clientInfo;
        sessionHandler.awaitInitialized().thenAcceptAsync(v -> {
            ctx.writeAndFlush((Object)this.onConnected(connMsg, settings, userSessionId, keepAliveSeconds, 0, false, finalClientInfo, successInfo.responseInfo, successInfo.authData, successInfo.userProperties));
            this.eventCollector.report((Event)((ClientConnected)((ClientConnected)ThreadLocalEventPool.getLocal(ClientConnected.class)).serverId(this.sessionCtx.serverId).clientInfo(finalClientInfo)).userSessionId(userSessionId).keepAliveTimeSeconds(keepAliveSeconds).cleanSession(connMsg.variableHeader().isCleanSession()).sessionPresent(sessionExists).lastWill(willMessage != null ? new ClientConnected.WillInfo().topic(willMessage.getTopic()).isRetain(willMessage.getMessage().getIsRetain()).qos(willMessage.getMessage().getPubQoS()).payload(willMessage.getMessage().getPayload().asReadOnlyByteBuffer()) : null));
        }, (Executor)ctx.executor());
    }

    private void setupPersistentSessionHandler(MqttConnectMessage connMsg, TenantSettings settings, String userSessionId, int keepAliveSeconds, int sessionExpiryInterval, InboxVersion inboxVersion, LWT willMessage, SuccessInfo successInfo, ChannelHandlerContext ctx) {
        int maxPacketSize = this.maxPacketSize(connMsg, settings);
        ClientInfo clientInfo = successInfo.clientInfo;
        clientInfo = clientInfo.toBuilder().putMetadata("sessionType", "p").build();
        ctx.pipeline().addBefore((EventExecutorGroup)ctx.executor(), MqttDecoder.class.getName(), "MQTT5SizeBasedPacketFilter", (ChannelHandler)new MQTTPacketFilter(maxPacketSize, settings, clientInfo, this.eventCollector));
        ctx.pipeline().replace(ctx.pipeline().get("ConditionalRejectHandler"), "SlowDownHandler", (ChannelHandler)new ConditionalSlowDownHandler(ORCondition.or(DirectMemPressureCondition.INSTANCE, HeapMemPressureCondition.INSTANCE, new InboundResourceCondition(this.resourceThrottler, clientInfo)), this.eventCollector, this.sessionCtx::nanoTime, clientInfo));
        ITenantMeter tenantMeter = ITenantMeter.get((String)clientInfo.getTenantId());
        IMQTTMessageSizer sizer = clientInfo.getMetadataOrDefault("ver", "").equals("5") ? IMQTTMessageSizer.mqtt5() : IMQTTMessageSizer.mqtt3();
        tenantMeter.recordSummary(TenantMetric.MqttIngressBytes, (double)sizer.sizeByHeader(connMsg.fixedHeader()));
        MQTTSessionHandler sessionHandler = this.buildPersistentSessionHandler(connMsg, settings, tenantMeter, userSessionId, keepAliveSeconds, sessionExpiryInterval, inboxVersion, (LWT)(willMessage != null && willMessage.getDelaySeconds() > 0 ? null : willMessage), clientInfo, ctx);
        assert (sessionHandler instanceof IMQTTPersistentSession);
        ctx.pipeline().replace((ChannelHandler)this, "MQTTPersistentSession", (ChannelHandler)sessionHandler);
        ClientInfo finalClientInfo = clientInfo;
        sessionHandler.awaitInitialized().thenAcceptAsync(v -> {
            ctx.writeAndFlush((Object)this.onConnected(connMsg, settings, userSessionId, keepAliveSeconds, sessionExpiryInterval, inboxVersion.getMod() > 0L, finalClientInfo, successInfo.responseInfo, successInfo.authData, successInfo.userProperties));
            this.eventCollector.report((Event)((ClientConnected)((ClientConnected)ThreadLocalEventPool.getLocal(ClientConnected.class)).serverId(this.sessionCtx.serverId).clientInfo(finalClientInfo)).userSessionId(userSessionId).keepAliveTimeSeconds(keepAliveSeconds).cleanSession(connMsg.variableHeader().isCleanSession()).sessionPresent(inboxVersion.getMod() > 0L).lastWill(willMessage != null ? new ClientConnected.WillInfo().topic(willMessage.getTopic()).isRetain(willMessage.getMessage().getIsRetain()).qos(willMessage.getMessage().getPubQoS()).payload(willMessage.getMessage().getPayload().asReadOnlyByteBuffer()) : null));
        }, (Executor)ctx.executor());
    }

    protected abstract MqttConnAckMessage onConnected(MqttConnectMessage var1, TenantSettings var2, String var3, int var4, int var5, boolean var6, ClientInfo var7, Optional<String> var8, Optional<ByteString> var9, UserProperties var10);

    protected void handleGoAway(GoAway goAway) {
        assert (this.ctx.executor().inEventLoop());
        if (this.isGoAway) {
            return;
        }
        this.isGoAway = true;
        if (!this.ctx.channel().isActive()) {
            return;
        }
        for (Event<?> reason : goAway.reasons()) {
            this.eventCollector.report(reason);
        }
        Runnable doGoAway = () -> {
            if (goAway.farewell() != null) {
                this.ctx.writeAndFlush((Object)goAway.farewell()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            } else {
                this.ctx.channel().close();
            }
        };
        if (goAway.rightNow()) {
            doGoAway.run();
        } else {
            this.ctx.executor().schedule(doGoAway, (long)ThreadLocalRandom.current().nextInt(100, 5000), TimeUnit.MILLISECONDS);
        }
    }

    protected abstract int maxPacketSize(MqttConnectMessage var1, TenantSettings var2);

    private int keepAliveSeconds(int requestKeepAliveSeconds, TenantSettings settings) {
        if (requestKeepAliveSeconds > 0) {
            requestKeepAliveSeconds = Math.max(settings.minKeepAliveSeconds, requestKeepAliveSeconds);
        }
        return requestKeepAliveSeconds;
    }

    private static enum ExpireResult {
        OK,
        NOT_FOUND,
        ERROR;

    }

    public record SuccessInfo(ClientInfo clientInfo, Optional<String> responseInfo, Optional<ByteString> authData, UserProperties userProperties) {
        public static SuccessInfo of(ClientInfo clientInfo) {
            return new SuccessInfo(clientInfo, Optional.empty(), Optional.empty(), UserProperties.getDefaultInstance());
        }
    }

    public record AuthResult(SuccessInfo successInfo, GoAway goAway) {
        public static AuthResult goAway(MqttMessage farewell, Event<?> ... reasons) {
            return new AuthResult(null, new GoAway(farewell, reasons));
        }

        public static AuthResult goAwayNow(MqttMessage farewell, Event<?> ... reasons) {
            return new AuthResult(null, GoAway.now(farewell, reasons));
        }

        public static AuthResult ok(Success success, ClientInfo clientInfo) {
            Optional<String> respInfo = Optional.ofNullable(success.hasResponseInfo() ? success.getResponseInfo() : null);
            Optional<ByteString> authData = Optional.ofNullable(success.hasAuthData() ? success.getAuthData() : null);
            SuccessInfo successInfo = new SuccessInfo(clientInfo, respInfo, authData, success.getUserProps());
            return new AuthResult(successInfo, null);
        }

        public static AuthResult ok(ClientInfo clientInfo) {
            return new AuthResult(SuccessInfo.of(clientInfo), null);
        }

        public static AuthResult ok(SuccessInfo successInfo) {
            return new AuthResult(successInfo, null);
        }
    }
}

