/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.server.scheduler;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import lombok.Generated;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.basekv.client.IMutationPipeline;
import org.apache.bifromq.basekv.client.exception.BadVersionException;
import org.apache.bifromq.basekv.client.exception.TryLaterException;
import org.apache.bifromq.basekv.client.scheduler.BatchMutationCall;
import org.apache.bifromq.basekv.client.scheduler.MutationCallBatcherKey;
import org.apache.bifromq.basekv.store.proto.RWCoProcInput;
import org.apache.bifromq.basekv.store.proto.RWCoProcOutput;
import org.apache.bifromq.baserpc.client.exception.ServerNotFoundException;
import org.apache.bifromq.basescheduler.ICallTask;
import org.apache.bifromq.inbox.rpc.proto.AttachReply;
import org.apache.bifromq.inbox.rpc.proto.AttachRequest;
import org.apache.bifromq.inbox.storage.proto.BatchAttachRequest;
import org.apache.bifromq.inbox.storage.proto.InboxServiceRWCoProcInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchAttachCall
extends BatchMutationCall<AttachRequest, AttachReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchAttachCall.class);

    protected BatchAttachCall(IMutationPipeline pipeline, MutationCallBatcherKey batcherKey) {
        super(pipeline, batcherKey);
    }

    protected BatchMutationCall.MutationCallTaskBatch<AttachRequest, AttachReply> newBatch(long ver) {
        return new BatchAttachCallTask(ver);
    }

    protected RWCoProcInput makeBatch(Iterable<ICallTask<AttachRequest, AttachReply, MutationCallBatcherKey>> callTasks) {
        BatchAttachRequest.Builder reqBuilder = BatchAttachRequest.newBuilder();
        callTasks.forEach(call -> {
            AttachRequest request = (AttachRequest)call.call();
            BatchAttachRequest.Params.Builder paramsBuilder = BatchAttachRequest.Params.newBuilder().setInboxId(request.getInboxId()).setIncarnation(HLC.INST.get()).setExpirySeconds(request.getExpirySeconds()).setLimit(request.getLimit()).setDropOldest(request.getDropOldest()).setClient(request.getClient()).setNow(request.getNow());
            if (request.hasLwt()) {
                paramsBuilder.setLwt(request.getLwt());
            }
            reqBuilder.addParams(paramsBuilder.build());
        });
        long reqId = System.nanoTime();
        return RWCoProcInput.newBuilder().setInboxService(InboxServiceRWCoProcInput.newBuilder().setReqId(reqId).setBatchAttach(reqBuilder.build()).build()).build();
    }

    protected void handleOutput(Queue<ICallTask<AttachRequest, AttachReply, MutationCallBatcherKey>> batchedTasks, RWCoProcOutput output) {
        ICallTask<AttachRequest, AttachReply, MutationCallBatcherKey> callTask;
        assert (batchedTasks.size() == output.getInboxService().getBatchAttach().getVersionCount());
        int i = 0;
        while ((callTask = batchedTasks.poll()) != null) {
            callTask.resultPromise().complete(AttachReply.newBuilder().setReqId(((AttachRequest)callTask.call()).getReqId()).setCode(AttachReply.Code.OK).setVersion(output.getInboxService().getBatchAttach().getVersion(i++)).build());
        }
    }

    protected void handleException(ICallTask<AttachRequest, AttachReply, MutationCallBatcherKey> callTask, Throwable e) {
        if (e instanceof ServerNotFoundException) {
            callTask.resultPromise().complete(AttachReply.newBuilder().setReqId(((AttachRequest)callTask.call()).getReqId()).setCode(AttachReply.Code.TRY_LATER).build());
            return;
        }
        if (e instanceof BadVersionException) {
            callTask.resultPromise().complete(AttachReply.newBuilder().setReqId(((AttachRequest)callTask.call()).getReqId()).setCode(AttachReply.Code.TRY_LATER).build());
            return;
        }
        if (e instanceof TryLaterException) {
            callTask.resultPromise().complete(AttachReply.newBuilder().setReqId(((AttachRequest)callTask.call()).getReqId()).setCode(AttachReply.Code.TRY_LATER).build());
            return;
        }
        callTask.resultPromise().completeExceptionally(e);
    }

    private static class BatchAttachCallTask
    extends BatchMutationCall.MutationCallTaskBatch<AttachRequest, AttachReply> {
        private final Map<String, Set<String>> inboxes = new HashMap<String, Set<String>>();

        private BatchAttachCallTask(long ver) {
            super(ver);
        }

        protected void add(ICallTask<AttachRequest, AttachReply, MutationCallBatcherKey> callTask) {
            super.add(callTask);
            this.inboxes.computeIfAbsent(((AttachRequest)callTask.call()).getClient().getTenantId(), k -> new HashSet()).add(((AttachRequest)callTask.call()).getInboxId());
        }

        protected boolean isBatchable(ICallTask<AttachRequest, AttachReply, MutationCallBatcherKey> callTask) {
            return !this.inboxes.getOrDefault(((AttachRequest)callTask.call()).getClient().getTenantId(), Collections.emptySet()).contains(((AttachRequest)callTask.call()).getInboxId());
        }
    }
}

