/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.ContextDataInjector;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.ConfigurationScheduler;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.filter.ThreadContextMapFilter;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.net.ssl.SslConfigurationFactory;
import org.apache.logging.log4j.core.util.AuthorizationProvider;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.core.util.internal.HttpInputStreamUtil;
import org.apache.logging.log4j.core.util.internal.LastModifiedSource;
import org.apache.logging.log4j.core.util.internal.Status;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAliases;
import org.apache.logging.log4j.plugins.PluginAttribute;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.util.JsonReader;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.PropertyEnvironment;

@Configurable(elementType="filter", printObject=true)
@Plugin
@PluginAliases(value={"MutableContextMapFilter"})
@PerformanceSensitive(value={"allocation"})
public class MutableThreadContextMapFilter
extends AbstractFilter {
    private static final KeyValuePair[] EMPTY_ARRAY = new KeyValuePair[0];
    private volatile Filter filter;
    private final long pollInterval;
    private final ConfigurationScheduler scheduler;
    private final LastModifiedSource source;
    private final AuthorizationProvider authorizationProvider;
    private final Configuration configuration;
    private final List<FilterConfigUpdateListener> listeners = new ArrayList<FilterConfigUpdateListener>();
    private ScheduledFuture<?> future = null;

    private MutableThreadContextMapFilter(Filter filter, LastModifiedSource source, long pollInterval, AuthorizationProvider authorizationProvider, Filter.Result onMatch, Filter.Result onMismatch, Configuration configuration) {
        super(onMatch, onMismatch);
        this.filter = filter;
        this.pollInterval = pollInterval;
        this.source = source;
        this.scheduler = configuration.getScheduler();
        this.authorizationProvider = authorizationProvider;
        this.configuration = configuration;
    }

    @Override
    public void start() {
        if (this.pollInterval > 0L) {
            this.future = this.scheduler.scheduleWithFixedDelay(new FileMonitor(), 0L, this.pollInterval, TimeUnit.SECONDS);
            LOGGER.debug("Watching {} with poll interval {}", (Object)this.source.toString(), (Object)this.pollInterval);
        }
        super.start();
    }

    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.future.cancel(true);
        return super.stop(timeout, timeUnit);
    }

    public void registerListener(FilterConfigUpdateListener listener) {
        this.listeners.add(listener);
    }

    @PluginFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public Filter.Result filter(LogEvent event) {
        return this.filter.filter(event);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        return this.filter.filter(logger, level, marker, msg, t);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        return this.filter.filter(logger, level, marker, msg, t);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
        return this.filter.filter(logger, level, marker, msg, params);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0) {
        return this.filter.filter(logger, level, marker, msg, p0);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1) {
        return this.filter.filter(logger, level, marker, msg, p0, p1);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2) {
        return this.filter.filter(logger, level, marker, msg, p0, p1, p2);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3) {
        return this.filter.filter(logger, level, marker, msg, p0, p1, p2, p3);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4) {
        return this.filter.filter(logger, level, marker, msg, p0, p1, p2, p3, p4);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        return this.filter.filter(logger, level, marker, msg, p0, p1, p2, p3, p4, p5);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        return this.filter.filter(logger, level, marker, msg, p0, p1, p2, p3, p4, p5, p6);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        return this.filter.filter(logger, level, marker, msg, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        return this.filter.filter(logger, level, marker, msg, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        return this.filter.filter(logger, level, marker, msg, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The location of the file comes from a configuration value.")
    private static LastModifiedSource getSource(String configLocation) {
        LastModifiedSource source = null;
        try {
            URI uri = new URI(configLocation);
            source = uri.getScheme() != null ? new LastModifiedSource(new URI(configLocation)) : new LastModifiedSource(new File(configLocation));
        }
        catch (Exception ex) {
            source = new LastModifiedSource(new File(configLocation));
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConfigResult getConfig(LastModifiedSource source, AuthorizationProvider authorizationProvider, PropertyEnvironment props, SslConfiguration sslConfiguration) {
        File inputFile = source.getFile();
        ConfigResult configResult = new ConfigResult();
        InputStream inputStream = null;
        HttpInputStreamUtil.Result result = null;
        long lastModified = source.getLastModified();
        try {
            block19: {
                if (inputFile != null && inputFile.exists()) {
                    try {
                        long modified = inputFile.lastModified();
                        if (modified > lastModified) {
                            source.setLastModified(modified);
                            inputStream = new FileInputStream(inputFile);
                            result = new HttpInputStreamUtil.Result(Status.SUCCESS);
                            break block19;
                        }
                        result = new HttpInputStreamUtil.Result(Status.NOT_MODIFIED);
                    }
                    catch (Exception ex) {
                        result = new HttpInputStreamUtil.Result(Status.ERROR);
                    }
                } else if (source.getURI() != null) {
                    try {
                        result = HttpInputStreamUtil.getInputStream(source, props, authorizationProvider, sslConfiguration);
                        inputStream = result.getInputStream();
                    }
                    catch (ConfigurationException ex) {
                        result = new HttpInputStreamUtil.Result(Status.ERROR);
                    }
                } else {
                    result = new HttpInputStreamUtil.Result(Status.NOT_FOUND);
                }
            }
            if (result.getStatus() == Status.SUCCESS) {
                LOGGER.debug("Processing Debug key/value pairs from: {}", (Object)source.toString());
                MutableThreadContextMapFilter.parseJsonConfiguration(inputStream, configResult);
            } else {
                configResult.status = result.getStatus();
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to close {}.", (Object)source, (Object)e);
                    configResult.status = Status.ERROR;
                }
            }
        }
        return configResult;
    }

    private static void parseJsonConfiguration(InputStream inputStream, ConfigResult configResult) {
        block10: {
            try {
                Object wrapper = JsonReader.read((String)new String(inputStream.readAllBytes(), StandardCharsets.UTF_8));
                if (wrapper instanceof Map) {
                    Map configMap;
                    Map wrapperMap = (Map)wrapper;
                    Object config = wrapperMap.get("configs");
                    if (config instanceof Map && (configMap = (Map)config).size() > 0) {
                        ArrayList<KeyValuePair> pairs = new ArrayList<KeyValuePair>();
                        for (Map.Entry entry : configMap.entrySet()) {
                            String key = String.valueOf(entry.getKey());
                            Object jsonArray = entry.getValue();
                            if (jsonArray instanceof List) {
                                List valueList = (List)jsonArray;
                                for (Object value : valueList) {
                                    if (value instanceof String) {
                                        String stringValue = (String)value;
                                        pairs.add(new KeyValuePair(key, stringValue));
                                        continue;
                                    }
                                    LOGGER.warn("Ignoring null value for {}: {}", (Object)key, value);
                                }
                                continue;
                            }
                            LOGGER.warn("Ignoring the value for {}, which is not an array: {}", (Object)key, jsonArray);
                        }
                        if (pairs.size() > 0) {
                            configResult.pairs = pairs.toArray(EMPTY_ARRAY);
                            configResult.status = Status.SUCCESS;
                        } else {
                            configResult.status = Status.EMPTY;
                        }
                        break block10;
                    }
                    LOGGER.debug("No configuration data in {}", wrapper);
                    configResult.status = Status.EMPTY;
                    break block10;
                }
                LOGGER.warn("No configs element in MutableThreadContextMapFilter configuration");
                configResult.status = Status.ERROR;
            }
            catch (Exception ex) {
                LOGGER.warn("Invalid key/value pair configuration, input ignored: {}", (Object)ex.getMessage());
                configResult.status = Status.ERROR;
            }
        }
    }

    private class FileMonitor
    implements Runnable {
        private FileMonitor() {
        }

        @Override
        public void run() {
            PropertyEnvironment properties = MutableThreadContextMapFilter.this.configuration.getContextProperties();
            SslConfiguration sslConfiguration = SslConfigurationFactory.getSslConfiguration(properties);
            ConfigResult result = MutableThreadContextMapFilter.getConfig(MutableThreadContextMapFilter.this.source, MutableThreadContextMapFilter.this.authorizationProvider, properties, sslConfiguration);
            if (result.status == Status.SUCCESS) {
                MutableThreadContextMapFilter.this.filter = ((ThreadContextMapFilter.Builder)((ThreadContextMapFilter.Builder)ThreadContextMapFilter.newBuilder().setPairs(result.pairs).setOperator("or").setOnMatch(MutableThreadContextMapFilter.this.getOnMatch())).setOnMismatch(MutableThreadContextMapFilter.this.getOnMismatch())).setContextDataInjector(MutableThreadContextMapFilter.this.configuration.getComponent(ContextDataInjector.KEY)).get();
                LOGGER.info("Filter configuration was updated: {}", (Object)MutableThreadContextMapFilter.this.filter.toString());
                for (FilterConfigUpdateListener listener : MutableThreadContextMapFilter.this.listeners) {
                    listener.onEvent();
                }
            } else if (result.status == Status.NOT_FOUND) {
                if (!(MutableThreadContextMapFilter.this.filter instanceof NoOpFilter)) {
                    LOGGER.info("Filter configuration was removed");
                    MutableThreadContextMapFilter.this.filter = new NoOpFilter();
                    for (FilterConfigUpdateListener listener : MutableThreadContextMapFilter.this.listeners) {
                        listener.onEvent();
                    }
                }
            } else if (result.status == Status.EMPTY) {
                LOGGER.debug("Filter configuration is empty");
                MutableThreadContextMapFilter.this.filter = new NoOpFilter();
            }
        }
    }

    public static class Builder
    extends AbstractFilter.AbstractFilterBuilder<Builder>
    implements org.apache.logging.log4j.plugins.util.Builder<MutableThreadContextMapFilter> {
        @PluginAttribute
        private String configLocation;
        @PluginAttribute
        private long pollInterval;
        @PluginConfiguration
        private Configuration configuration;

        public Builder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder setPollInterval(long pollInterval) {
            this.pollInterval = pollInterval;
            return this;
        }

        public Builder setConfigLocation(String configLocation) {
            this.configLocation = configLocation;
            return this;
        }

        public MutableThreadContextMapFilter build() {
            AbstractFilter filter;
            LastModifiedSource source = MutableThreadContextMapFilter.getSource(this.configLocation);
            if (source == null) {
                return new MutableThreadContextMapFilter(new NoOpFilter(), null, 0L, null, this.getOnMatch(), this.getOnMismatch(), this.configuration);
            }
            PropertyEnvironment props = this.configuration.getContextProperties();
            AuthorizationProvider authorizationProvider = AuthorizationProvider.getAuthorizationProvider(props);
            SslConfiguration sslConfiguration = SslConfigurationFactory.getSslConfiguration(props);
            if (this.pollInterval <= 0L) {
                ConfigResult result = MutableThreadContextMapFilter.getConfig(source, authorizationProvider, props, sslConfiguration);
                if (result.status == Status.SUCCESS) {
                    filter = result.pairs.length > 0 ? ((ThreadContextMapFilter.Builder)((ThreadContextMapFilter.Builder)ThreadContextMapFilter.newBuilder().setPairs(result.pairs).setOperator("or").setOnMatch(this.getOnMatch())).setOnMismatch(this.getOnMismatch())).setContextDataInjector(this.configuration.getComponent(ContextDataInjector.KEY)).get() : new NoOpFilter();
                } else if (result.status == Status.NOT_FOUND || result.status == Status.EMPTY) {
                    filter = new NoOpFilter();
                } else {
                    LOGGER.warn("Unexpected response returned on initial call: {}", (Object)result.status);
                    filter = new NoOpFilter();
                }
            } else {
                filter = new NoOpFilter();
            }
            if (this.pollInterval > 0L) {
                this.configuration.getScheduler().incrementScheduledItems();
            }
            return new MutableThreadContextMapFilter(filter, source, this.pollInterval, authorizationProvider, this.getOnMatch(), this.getOnMismatch(), this.configuration);
        }
    }

    private static class ConfigResult
    extends HttpInputStreamUtil.Result {
        public KeyValuePair[] pairs;
        public Status status;

        private ConfigResult() {
        }
    }

    public static interface FilterConfigUpdateListener {
        public void onEvent();
    }

    private static class NoOpFilter
    extends AbstractFilter {
        public NoOpFilter() {
            super(Filter.Result.NEUTRAL, Filter.Result.NEUTRAL);
        }
    }
}

