/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.provider.Geographic2Dto3D;
import org.apache.sis.referencing.operation.provider.GeographicRedimension;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.util.WKTUtilities;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.FactoryException;

@XmlTransient
public final class Geographic3Dto2D
extends GeographicRedimension {
    private static final long serialVersionUID = -9103595336196565505L;
    public static final ParameterDescriptorGroup PARAMETERS = ((ParameterBuilder)((ParameterBuilder)Geographic3Dto2D.builder().addIdentifier("9659")).addName("Geographic3D to 2D conversion")).createGroup(new GeneralParameterDescriptor[0]);
    static final GeographicRedimension[] REDIMENSIONED = new GeographicRedimension[4];
    private transient MathTransform transform;

    private Geographic3Dto2D(int indexOfDim) {
        super(PARAMETERS, indexOfDim);
    }

    @Deprecated
    public Geographic3Dto2D() {
        super(REDIMENSIONED[2]);
    }

    @Override
    public AbstractProvider inverse() {
        return REDIMENSIONED[1];
    }

    @Override
    public synchronized MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws FactoryException {
        if (this.transform == null) {
            try {
                MatrixSIS m = Matrices.createDiagonal(4, 3);
                m.setElement(2, 2, 0.0);
                m.setElement(3, 2, 1.0);
                this.transform = MathTransforms.linear(m).inverse();
            }
            catch (NoninvertibleTransformException e) {
                throw new FactoryException((Throwable)e);
            }
        }
        return this.transform;
    }

    static {
        Geographic3Dto2D.REDIMENSIONED[0] = new GeographicRedimension(0, "Identity 2D");
        Geographic3Dto2D.REDIMENSIONED[1] = new Geographic2Dto3D(1);
        Geographic3Dto2D.REDIMENSIONED[2] = new Geographic3Dto2D(2);
        Geographic3Dto2D.REDIMENSIONED[3] = new GeographicRedimension(3, "Identity 3D");
    }

    public static final class WKT
    extends FormattableObject
    implements Parameterized {
        private final boolean inverse;

        public WKT(boolean inverse) {
            this.inverse = inverse;
        }

        @Override
        public ParameterDescriptorGroup getParameterDescriptors() {
            return PARAMETERS;
        }

        @Override
        public ParameterValueGroup getParameterValues() {
            return PARAMETERS.createValue();
        }

        @Override
        protected String formatTo(Formatter formatter) {
            if (this.inverse) {
                formatter.append(new WKT(false));
                return "Inverse_MT";
            }
            WKTUtilities.appendParamMT(this.getParameterValues(), formatter);
            return "Param_MT";
        }
    }
}

