/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.pbf;

import com.google.protobuf.InvalidProtocolBufferException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.zip.DataFormatException;
import org.apache.baremaps.openstreetmap.model.Blob;
import org.apache.baremaps.openstreetmap.model.Bound;
import org.apache.baremaps.openstreetmap.model.Header;
import org.apache.baremaps.openstreetmap.model.HeaderBlock;
import org.apache.baremaps.openstreetmap.stream.StreamException;
import org.apache.baremaps.osm.binary.Osmformat;

public class HeaderBlockReader {
    public static final DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final Blob blob;
    private final Osmformat.HeaderBlock headerBlock;

    public HeaderBlockReader(Blob blob) throws DataFormatException, InvalidProtocolBufferException {
        this.blob = blob;
        this.headerBlock = Osmformat.HeaderBlock.parseFrom(blob.data());
    }

    public HeaderBlock read() {
        LocalDateTime timestamp = LocalDateTime.ofEpochSecond(this.headerBlock.getOsmosisReplicationTimestamp(), 0, ZoneOffset.UTC);
        Long replicationSequenceNumber = this.headerBlock.getOsmosisReplicationSequenceNumber();
        String replicationBaseUrl = this.headerBlock.getOsmosisReplicationBaseUrl();
        String source = this.headerBlock.getSource();
        String writingProgram = this.headerBlock.getWritingprogram();
        Header header = new Header(replicationSequenceNumber, timestamp, replicationBaseUrl, source, writingProgram);
        Osmformat.HeaderBBox headerBBox = this.headerBlock.getBbox();
        double minLon = (double)headerBBox.getLeft() * 1.0E-9;
        double maxLon = (double)headerBBox.getRight() * 1.0E-9;
        double minLat = (double)headerBBox.getBottom() * 1.0E-9;
        double maxLat = (double)headerBBox.getTop() * 1.0E-9;
        Bound bound = new Bound(maxLat, maxLon, minLat, minLon);
        return new HeaderBlock(this.blob, header, bound);
    }

    public static HeaderBlock read(Blob blob) {
        try {
            return new HeaderBlockReader(blob).read();
        }
        catch (InvalidProtocolBufferException | DataFormatException e) {
            throw new StreamException(e);
        }
    }
}

