/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.model;

import java.lang.ref.WeakReference;
import org.apache.logging.log4j.plugins.model.PluginEntry;
import org.apache.logging.log4j.util.Cast;
import org.apache.logging.log4j.util.Lazy;
import org.apache.logging.log4j.util.Strings;

public class PluginType<T> {
    private final PluginEntry pluginEntry;
    private final Lazy<Class<T>> pluginClass;

    public PluginType(PluginEntry pluginEntry, Class<T> pluginClass) {
        this.pluginEntry = pluginEntry;
        this.pluginClass = Lazy.value(pluginClass);
    }

    public PluginType(PluginEntry pluginEntry, ClassLoader classLoader) {
        this.pluginEntry = pluginEntry;
        WeakReference<ClassLoader> classLoaderRef = new WeakReference<ClassLoader>(classLoader);
        this.pluginClass = Lazy.lazy(() -> {
            ClassLoader loader = (ClassLoader)classLoaderRef.get();
            if (loader == null) {
                throw new IllegalStateException("ClassLoader has been destroyed already");
            }
            String className = pluginEntry.className();
            try {
                return (Class)Cast.cast(loader.loadClass(className));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("No class named " + className + " located for element " + pluginEntry.name(), e);
            }
        });
    }

    public PluginEntry getPluginEntry() {
        return this.pluginEntry;
    }

    public Class<T> getPluginClass() {
        return (Class)this.pluginClass.get();
    }

    public String getElementType() {
        return this.pluginEntry.elementType();
    }

    public String getKey() {
        return this.pluginEntry.key();
    }

    public boolean isObjectPrintable() {
        return this.pluginEntry.printable();
    }

    public boolean isDeferChildren() {
        return this.pluginEntry.deferChildren();
    }

    public String getNamespace() {
        return this.pluginEntry.namespace();
    }

    public String getName() {
        return this.pluginEntry.name();
    }

    public String getElementName() {
        return Strings.trimToOptional((String)this.getElementType()).orElseGet(this::getName);
    }

    public String toString() {
        return "PluginType [pluginClass=" + this.pluginClass.toString() + ", key=" + this.pluginEntry.key() + ", elementType=" + this.pluginEntry.elementType() + ", isObjectPrintable=" + this.pluginEntry.printable() + ", isDeferChildren==" + this.pluginEntry.deferChildren() + ", namespace=" + this.pluginEntry.namespace() + "]";
    }
}

