/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff.inflater;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.geotiff.inflater.CompressionChannel;

final class PackBits
extends CompressionChannel {
    private int literalCount;
    private int duplicatedCount;
    private byte duplicated;

    public PackBits(ChannelDataInput input, StoreListeners listeners) {
        super(input, listeners);
    }

    @Override
    public void setInputRegion(long start, long byteCount) throws IOException {
        super.setInputRegion(start, byteCount);
        this.literalCount = 0;
        this.duplicatedCount = 0;
    }

    @Override
    public int read(ByteBuffer target) throws IOException {
        int start = target.position();
        ByteBuffer source = this.input.buffer;
        while (target.hasRemaining()) {
            int n;
            if ((this.literalCount | this.duplicatedCount) == 0) {
                byte code;
                do {
                    if (!this.finished()) continue;
                    int n2 = target.position() - start;
                    return n2 > 0 ? n2 : -1;
                } while ((code = this.input.readByte()) == -128);
                if (code >= 0) {
                    this.literalCount = code + 1;
                } else {
                    this.duplicatedCount = 1 - code;
                    this.duplicated = this.input.readByte();
                }
            }
            if (this.literalCount != 0) {
                n = Math.min(this.literalCount, target.remaining());
                int r = source.remaining();
                if (r == 0) {
                    this.input.ensureBufferContains(Math.min(n, source.capacity()));
                    r = source.remaining();
                }
                if (r <= n) {
                    target.put(source);
                    n = r;
                } else {
                    int limit = source.limit();
                    source.limit(source.position() + n);
                    target.put(source);
                    source.limit(limit);
                }
                this.literalCount -= n;
                continue;
            }
            n = Math.min(this.duplicatedCount, target.remaining());
            PackBits.repeat(target, this.duplicated, n);
            this.duplicatedCount -= n;
        }
        return target.position() - start;
    }
}

