/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.csv;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.baremaps.store.DataColumn;
import org.apache.baremaps.store.DataRow;
import org.apache.baremaps.store.DataSchema;
import org.apache.baremaps.store.DataStoreException;
import org.apache.baremaps.store.DataTable;
import org.locationtech.jts.io.WKTReader;

public class CsvDataTable
implements DataTable {
    private final DataSchema schema;
    private final File csvFile;
    private final CsvSchema csvSchema;
    private final long size;

    public CsvDataTable(DataSchema schema, File csvFile, boolean hasHeader, char separator) throws IOException {
        this.schema = schema;
        this.csvFile = csvFile;
        this.csvSchema = this.buildCsvSchema(schema, hasHeader, separator);
        this.size = this.calculateSize();
    }

    private CsvSchema buildCsvSchema(DataSchema dataSchema, boolean hasHeader, char separator) {
        CsvSchema.Builder builder = CsvSchema.builder();
        for (DataColumn column : dataSchema.columns()) {
            builder.addColumn(column.name());
        }
        return builder.setUseHeader(hasHeader).setColumnSeparator(separator).build();
    }

    private long calculateSize() throws IOException {
        try (JsonParser parser = new CsvMapper().readerFor(Map.class).with((FormatSchema)this.csvSchema).createParser(this.csvFile);){
            long rowCount = 0L;
            while (parser.nextToken() != null) {
                if (parser.currentToken() != JsonToken.START_OBJECT) continue;
                ++rowCount;
            }
            long l = rowCount;
            return l;
        }
    }

    public DataSchema schema() {
        return this.schema;
    }

    public boolean add(DataRow row) {
        throw new UnsupportedOperationException("Adding rows is not supported.");
    }

    public void clear() {
        throw new UnsupportedOperationException("Clearing rows is not supported.");
    }

    public long size() {
        return this.size;
    }

    public Iterator<DataRow> iterator() {
        try {
            CsvMapper csvMapper = new CsvMapper();
            JsonParser parser = csvMapper.readerFor(Map.class).with((FormatSchema)this.csvSchema).createParser(this.csvFile);
            MappingIterator csvIterator = csvMapper.readerFor(Map.class).with((FormatSchema)this.csvSchema).readValues(parser);
            return new Iterator<DataRow>((Iterator)csvIterator){
                final /* synthetic */ Iterator val$csvIterator;
                {
                    this.val$csvIterator = iterator;
                }

                @Override
                public boolean hasNext() {
                    return this.val$csvIterator.hasNext();
                }

                @Override
                public DataRow next() {
                    Map csvRow = (Map)this.val$csvIterator.next();
                    DataRow dataRow = CsvDataTable.this.schema.createRow();
                    for (int i = 0; i < CsvDataTable.this.schema.columns().size(); ++i) {
                        DataColumn column = (DataColumn)CsvDataTable.this.schema.columns().get(i);
                        String columnName = column.name();
                        String value = (String)csvRow.get(columnName);
                        if (value != null) {
                            Object parsedValue = CsvDataTable.this.parseValue(column, value);
                            dataRow.set(i, parsedValue);
                            continue;
                        }
                        dataRow.set(i, null);
                    }
                    return dataRow;
                }
            };
        }
        catch (IOException e) {
            throw new DataStoreException("Error reading CSV file", (Throwable)e);
        }
    }

    private Object parseValue(DataColumn column, String value) {
        DataColumn.Type type = column.type();
        try {
            if (value == null || value.isEmpty()) {
                return null;
            }
            return switch (type) {
                case DataColumn.Type.STRING -> value;
                case DataColumn.Type.INTEGER -> Integer.parseInt(value);
                case DataColumn.Type.LONG -> Long.parseLong(value);
                case DataColumn.Type.FLOAT -> Float.valueOf(Float.parseFloat(value));
                case DataColumn.Type.DOUBLE -> Double.parseDouble(value);
                case DataColumn.Type.BOOLEAN -> Boolean.parseBoolean(value);
                case DataColumn.Type.GEOMETRY, DataColumn.Type.POINT, DataColumn.Type.LINESTRING, DataColumn.Type.POLYGON, DataColumn.Type.MULTIPOINT, DataColumn.Type.MULTILINESTRING, DataColumn.Type.MULTIPOLYGON, DataColumn.Type.GEOMETRYCOLLECTION -> {
                    WKTReader reader = new WKTReader();
                    yield reader.read(value);
                }
                default -> throw new IllegalArgumentException("Unsupported column type: " + String.valueOf(type));
            };
        }
        catch (Exception e) {
            throw new DataStoreException("Error parsing value for column " + column.name(), (Throwable)e);
        }
    }

    public Spliterator<DataRow> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 16);
    }

    public Stream<DataRow> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

