/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.compute;

import java.util.Set;
import java.util.UUID;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.compute.ClientComputeTask;
import org.apache.ignite.internal.processors.platform.client.compute.ClientExecuteTaskResponse;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;

public class ClientExecuteTaskRequest
extends ClientRequest {
    private final Set<UUID> nodeIds;
    private final String taskName;
    private final Object arg;
    private final long timeout;
    private final byte flags;

    public ClientExecuteTaskRequest(BinaryRawReaderEx reader) {
        super(reader);
        int cnt = reader.readInt();
        this.nodeIds = U.newHashSet(cnt);
        for (int i = 0; i < cnt; ++i) {
            this.nodeIds.add(new UUID(reader.readLong(), reader.readLong()));
        }
        this.flags = reader.readByte();
        this.timeout = reader.readLong();
        this.taskName = reader.readString();
        this.arg = reader.readObjectDetached();
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        boolean sysTask = this.systemTask(ctx.kernalContext(), this.taskName);
        ClientComputeTask task = new ClientComputeTask(ctx, sysTask);
        if (!sysTask) {
            ctx.incrementActiveTasksCount();
        }
        long taskId = ctx.resources().put(task);
        try {
            Object arg0 = this.arg;
            if ((this.flags & 4) == 0 && this.arg instanceof BinaryObject) {
                arg0 = ((BinaryObject)this.arg).deserialize();
            }
            task.execute(taskId, this.taskName, arg0, this.nodeIds, this.flags, this.timeout);
        }
        catch (Exception e) {
            ctx.resources().release(taskId);
            throw e;
        }
        return new ClientExecuteTaskResponse(this.requestId(), task);
    }

    private boolean systemTask(GridKernalContext ctx, String taskName) {
        Class<?> cls;
        try {
            cls = U.forName(taskName, U.gridClassLoader());
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
        if (ctx.security().enabled()) {
            return ctx.security().isSystemType(cls);
        }
        return VisorMultiNodeTask.class.isAssignableFrom(cls);
    }
}

