/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.AbstractDataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class DataPageInsertFragmentRecord
extends PageDeltaRecord {
    private final long lastLink;
    @GridToStringExclude
    private final byte[] payload;

    public DataPageInsertFragmentRecord(int grpId, long pageId, byte[] payload, long lastLink) {
        super(grpId, pageId);
        this.lastLink = lastLink;
        this.payload = payload;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        AbstractDataPageIO io = (AbstractDataPageIO)PageIO.getPageIO(pageAddr);
        io.addRowFragment(PageIO.getPageId(pageAddr), pageAddr, this.payload, this.lastLink, pageMem.realPageSize(this.groupId()));
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.DATA_PAGE_INSERT_FRAGMENT_RECORD;
    }

    public int payloadSize() {
        return this.payload.length;
    }

    public byte[] payload() {
        return this.payload;
    }

    public long lastLink() {
        return this.lastLink;
    }

    @Override
    public String toString() {
        return S.toString(DataPageInsertFragmentRecord.class, this, "payloadSize", (Object)this.payload.length, "super", (Object)super.toString());
    }
}

