/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.mapping;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.lang.invoke.CallSite;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.ignite.internal.sql.engine.exec.NodeWithConsistencyToken;
import org.apache.ignite.internal.sql.engine.exec.PartitionWithConsistencyToken;
import org.apache.ignite.internal.sql.engine.exec.mapping.ColocationGroup;
import org.apache.ignite.internal.sql.engine.exec.mapping.MappedFragment;
import org.apache.ignite.internal.sql.engine.prepare.Fragment;
import org.apache.ignite.internal.sql.engine.prepare.IgniteRelShuttle;
import org.apache.ignite.internal.sql.engine.rel.IgniteIndexScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteSender;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableModify;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableScan;
import org.apache.ignite.internal.sql.engine.rel.explain.ExplainUtils;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite.internal.sql.engine.util.Cloner;
import org.apache.ignite.internal.sql.engine.util.Commons;

public final class FragmentPrinter {
    private static final int ATTRIBUTES_INDENT = 2;
    static String FRAGMENT_PREFIX = "Fragment#";
    private final boolean verbose;
    private final Output output;
    private final Int2ObjectMap<IgniteTable> tables;

    private FragmentPrinter(boolean verbose, Output output, Int2ObjectMap<IgniteTable> tables) {
        this.output = output;
        this.tables = tables;
        this.verbose = verbose;
    }

    public static String fragmentsToString(boolean verbose, List<MappedFragment> mappedFragments) {
        TableDescriptorCollector collector = new TableDescriptorCollector();
        for (MappedFragment mappedFragment : mappedFragments) {
            Fragment fragment = mappedFragment.fragment();
            collector.collect(fragment);
        }
        Output output = new Output();
        for (MappedFragment mappedFragment : mappedFragments) {
            FragmentPrinter printer = new FragmentPrinter(verbose, output, collector.tables);
            printer.print(mappedFragment);
            output.writeNewline();
        }
        return output.builder.toString();
    }

    private static IgniteDistribution deriveDistribution(IgniteRel rel) {
        if (rel instanceof IgniteSender) {
            return ((IgniteSender)rel).sourceDistribution();
        }
        return rel.distribution();
    }

    private void print(MappedFragment mappedFragment) {
        Fragment fragment = mappedFragment.fragment();
        this.output.setNewLinePadding(0);
        this.output.writeString(FRAGMENT_PREFIX + fragment.fragmentId());
        if (fragment.rootFragment()) {
            this.output.writeString(" root");
        }
        if (fragment.correlated()) {
            this.output.writeString(" correlated");
        }
        this.output.setNewLinePadding(2);
        this.output.writeNewline();
        this.output.writeKeyValue("distribution", FragmentPrinter.deriveDistribution(mappedFragment.fragment().root()).label());
        this.output.writeKeyValue("executionNodes", mappedFragment.nodes().toString());
        if (this.verbose) {
            Object sourcesByExchangeId;
            ColocationGroup target = mappedFragment.target();
            if (target != null) {
                List sortedNodeNames = target.nodeNames().stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
                this.output.writeKeyValue("targetNodes", sortedNodeNames.toString());
            }
            if ((sourcesByExchangeId = mappedFragment.sourcesByExchangeId()) != null) {
                this.output.writeKeyValue("exchangeSourceNodes", sourcesByExchangeId.long2ObjectEntrySet().stream().map(e -> Map.entry(e.getLongKey(), new TreeSet((Collection)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).toString());
            }
            TreeMap orderedColocationGroups = new TreeMap(mappedFragment.groupsBySourceId());
            for (Map.Entry entry : orderedColocationGroups.entrySet()) {
                ColocationGroup group = (ColocationGroup)entry.getValue();
                this.appendColocationGroup((Long)entry.getKey(), group);
            }
        }
        Int2ObjectOpenHashMap tableIdToNodeNameToPartitionsMap = new Int2ObjectOpenHashMap();
        for (ColocationGroup group : mappedFragment.groups()) {
            LongListIterator longListIterator = group.sourceIds().iterator();
            while (longListIterator.hasNext()) {
                long l = (Long)longListIterator.next();
                IgniteTable table = (IgniteTable)mappedFragment.fragment().tables().get(l);
                if (table == null) continue;
                int tableId = table.id();
                for (String nodeName : group.nodeNames()) {
                    Map nodeNameToPartitionsMap = null;
                    for (PartitionWithConsistencyToken partitionsWithToken : group.partitionsWithConsistencyTokens(nodeName)) {
                        if (nodeNameToPartitionsMap == null) {
                            nodeNameToPartitionsMap = (Map)tableIdToNodeNameToPartitionsMap.computeIfAbsent(tableId, k -> new HashMap());
                        }
                        nodeNameToPartitionsMap.computeIfAbsent(nodeName, k -> new BitSet()).set(partitionsWithToken.partId());
                    }
                }
            }
        }
        if (!tableIdToNodeNameToPartitionsMap.isEmpty()) {
            String partitionsAsString = tableIdToNodeNameToPartitionsMap.int2ObjectEntrySet().stream().map(e -> {
                IgniteTable table = (IgniteTable)this.tables.get(e.getIntKey());
                String tableName = table == null ? "<unknown table with id=" + String.valueOf(e.getValue()) + ">" : table.name();
                return tableName + "=" + ((Map)e.getValue()).entrySet().stream().map(n2p -> (String)n2p.getKey() + "=" + String.valueOf(n2p.getValue())).collect(Collectors.joining(", ", "[", "]"));
            }).collect(Collectors.joining(", ", "[", "]"));
            this.output.writeKeyValue("partitions", partitionsAsString);
        }
        this.output.writeKeyValue("tree", "");
        this.output.setNewLinePadding(2);
        IgniteRel clonedRoot = Cloner.clone(mappedFragment.fragment().root(), Commons.cluster());
        this.output.writeString(ExplainUtils.toString(clonedRoot, 4));
    }

    private void appendColocationGroup(long sourceId, ColocationGroup group) {
        StringBuilder sb = new StringBuilder();
        sb.append('{').append("nodes=").append(new TreeSet<String>(group.nodeNames())).append(", sourceIds=").append(new TreeSet(group.sourceIds())).append(", assignments=");
        TreeMap<CallSite, CallSite> assignments = new TreeMap<CallSite, CallSite>();
        for (Int2ObjectMap.Entry entry : group.assignments().int2ObjectEntrySet()) {
            String assignment = ((NodeWithConsistencyToken)entry.getValue()).name() + ":" + ((NodeWithConsistencyToken)entry.getValue()).enlistmentConsistencyToken();
            assignments.put((CallSite)((Object)("part_" + entry.getIntKey())), (CallSite)((Object)assignment));
        }
        sb.append(assignments).append(", partitionsWithConsistencyTokens=");
        TreeMap<String, String> partitionWithConsistencyTokens = new TreeMap<String, String>();
        for (String nodeName : group.nodeNames()) {
            List<PartitionWithConsistencyToken> ppPerNode = group.partitionsWithConsistencyTokens(nodeName);
            List pps = ppPerNode.stream().map(p -> "part_" + p.partId() + ":" + p.enlistmentConsistencyToken()).sorted().collect(Collectors.toList());
            partitionWithConsistencyTokens.put(nodeName, pps.toString());
        }
        sb.append(partitionWithConsistencyTokens).append('}');
        this.output.writeKeyValue("colocationGroup[" + sourceId + "]", sb.toString());
    }

    private static class Output {
        private final StringBuilder builder = new StringBuilder();
        private int newLinePadding;
        private String paddingString = " ";
        private boolean blankLine;

        private Output() {
        }

        void writeKeyValue(String name, String value) {
            this.appendPadding();
            this.builder.append(name).append(": ").append(value);
            this.writeNewline();
        }

        void writeString(String value) {
            this.builder.append(value);
        }

        void setPaddingStr(String val) {
            this.paddingString = val;
        }

        void setNewLinePadding(int value) {
            this.newLinePadding = value;
        }

        void writeNewline() {
            this.blankLine = true;
            this.builder.append(System.lineSeparator());
        }

        private void appendPadding() {
            boolean wasBlank = this.blankLine;
            if (wasBlank && this.newLinePadding > 0) {
                this.builder.append(this.paddingString.repeat(this.newLinePadding));
            }
            if (wasBlank) {
                this.blankLine = false;
            }
        }
    }

    private static class TableDescriptorCollector
    extends IgniteRelShuttle {
        private final Int2ObjectMap<IgniteTable> tables = new Int2ObjectOpenHashMap();

        private TableDescriptorCollector() {
        }

        void collect(Fragment fragment) {
            fragment.root().accept(this);
        }

        @Override
        public IgniteRel visit(IgniteIndexScan rel) {
            IgniteTable igniteTable = (IgniteTable)rel.getTable().unwrap(IgniteTable.class);
            this.tables.put(igniteTable.id(), (Object)igniteTable);
            return super.visit(rel);
        }

        @Override
        public IgniteRel visit(IgniteTableScan rel) {
            IgniteTable igniteTable = (IgniteTable)rel.getTable().unwrap(IgniteTable.class);
            this.tables.put(igniteTable.id(), (Object)igniteTable);
            return super.visit(rel);
        }

        @Override
        public IgniteRel visit(IgniteTableModify rel) {
            IgniteTable igniteTable = (IgniteTable)rel.getTable().unwrap(IgniteTable.class);
            this.tables.put(igniteTable.id(), (Object)igniteTable);
            return super.visit(rel);
        }
    }
}

