/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestContentType {
    TestContentType() {
    }

    @Test
    void testApplicationZipCompressed() {
        ContentType contentType = ContentType.create((String)"application/x-zip-compressed");
        Assertions.assertEquals((Object)contentType.toString(), (Object)ContentType.APPLICATION_ZIP_COMPRESSED.toString());
        Assertions.assertTrue((boolean)contentType.isSameMimeType(ContentType.APPLICATION_ZIP_COMPRESSED));
        Assertions.assertTrue((boolean)ContentType.APPLICATION_ZIP_COMPRESSED.isSameMimeType(contentType));
    }

    @Test
    void testBasis() throws Exception {
        ContentType contentType = ContentType.create((String)"text/plain", (String)"US-ASCII");
        Assertions.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assertions.assertEquals((Object)StandardCharsets.US_ASCII, (Object)contentType.getCharset());
        Assertions.assertEquals((Object)"text/plain; charset=US-ASCII", (Object)contentType.toString());
    }

    @Test
    void testWithCharset() throws Exception {
        ContentType contentType = ContentType.create((String)"text/plain", (String)"US-ASCII");
        Assertions.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assertions.assertEquals((Object)StandardCharsets.US_ASCII, (Object)contentType.getCharset());
        Assertions.assertEquals((Object)"text/plain; charset=US-ASCII", (Object)contentType.toString());
        contentType = contentType.withCharset(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assertions.assertEquals((Object)"UTF-8", (Object)contentType.getCharset().name());
        Assertions.assertEquals((Object)"text/plain; charset=UTF-8", (Object)contentType.toString());
    }

    @Test
    void testWithCharsetString() throws Exception {
        ContentType contentType = ContentType.create((String)"text/plain", (String)"US-ASCII");
        Assertions.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assertions.assertEquals((Object)StandardCharsets.US_ASCII, (Object)contentType.getCharset());
        Assertions.assertEquals((Object)"text/plain; charset=US-ASCII", (Object)contentType.toString());
        contentType = contentType.withCharset(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assertions.assertEquals((Object)StandardCharsets.UTF_8, (Object)contentType.getCharset());
        Assertions.assertEquals((Object)"text/plain; charset=UTF-8", (Object)contentType.toString());
    }

    @Test
    void testLowCaseText() throws Exception {
        ContentType contentType = ContentType.create((String)"Text/Plain", (String)"ascii");
        Assertions.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assertions.assertEquals((Object)StandardCharsets.US_ASCII, (Object)contentType.getCharset());
    }

    @Test
    void testCreateInvalidInput() {
        Assertions.assertThrows(NullPointerException.class, () -> ContentType.create(null, (String)null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ContentType.create((String)"  ", (String)null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ContentType.create((String)"stuff;", (String)null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ContentType.create((String)"text/plain", (String)","));
    }

    @Test
    void testParse() throws Exception {
        ContentType contentType = ContentType.parse((CharSequence)"text/plain; charset=\"ascii\"");
        Assertions.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assertions.assertEquals((Object)StandardCharsets.US_ASCII, (Object)contentType.getCharset());
        Assertions.assertEquals((Object)"text/plain; charset=ascii", (Object)contentType.toString());
    }

    @Test
    void testParseMultiparam() throws Exception {
        ContentType contentType = ContentType.parse((CharSequence)"text/plain; charset=\"ascii\"; p0 ; p1 = \"blah-blah\"  ; p2 = \" yada yada \" ");
        Assertions.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assertions.assertEquals((Object)StandardCharsets.US_ASCII, (Object)contentType.getCharset());
        Assertions.assertEquals((Object)"text/plain; charset=ascii; p0; p1=blah-blah; p2=\" yada yada \"", (Object)contentType.toString());
        Assertions.assertNull((Object)contentType.getParameter("p0"));
        Assertions.assertEquals((Object)"blah-blah", (Object)contentType.getParameter("p1"));
        Assertions.assertEquals((Object)" yada yada ", (Object)contentType.getParameter("p2"));
        Assertions.assertNull((Object)contentType.getParameter("p3"));
    }

    @Test
    void testParseEmptyCharset() throws Exception {
        ContentType contentType = ContentType.parse((CharSequence)"text/plain; charset=\" \"");
        Assertions.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assertions.assertNull((Object)contentType.getCharset());
    }

    @Test
    void testParseDefaultCharset() throws Exception {
        ContentType contentType = ContentType.parse((CharSequence)"text/plain; charset=\" \"");
        Assertions.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assertions.assertNull((Object)contentType.getCharset());
        Assertions.assertEquals((Object)StandardCharsets.US_ASCII, (Object)contentType.getCharset(StandardCharsets.US_ASCII));
        Assertions.assertNull((Object)contentType.getCharset(null));
        Assertions.assertNull((Object)ContentType.getCharset((ContentType)contentType, null));
        Assertions.assertEquals((Object)StandardCharsets.US_ASCII, (Object)ContentType.getCharset((ContentType)contentType, (Charset)StandardCharsets.US_ASCII));
    }

    @Test
    void testParseEmptyValue() throws Exception {
        Assertions.assertNull((Object)ContentType.parse(null));
        Assertions.assertNull((Object)ContentType.parse((CharSequence)""));
        Assertions.assertNull((Object)ContentType.parse((CharSequence)"   "));
        Assertions.assertNull((Object)ContentType.parse((CharSequence)";"));
        Assertions.assertNull((Object)ContentType.parse((CharSequence)"="));
    }

    @Test
    void testWithParamArrayChange() throws Exception {
        BasicNameValuePair[] params = new BasicNameValuePair[]{new BasicNameValuePair("charset", "UTF-8"), new BasicNameValuePair("p", "this"), new BasicNameValuePair("p", "that")};
        ContentType contentType = ContentType.create((String)"text/plain", (NameValuePair[])params);
        Assertions.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assertions.assertEquals((Object)StandardCharsets.UTF_8, (Object)contentType.getCharset());
        Assertions.assertEquals((Object)"text/plain; charset=UTF-8; p=this; p=that", (Object)contentType.toString());
        Arrays.setAll(params, i -> null);
        Assertions.assertEquals((Object)"this", (Object)contentType.getParameter("p"));
        Assertions.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assertions.assertEquals((Object)StandardCharsets.UTF_8, (Object)contentType.getCharset());
        Assertions.assertEquals((Object)"text/plain; charset=UTF-8; p=this; p=that", (Object)contentType.toString());
    }

    @Test
    void testWithParams() throws Exception {
        ContentType contentType = ContentType.create((String)"text/plain", (NameValuePair[])new NameValuePair[]{new BasicNameValuePair("charset", "UTF-8"), new BasicNameValuePair("p", "this"), new BasicNameValuePair("p", "that")});
        Assertions.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assertions.assertEquals((Object)StandardCharsets.UTF_8, (Object)contentType.getCharset());
        Assertions.assertEquals((Object)"text/plain; charset=UTF-8; p=this; p=that", (Object)contentType.toString());
        contentType = contentType.withParameters(new NameValuePair[]{new BasicNameValuePair("charset", "ascii"), new BasicNameValuePair("p", "this and that")});
        Assertions.assertEquals((Object)"text/plain", (Object)contentType.getMimeType());
        Assertions.assertEquals((Object)StandardCharsets.US_ASCII, (Object)contentType.getCharset());
        Assertions.assertEquals((Object)"text/plain; charset=ascii; p=\"this and that\"", (Object)contentType.toString());
        contentType = ContentType.create((String)"text/blah").withParameters(new NameValuePair[]{new BasicNameValuePair("p", "blah")});
        Assertions.assertEquals((Object)"text/blah", (Object)contentType.getMimeType());
        Assertions.assertNull((Object)contentType.getCharset());
        Assertions.assertEquals((Object)"text/blah; p=blah", (Object)contentType.toString());
        contentType = ContentType.create((String)"text/blah", (Charset)StandardCharsets.ISO_8859_1).withParameters(new NameValuePair[]{new BasicNameValuePair("p", "blah")});
        Assertions.assertEquals((Object)"text/blah", (Object)contentType.getMimeType());
        Assertions.assertEquals((Object)StandardCharsets.ISO_8859_1, (Object)contentType.getCharset());
        Assertions.assertEquals((Object)"text/blah; charset=ISO-8859-1; p=blah", (Object)contentType.toString());
    }
}

